;*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
;* File Name          : M8P516_Touch_Lib_CFG.ASM
;* Author             : MASSES CHIP
;* Version            : V2.07
;* Date               : 2025/12/10
;********************************************************************************

;================================================================================
#include     zc.inc
#include     M8R_P_MACRO.inc 
#include     M8P516_Touch_Lib.inc   
#include     M8P516_Touch_Lib_CFG.INC  
 
;================================================================================  
 CODE 
 
;================================================================================        
#if TKLib_TouchLowerPower 
 ;FUNC 
 GLOBAL _WDT_WakeUp_Handle 
#endif 

 GLOBAL _ScanNextChannel 
 GLOBAL _TkSignalHandle_Next 
 
 extern TKCOM_PIN_OUT
 extern _READ_TK_EN_MASK_DATA 
 
 extern TAB_TOUCH_FN_DATA 
 extern _RChannelEnL    

 extern _RTkTemp9    
#define RTkmaskL        _RTkTemp9

 extern _RTkTemp2 
#define berror_F        _RTkTemp2,4 

 extern _RTkTemp4 
#define _R_CNT          _RTkTemp4


 extern _RTkBuff1 
#define RTk_CH            _RTkBuff1



 EXTERN     _RTkBitFlag 


;==================================================================== 
#if TKLib_TouchLowerPower
_WDT_WakeUp_Handle:
; Stack:	Level 1
; INPUT:	 
; OUTPUT:	
; OTHER	:
;此程序是在触摸低功耗模式下，需要处理的操作，如有需要可增加操作程序  
;如RTC时钟1S计时程序,LCD时钟刷新显示程序等等
  

; bclr  bLowPowerModeRun ; 可根据需求，判断系统是否需要强制唤醒(清bLowPowerModeRun，强制唤醒系统)
                         
    return 
#endif
;==================================================================== 

;================================================================================  
; 以下用户可不查看
;================================================================================    
;==================================================================== 
_ScanNextChannel:
; Stack:	Level 3
; INPUT:	 
; OUTPUT:	
; OTHER	:	

    CALL    TKCOM_PIN_OUT 	

; set tk ch	
    clrr    TKCHS  ;关闭所有连接的通道

;CLR TK CH CAPS	
    MOVIA   0XF0
    ANDAR	  TKCTR1,R ;CLR CAPS
	
    movia   high(TAB_TOUCH_FN_DATA)
    movar   FSR1
    movia   low(TAB_TOUCH_FN_DATA)
    movar   FSR0	

#if EnTk0		
    jbts0   _RChannelEnL,0
    goto    scantk0_set
#endif

#if EnTk1	    
    jbts0   _RChannelEnL,1
    goto    scantk1_set
#endif

#if EnTk2	    
    jbts0   _RChannelEnL,2
    goto    scantk2_set
#endif

#if EnTk3	    
    jbts0   _RChannelEnL,3
    goto    scantk3_set
#endif

#if EnTk4	    
    jbts0   _RChannelEnL,4
    goto    scantk4_set
#endif

    bset    bOneScanDone
    CALL    _READ_TK_EN_MASK_DATA  
    goto    ScanNextChannel_end ;error	
    
#if EnTk0		
scantk0_set:
    bclr    _RChannelEnL,0	 
    bset    TKCHS,0  		
    goto    ScanNextChannel_end_1			
#endif

#if EnTk1		
scantk1_set:
    bclr    _RChannelEnL,1		 
    bset    TKCHS,1  		
    goto    ScanNextChannel_end_1	
#endif

#if EnTk2		 
scantk2_set:
    bclr    _RChannelEnL,2		 
    bset    TKCHS,2  		
    goto    ScanNextChannel_end_1
#endif

#if EnTk3	
scantk3_set:
    bclr    _RChannelEnL,3	 
    bset    TKCHS,3  		
    goto    ScanNextChannel_end_1
#endif

#if EnTk4	
scantk4_set:
    bclr    _RChannelEnL,4	 
    bset    TKCHS,4  		
    goto    ScanNextChannel_end_1
#endif



	
ScanNextChannel_end_1:
    incr    RTk_CH,r
    movr    RTk_CH,A

    addar   FSR0,r	
    rdt
    ORAR    TKCTR1,R   ;SELECT CAPS	
    
ScanNextChannel_end:	
    CLRR    _R_CNT	
    return	
 
;==================================================================== 
_TkSignalHandle_Next: 
; Stack:	Level 1
; INPUT:	 
; OUTPUT:	
; OTHER	:

;read finger&noise data
    clrr    RTkmaskL 

    movia   high(TAB_TOUCH_FN_DATA)
    movar   FSR1
    movia   low(TAB_TOUCH_FN_DATA)
    movar   FSR0	 

#if EnTk0	 
    jbts0   _RChannelEnL,0
    goto    READ_tk0_FN
#endif

#if EnTk1    
    jbts0   _RChannelEnL,1
    goto    READ_tk1_FN
#endif

#if EnTk2    
    jbts0   _RChannelEnL,2
    goto    READ_tk2_FN
#endif

#if EnTk3    
    jbts0   _RChannelEnL,3
    goto    READ_tk3_FN
#endif

#if EnTk4    
    jbts0   _RChannelEnL,4
    goto    READ_tk4_FN
#endif

#if EnTk0 
READ_tk0_FN:
    bset     RTkmaskL,0
    bclr     _RChannelEnL,0	 	
    goto     READ_tkx_FN_end_1			
#endif

#if EnTk1	
READ_tk1_FN:
    bset     RTkmaskL,1
    bclr     _RChannelEnL,1	 		
    goto     READ_tkx_FN_end_1	
#endif

#if EnTk2	 
READ_tk2_FN:
    bset     RTkmaskL,2 
    bclr     _RChannelEnL,2		 
    goto     READ_tkx_FN_end_1
#endif

#if EnTk3
READ_tk3_FN:
    bset     RTkmaskL,3 
    bclr     _RChannelEnL,3	 	
    goto     READ_tkx_FN_end_1
#endif

#if EnTk4
READ_tk4_FN:
    bset     RTkmaskL,4 
    bclr     _RChannelEnL,4	 	
    goto     READ_tkx_FN_end_1
#endif
	 
READ_tkx_FN_end_1:

    return
  

;================================================================================  
  end
  
;*********************************END OF FILE************************************

                                   