;*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
;* File Name          : MAIN.ASM
;* Author             : MASSES CHIP
;* Version            : V2.07
;* Date               : 2025/12/10
;********************************************************************************
; 
; 16M/4T, WDT EN 72MS, RST IS IO ,BOR 2.4V,RST TIMER 18MS
;********************************************************************************
;================================================================================  
#include     zc.inc 
#include     M8R_P_MACRO.inc 
;================================================================================  
#include     M8P516_Touch_Lib.inc
#include     M8P516_Touch_Lib_Data.inc 
#include     M8P516_Touch_UartDebug_LIB_Init.INC
;================================================================================  
 CODE 
;================================================================================  
userdata  udata 0
R_Time_Flag                 RES 1  
#define bT_125US_F    R_Time_Flag,0
#define	bT_500US_F    R_Time_Flag,1
#define	bT_10MS_F     R_Time_Flag,2


R_500US_COUNT               RES 1
R_10MS_COUNT                RES 1

R_GOTOLOWPOWERMODE_COUNT    RES 1

;====================================================================
;此段为模拟串口定义数据不可删除
#if TKUartDebugLib_DEBUG_UART_SELECT
UartData   res    1
UartCnt    res   1
 GLOBAL UartData
 GLOBAL UartCnt
#endif

;====================================================================   
; T0 BASE TIME  SET
#define	T0_125_US                     125   
#define T0_LOAD_C_Init	              T0_125_US*16000000/16/1000000 ; FOSC 1:16

#define T_500US_C_Init_DF             D'4'
#define T_10MS_C_Init_DF              D'20'
#define T_GOTOLOWPOWERMODE_C_Init_DF  D'250'  ;无触摸下超时休眠检测次数，无触摸下超时休眠时间 = 次数*触摸通道检测数*0.5ms
;====================================================================                   
    org     .0
	GOTO    MainProgram
           
    org     .8
ISR_Handle:
    push

T0_ISR:
    jbts0   bTC0IE
    GOTO    ISR_T0_Handle

ISR_Handle_END:
    pop
    retie    
;====================================================================   
ISR_T0_Handle:
    jbts1   bTC0IF
    GOTO    ISR_Handle_END
;    BSET    bT_125US_F

    DJZR    R_500US_COUNT,R
    GOTO    ISR_T0_Handle_END
    MOVI    R_500US_COUNT,T_500US_C_Init_DF
    BSET    bT_500US_F

TK_BASETIMER:
;触摸库需要的时基，不可删除，但可以调整位置，即只需要产生下列时基即可
;校准基准时基
    INCR    RTK_CaliBaseTime_Cnt,R
    MOVIA   (TKLib_CaliBaseTime-1)
    JLAR    RTK_CaliBaseTime_Cnt    
    GOTO    TK_BASETIMER_END
    CLRR    RTK_CaliBaseTime_Cnt
    BSET    bT_TK_CBT_F   ;必须定时产生此标志

;长按长按保护检测基准时基 
    INCR    RTK_LongKeyBaseTime_Cnt,R
    MOVIA   (TKLib_LongKeyBaseTime-1)
    JLAR    RTK_LongKeyBaseTime_Cnt    
    GOTO    TK_BASETIMER_END
    CLRR    RTK_LongKeyBaseTime_Cnt
    BSET    bT_TK_LBT_F   ;若开启长按保护，必须定时产生此标志

TK_BASETIMER_END:

    DJZR    R_10MS_COUNT,R
    GOTO    ISR_T0_Handle_END
    MOVI    R_10MS_COUNT,T_10MS_C_Init_DF
    BSET    bT_10MS_F

ISR_T0_Handle_END:
    BCLR    bTC0IF
    GOTO    ISR_Handle_END
	
;==================================================================== 
MainProgram:
    call    Init
#if TKUartDebugLib_DEBUG_UART_SELECT
	call	_TK_TouchUartDebug_Init
#endif

    call    _TkInit
	CALL	T0_INIT	
MainLoop:
    CALL    _TkScan          ;主循环一直查询
    JBTS1   bOneScanDone     ;查询一轮是否转换结束    
    goto    MainLoop_1
	
	call    _TkSignalHandle 
	BCLR    bOneScanDone     ;一轮转换完成,清除标志
#if TKUartDebugLib_DEBUG_UART_SELECT
	bclr	INTCR0,TC0IE
	call	_TK_TouchUartDebug
	bset	INTCR0,TC0IE
#endif
BZ_End:
; 按键响应
    CJZ1 _RKeyOnFlgL,ALLKEY_UP_Handle ;检查是否有按键被按下
    MOVI R_GOTOLOWPOWERMODE_COUNT,T_GOTOLOWPOWERMODE_C_Init_DF
	
    ; jbts0   F_TK2_On
    ; nop	
    ; jbts0   F_TK3_On
    ; nop
	
    goto    ALLKEY_UP_Handle_end
    	
ALLKEY_UP_Handle:
;全部按键松开
    DJZR    R_GOTOLOWPOWERMODE_COUNT,R
    GOTO    ALLKEY_UP_Handle_end
    MOVI    R_GOTOLOWPOWERMODE_COUNT,T_GOTOLOWPOWERMODE_C_Init_DF

#if TKLib_TouchLowerPower 	
    BSET    bLowPowerModeRun   ;按键松开超过设定时间，置 bLowPowerModeRun 即允许睡眠
#endif 

ALLKEY_UP_Handle_end:

#if TKLib_TouchLowerPower 
    JBTS1   bLowPowerModeRun 
    goto    Next_OneScan

;下面加睡眠前其它需要低功耗处理的操作(除触摸外的，触摸相关的_TkLowPowerMode会自行处理)	
;如低功耗模式下端口处理，外设模块等
;WDT 与 CPU 工作模式 用户不需要处理

    BCLR    INTCR0,TC0IE   ;关闭其他唤醒源，本demo code外部只打开了T0，固只关闭T0

    movia   b'00000000'    ;tk
    movar   ANSA
    movia   b'00000000'			;//
    movar   IOA
    movia	b'11111111'        ;// 1：output  0：input	
    movar   OEA


	;bclr tkctr0,7
;触摸低功耗模式	
    call    _TkLowPowerMode

;下面加唤醒后其它需要恢复的操作
	call	T0_INIT
	
#endif 

Next_OneScan:
    CALL    _ScanContinue	;必须在_TkLowPowerMode 后面调用，且保证清除bOneScanDone后，一定能调用此程序
	
; 其它主循环程序
MainLoop_1:
    CLRWDT

    goto    MainLoop  
 
;====================================================================                                                 
init: 
; Stack:	Level 5
IO_init:
;触摸口建议设置成输出模式。如输出全0或全1  

    movia   b'00000000'  ;tk
    movar   ANSA
	
    movia   b'00000000'			;//
    movar   IOA

    movia	b'11111111'        ;// 1：output  0：input	
    movar   OEA
    

RAM_INIT:	
ClrRam:        
    clrr    fsr0     ;0x00
ClrRam_loop:
    clrr    indf0
    incr    fsr0,r
    movr    fsr0,a
    jcmpai  low(0x3f+1)   ;0xff (clr ram addar +1)
    goto    ClrRam_loop
ClrRam_end:	

; RAM 数据赋值
    MOVI    R_500US_COUNT,T_500US_C_Init_DF
    MOVI    R_10MS_COUNT,T_10MS_C_Init_DF	
    MOVI    R_GOTOLOWPOWERMODE_COUNT,T_GOTOLOWPOWERMODE_C_Init_DF	
RAM_INIT_END:
    RETURN

TK_INIT:
;TK 
  ;  call    _TkInit
TK_INIT_END:
	
T0_INIT:
    CLRR    TC0CH
    MOVIA   T0_LOAD_C_Init
    MOVAR   TC0CL
	
    MOVIA   b'10001100'	; 16Mhz, 16分频, 
    MOVAR   T0CR
    BSET    bTC0IE
T0_INIT_END:

;ENALBE gie	
    bset    option,gie	
	
    return 

;====================================================================
     END 
	 
;*********************************END OF FILE************************************
                                   
