;*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
;* File Name          : M8P5170_Touch_Lib_Data.INC
;* Author             : MASSES CHIP
;* Version            : V1.05
;* Date               : 2025/12/18
;********************************************************************************

;本文件不建议用户修改

;================================================================================ 
#include     M8P5170_Touch_Lib_CFG.INC 
;================================================================================ 

;================================================================================ 
;触摸库RAM分配起始地址，不建议修改，或保证修改后有足够地址分配到触摸库使用
; RAM RTKLibGroup0 分配的起始地址 ~ 0x3f 被触摸库中使用
RTKLibGroup0 udata (0x3f+1-11-6-6-7*TKLib_OPENED_TK_AMOUNT)  
;================================================================================ 
;12
_RTkTemp0        res        1
_RTkTemp1        res        1
_RTkTemp2        res        1 
_RTkTemp3        res        1 
_RTkTemp4        res        1 
_RTkTemp5        res        1
_RTkTemp6        res        1          
_RTkTemp7        res        1         
_RTkTemp8        res        1
_RTkTemp9        res        1        
_RTkTemp10       res        1   

_RTkBuff0        res        1
_RTkBuff1        res        1  
_RTkBuff2        res        1 

_RChannelEnL     res        1              
_RKeyOnFlgL      res        1
_RTkBitFlag      res        1 

#if  TKLib_OPENED_TK_AMOUNT
_RTkGBuff0       res        2*TKLib_OPENED_TK_AMOUNT   ;        
_RTkGBuff1       res        2*TKLib_OPENED_TK_AMOUNT         
_RTkGBuff2       res        1*TKLib_OPENED_TK_AMOUNT
_RTkGBuff3       res        1*TKLib_OPENED_TK_AMOUNT
_RTkGBuff4       res        6
_RTkGBuff5       res        1*TKLib_OPENED_TK_AMOUNT
#endif
;================================================================================
#if (TKLib_TKMODE > 1)
    Error "    Error: Please setting TKLib_TKMODE ∈ {0,1}  "  
#endif

#if (TKLib_TKMODE == 0)
    MESSG "    触摸工作模式: 电荷转移模式"
#if (TKLib_TKCKS < 2)
#define TKLib_TK_VCMPS               3
	MESSG "    电压补偿: 开启3倍补偿"  
#else
#if (TKLib_TKCKS == 2)
#define TKLib_TK_VCMPS               2
	MESSG "    电压补偿: 开启2倍补偿"  
#else	
#if (TKLib_TKCKS > 2)
#define TKLib_TK_VCMPS               1
	MESSG "    电压补偿: 开启1倍补偿"  
#endif
#endif
#endif
#endif

#if (TKLib_TKMODE == 1)
    MESSG "    触摸工作模式: 振荡模式,灵敏度高" 
#define TKLib_TK_VCMPS  			3
#endif

;================================================================================  
; 程序区   ~ 0x03EF，用户不可使用
;================================================================================ 
TAB_TOUCH_CFG_DATA:
 org    (0x03FF+1-12-TKLib_OPENED_TK_AMOUNT)

TAB_TOUCH_TK_EN_MASK_L_DATA:
 RETIA     (TKLib_TK_EN_MASK&0X00FF)
 
TAB_TOUCH_OPENED_TK_AMOUNT_DATA: 
 RETIA     (TKLib_OPENED_TK_AMOUNT&0x0F) 
 
TAB_TOUCH_TKCKS_DATA: 
 RETIA     ((0x01<<7)+((TKLib_TK_VCS&0x01)<<5)+((TKLib_TK_VLS&0x01)<<4)+((TKLib_TKMODE&0x01)<<3)+((TKLib_TKCKS&0x07)<<0)) 

TAB_TOUCH_TK_VCS_VCHG_DATA: 
 RETIA     (TKLib_TK_VCMPS&0x03)

TAB_TOUCH_NUM_DATA:
 RETIA     (((TKLib_TOUCH_NUM&0x0F)<<0)+((TKLib_Multi_TOUCH_RST&0x01)<<7))

TAB_TOUCH_LONG_TOUCH_TIME:  
 RETIA     (TKLib_LONG_TOUCH_TIME&0x0F)
 
TAB_TOUCH_CONFIRM_TIME_DATA: 
 RETIA     ((TKLib_EFFECTIVE_TOUCH_TIME&0x0F)+((TKLib_INVALID_TOUCH_TIME&0x0F)<<4))

TAB_TOUCH_SCAN_DATA:
 RETIA     (TKLib_ScanCnt-1)
  
TAB_TOUCH_BASELINE_UP_SPEED:
 RETIA		(TKLib_BaseLineUpSpeed&0x0f)
 
TAB_TOUCH_BASELINE_DOWN_SPEED:
 RETIA		(TKLib_BaseLineDownSpeed&0x0f)
 
TAB_TOUCH_HIGHSENSITIVITY:
 RETIA		(TKLib_HighSensitivity&0x01) 

TAB_TOUCH_FN_DATA: 
#if EnTk0  
 DW     (((TKLib_TK0_F_THRESHOLD&0xff)<<8) + (EnTk0<<0))
#endif

#if EnTk1 
 DW     (((TKLib_TK1_F_THRESHOLD&0xff)<<8) + (EnTk1<<1))
#endif

#if EnTk2 
 DW     (((TKLib_TK2_F_THRESHOLD&0xff)<<8) + (EnTk2<<2))
#endif

#if EnTk3 
 DW     (((TKLib_TK3_F_THRESHOLD&0xff)<<8) + (EnTk3<<3))
#endif

#if EnTk4 
 DW     (((TKLib_TK4_F_THRESHOLD&0xff)<<8) + (EnTk4<<4))
#endif

#if EnTk5 
 DW     (((TKLib_TK5_F_THRESHOLD&0xff)<<8) + (EnTk5<<5))
#endif
;================================================================================         
 ; RAM
 GLOBAL _RTkTemp0   
 GLOBAL _RTkTemp1   
 GLOBAL _RTkTemp2    
 GLOBAL _RTkTemp3   
 GLOBAL _RTkTemp4  
 GLOBAL _RTkTemp5      
 GLOBAL _RTkTemp6    
 GLOBAL _RTkTemp7    
 GLOBAL _RTkTemp8    
 GLOBAL _RTkTemp9    
 GLOBAL _RTkTemp10   

 GLOBAL _RTkBitFlag     
 GLOBAL _RKeyOnFlgL     
 GLOBAL _RChannelEnL     
 
 GLOBAL _RTkBuff0 
 GLOBAL _RTkBuff1
 GLOBAL _RTkBuff2 

 GLOBAL _RTkGBuff0     
 GLOBAL _RTkGBuff1    
 GLOBAL _RTkGBuff2     
 GLOBAL _RTkGBuff3 
 GLOBAL _RTkGBuff4 
 GLOBAL _RTkGBuff5 
 ; CODE
 GLOBAL TAB_TOUCH_TK_EN_MASK_L_DATA 
 GLOBAL TAB_TOUCH_OPENED_TK_AMOUNT_DATA           
 GLOBAL TAB_TOUCH_TKCKS_DATA   
 GLOBAL TAB_TOUCH_TK_VCS_VCHG_DATA 
 GLOBAL TAB_TOUCH_NUM_DATA
 GLOBAL TAB_TOUCH_LONG_TOUCH_TIME
 GLOBAL TAB_TOUCH_CONFIRM_TIME_DATA 
 GLOBAL TAB_TOUCH_SCAN_DATA
 GLOBAL	TAB_TOUCH_BASELINE_UP_SPEED
 GLOBAL	TAB_TOUCH_BASELINE_DOWN_SPEED
 GLOBAL TAB_TOUCH_FN_DATA 
 GLOBAL TAB_TOUCH_HIGHSENSITIVITY
;================================================================================
#if 1         ; 0:关闭触摸配置信息提示，1:开启触摸配置信息提示
;================================================================================
;CDC MODE
#if EnTk0
    MESSG "    TK0: Enable"  
#endif
#if EnTk1
    MESSG "    TK1: Enable"  
#endif
#if EnTk2
    MESSG "    TK2: Enable"  
#endif
#if EnTk3
    MESSG "    TK3: Enable"  
#endif
#if EnTk4
    MESSG "    TK4: Enable"  
#endif
#if EnTk5
    MESSG "    TK5: Enable"  
#endif
;================================================================================
#if (TKLib_OPENED_TK_AMOUNT == 0)
    Error "    No channel is enabled,Please reconfigure EnTk0~EnTk5"  
#endif	
;================================================================================
;CDC clock
#if (TKLib_TKCKS > 7)
    Error "    Error: Please setting TKLib_TKCKS <= 7 "  
#endif
#if (TKLib_TKCKS == 0)
    MESSG "    CDC Clock: Fosc/2"  
#endif
#if (TKLib_TKCKS == 1)
    MESSG "    CDC Clock: Fosc/4"  
#endif
#if (TKLib_TKCKS == 2)
    MESSG "    CDC Clock: Fosc/6"  
#endif
#if (TKLib_TKCKS == 3)
    MESSG "    CDC Clock: Fosc/8" 
#endif
#if (TKLib_TKCKS == 4)
    MESSG "    CDC Clock: Fosc/10" 
#endif
#if (TKLib_TKCKS == 5)
    MESSG "    CDC Clock: Fosc/12" 
#endif
#if (TKLib_TKCKS == 6)
    MESSG "    CDC Clock: Fosc/14" 
#endif
#if (TKLib_TKCKS == 7)
    MESSG "    CDC Clock: Fosc/16" 
#endif
;================================================================================
#if (TKLib_TOUCH_NUM == 0)
    Error "    Error: Please setting TKLib_TOUCH_NUM > 0"  
#endif
;================================================================================
#if (TKLib_LONG_TOUCH_TIME == 0)
    MESSG "    屏蔽按键最长输出时间功能，即触摸不离开，按键标志一直会置位 " 
#endif
#if (TKLib_LONG_TOUCH_TIME == 1)
    Error "    禁止配置 " 
#endif
#if (TKLib_LONG_TOUCH_TIME > 15)
    Error "    Error: Please setting TKLib_LONG_TOUCH_TIME <= 15"  
#else
#if (TKLib_LONG_TOUCH_TIME > 1)
    MESSG "    开启按键最长输出时间功能，若触摸不离开，按键标志会输出一段时间后，会清零 " 
#endif
#endif
;================================================================================
#if (TKLib_TouchLowerPower == 1)
    MESSG "    触摸低功耗模式：已开启，配置字WDT使能必须选择始终开启WDT功能，建议WDT溢出时间选用72ms " 
#endif 
#if (TKLib_TouchLowerPower == 0)
    MESSG "    触摸低功耗模式：未开启 "
#endif  
#if (TKLib_TouchLowerPower > 1)
    MESSG "    触摸低功耗模式：配置错误，TKLib_TouchLowerPower ∈ {0,1} "	
#endif
;================================================================================
#if (TKLib_Multi_TOUCH_RST > 1)
    Error "    Error: Please setting TKLib_Multi_TOUCH_RST ∈ {0,1}  "  
#endif
;================================================================================
#if (TKLib_LongKeyBaseTime < 1)
    Error "    Error: Please setting TKLib_LongKeyBaseTime >= 1" 
#endif
#if (TKLib_LongKeyBaseTime > 254)
    Error "    Error: Please setting TKLib_LongKeyBaseTime <= 254"  
#endif
;================================================================================
#if (TKLib_EFFECTIVE_TOUCH_TIME == 0)
    Error "    Error: Please setting TKLib_EFFECTIVE_TOUCH_TIME > 0"  
#endif
#if (TKLib_EFFECTIVE_TOUCH_TIME > 14)
    Error "    Error: Please setting TKLib_EFFECTIVE_TOUCH_TIME <= 14"  
#endif
;================================================================================
#if (TKLib_INVALID_TOUCH_TIME == 0)
    Error "    Error: Please setting TKLib_INVALID_TOUCH_TIME > 0"  
#endif
#if (TKLib_INVALID_TOUCH_TIME > 14)
    Error "    Error: Please setting TKLib_INVALID_TOUCH_TIME <= 14"  
#endif
;================================================================================
#if (TKLib_TK0_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK0_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK1_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK1_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK2_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK2_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK3_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK3_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK4_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK4_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK5_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK5_F_THRESHOLD <= 254"  
#endif
;================================================================================
#if (TKLib_TK0_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK0_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK1_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK1_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK2_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK2_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK3_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK3_F_THRESHOLD >= 8"  
#endif
#if (TKLib_TK4_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK4_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK5_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK5_F_THRESHOLD >= 8"
#endif
;================================================================================
;CDC VCS
#if (TKLib_TK_VCS > 1)
    Error "    Error: Please setting TKLib_TK_VCS <= 1 "  
#endif

#if (TKLib_TK_VCS == 0)
    MESSG "    触摸充电电压: 2.2V"  
#endif
#if (TKLib_TK_VCS == 1)
    MESSG "    触摸充电电压: VDD "   
#endif
;================================================================================
;CDC VLS
#if (TKLib_TK_VLS > 1)
    Error "    Error: Please setting TKLib_TK_VLS  ∈ {0,1} "  
#endif
#if (TKLib_TKMODE == 0)
#if (TKLib_TK_VLS == 0)
    MESSG "    触摸参考电压: 0.50 * 触摸充电电压"   
#endif
#if (TKLib_TK_VLS == 1)
    MESSG "    触摸参考电压: 0.75 * 触摸充电电压"   
#endif
#else
#if (TKLib_TK_VLS == 0)
    MESSG "    触摸参考振荡频率: 低"   
#endif
#if (TKLib_TK_VLS == 1)
    MESSG "    触摸参考振荡频率: 高" 
#endif
#endif
;================================================================================
#if (TKLib_ScanCnt < 3 )
    Error "    Error: Please setting TKLib_ScanCnt >= 3"  
#endif
#if (TKLib_ScanCnt > 254)
    Error "    Error: Please setting TKLib_ScanCnt < 255"  
#endif
;================================================================================
#if (TKLib_BaseLineUpSpeed < 1 )
    Error "    Error: Please setting TKLib_BaseLineUpSpeed >= 1"  
#endif
#if (TKLib_BaseLineUpSpeed > 14)
    Error "    Error: Please setting TKLib_BaseLineUpSpeed < 15"  
#endif
;================================================================================
#if (TKLib_BaseLineDownSpeed < 1 )
    Error "    Error: Please setting TKLib_BaseLineDownSpeed >= 1"  
#endif
#if (TKLib_BaseLineDownSpeed > 14)
    Error "    Error: Please setting TKLib_BaseLineDownSpeed < 15"  
#endif
;================================================================================
#if (TKLib_HighSensitivity > 1 )
    Error "    Error: Please setting TKLib_HighSensitivity ∈ {0,1} "  
#endif
;================================================================================
#endif

;*********************************END OF FILE************************************
                                 