;*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
;* File Name          : MAIN.ASM
;* Author             : MASSES CHIP
;* Version            : V1.05
;* Date               : 2025/12/18
;********************************************************************************
; 
; 16M/4T, WDT EN 72MS, RST IS IO ,BOR 2.4V,RST TIMER 18MS
;********************************************************************************
   	 
;================================================================================  
#include     zc.inc  
#include     M8R_P_MACRO.inc 
;================================================================================  
#include     M8P5170_Touch_Lib.inc
#include     M8P5170_Touch_Lib_Data.inc 
#include     M8P5170_Touch_UartDebug_LIB_Init.INC  
;================================================================================  
 CODE 
;================================================================================  
userdata  	udata 	   0

R_Time_Flag                 res 	1  
#define bT_125US_F    R_Time_Flag,0
#define	bT_500US_F    R_Time_Flag,1

#if TKLib_TouchLowerPower 
R_10mS_COUNT         		res     1
R_GOTOLOWPOWERMODE_COUNT    res 	1
#define	bT_10MS_F     R_Time_Flag,2
#define T_GOTOLOWPOWERMODE_C_Init_DF  D'200'  ;无触摸下超时休眠检测次数，无触摸下超时休眠时间 = 次数*10ms
#endif

R_500US_COUNT               res 	1
;====================================================================
;此段为模拟串口定义数据不可删除
#if TKUartDebugLib_DEBUG_UART_SELECT
UartData    res      1
UartCnt     res      1
 GLOBAL UartData
 GLOBAL UartCnt
#endif
;====================================================================   
; T0 BASE TIME  SET
#define T_500US_C_Init_DF             D'8'
#define T_10MS_C_Init_DF              D'20'
#define TKLib_CaliBaseTime            D'195'  
;====================================================================                   
    org     .0
	GOTO    MainProgram
           
    org     .8
ISR_Handle:
    push

T1_ISR:
    jbts0   bTC1IE
    GOTO    ISR_T1_Handle

ISR_Handle_END:
    pop
    retie  
      
;====================================================================   
ISR_T1_Handle:
;TC1产生64us中断时间
    jbts1   bTC1IF
    GOTO    ISR_Handle_END
    DJZR    R_500US_COUNT,R
    GOTO    ISR_T1_Handle_END
    MOVI    R_500US_COUNT,T_500US_C_Init_DF
TK_BASETIMER:
;触摸库需要的时基，不可删除，但可以调整位置，即只需要产生下列时基即可
;校准基准时基
    INCR    RTK_CaliBaseTime_Cnt,R
    MOVIA   (TKLib_CaliBaseTime-1)
    JLAR    RTK_CaliBaseTime_Cnt    
    GOTO    TK_BASETIMER_END
    CLRR    RTK_CaliBaseTime_Cnt

;长按长按保护检测基准时基 
    INCR    RTK_LongKeyBaseTime_Cnt,R
    MOVIA   (TKLib_LongKeyBaseTime-1)
    JLAR    RTK_LongKeyBaseTime_Cnt    
    GOTO    TK_BASETIMER_END
    CLRR    RTK_LongKeyBaseTime_Cnt
    BSET    bT_TK_LBT_F   ;若开启长按保护，必须定时产生此标志

TK_BASETIMER_END:

;10MS
if  TKLib_TouchLowerPower	
    DJZR    R_10MS_COUNT,R
    GOTO    ISR_T1_Handle_END
    MOVI    R_10MS_COUNT,T_10MS_C_Init_DF
    BSET    bT_10MS_F
#endif

ISR_T1_Handle_END:
    BCLR    bTC1IF
    GOTO    ISR_Handle_END
	
;==================================================================== 
MainProgram:
    call    Init
#if TKUartDebugLib_DEBUG_UART_SELECT
	call	_TK_TouchUartDebug_Init
#endif
    call    _TkInit
	CALL	T1_INIT	
MainLoop:
    CALL    _TkScan          ;主循环一直查询
    JBTS1   bOneScanDone     ;查询一轮是否转换结束    
    goto    MainLoop_1
	
	call    _TkSignalHandle 
	BCLR    bOneScanDone     ;一轮转换完成,清除标志

#if TKUartDebugLib_DEBUG_UART_SELECT
	bclr	option,gie	
	call	_TK_TouchUartDebug
	bset    option,gie	
#endif

#if TKLib_TouchLowerPower 
; 按键响应
    CJZ1 _RKeyOnFlgL,ALLKEY_UP_Handle ;检查是否有按键被按下
    MOVI R_GOTOLOWPOWERMODE_COUNT,T_GOTOLOWPOWERMODE_C_Init_DF
	goto	Next_OneScan	
 		
ALLKEY_UP_Handle:
;全部按键松开
	JBTS1   bT_10MS_F
	goto	Next_OneScan
	bclr	bT_10MS_F
    DJZR    R_GOTOLOWPOWERMODE_COUNT,R
	goto	Next_OneScan
    MOVI    R_GOTOLOWPOWERMODE_COUNT,T_GOTOLOWPOWERMODE_C_Init_DF
    BSET    bLowPowerModeRun   ;按键松开超过设定时间，置 bLowPowerModeRun 即允许睡眠

;下面加睡眠前其它需要低功耗处理的操作(除触摸外的，触摸相关的_TkLowPowerMode会自行处理)	
;如低功耗模式下端口处理，外设模块等
;WDT 与 CPU 工作模式 用户不需要处理
    BCLR    INTCR0,TC1IE   ;关闭其他唤醒源，本demo code外部只打开了T1，固只关闭T1

;触摸低功耗模式	
    call    _TkLowPowerMode

;下面加唤醒后其它需要恢复的操作
	call	T1_INIT
#endif 

Next_OneScan:
    CALL    _ScanContinue	;必须在_TkLowPowerMode 后面调用，且保证清除bOneScanDone后，一定能调用此程序
	
; 其它主循环程序
MainLoop_1:
    CLRWDT
; 按键处理部分程序	
	CALL	KEY_TASK
	
    goto    MainLoop 
	
;==================================================================== 
; 按键处理部分程序	
KEY_TASK:
	; jbts0   F_TK0_On
    ; nop	
    ; jbts0   F_TK1_On
    ; nop
	return
 
;====================================================================                                                 
init: 
; Stack:	Level 5
IO_init:
;触摸口建议设置成输出模式。如输出全0或全1  

    movia   b'00000000'		
    movar   IOA

    movia	b'00111111'        ;1：output  0：input	
    movar   OEA
	
	movia	b'00000000'        
    movar   PUA
    
; 清RAM
RAM_INIT:	
ClrRam:        
    clrr    fsr0     ;0x00
ClrRam_loop:
    clrr    indf0
    incr    fsr0,r
    movr    fsr0,a
    jcmpai  low(0x3f+1)   ;0xff (clr ram addar +1)
    goto    ClrRam_loop
ClrRam_end:	

; RAM 数据赋值
    MOVI    R_500US_COUNT,T_500US_C_Init_DF
#if TKLib_TouchLowerPower
    MOVI	R_10MS_COUNT,T_10MS_C_Init_DF
    MOVI    R_GOTOLOWPOWERMODE_COUNT,T_GOTOLOWPOWERMODE_C_Init_DF
#endif	
RAM_INIT_END:
    RETURN

; TC1定时器初始化，定时时间64us
T1_INIT:	
    bset    T1CR,0
    bset    INTCR0,TC1IE
T1_INIT_END:
;ENALBE gie	
    bset    option,gie	
    return 

;====================================================================
     END 
	 
;*********************************END OF FILE************************************
                                   
