/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
* File Name          : M8P5170_Touch_Lib_CFG.H
* Author             : MASSES CHIP
* Version            : V1.05
* Date               : 2025/12/18    
********************************************************************************/

//================================================================================
#ifndef __M8P5170_Touch_Lib_CFG_H__
#define __M8P5170_Touch_Lib_CFG_H__
//================================================================================
//  触摸正常模式设定
//================================================================================
// 设置CDC模块需要检测的通道  0: 该通道按键不检测；1: 该通道按键需检测。
#define EnTk0    	1
#define EnTk1    	0
#define EnTk2    	0
#define EnTk3    	0
#define EnTk4    	0 // 电荷转移模式下此通道不可用
#define EnTk5    	0

//设置触摸工作模式                    0->电荷转移模式(需外接电容), 1->振荡模式(无需外接电容) 建议使用电荷转移模式
#define TKLib_TKMODE                  0

//设置确认允许响应的最多按键数量     (1 <= value <= TKLib_OPENED_TK_AMOUNT)
#define TKLib_TOUCH_NUM               1
   
//设置手指触摸最长有效时间           (0<= value <=15) ; 0: 屏蔽此功能；1: 禁止配置；2~15：时间 = value*长按保护检测基准时基
#define TKLib_LONG_TOUCH_TIME         15

//设置长按保护检测基准时基           (1<= value <=254) ; 可根据时基需求调整
//长按保护检测基准时基 = TKLib_LongKeyBaseTime * 100ms，默认10 * 100ms ≈ 1S，可根据时基需求修改
#define TKLib_LongKeyBaseTime         10

//电荷转移模式：CDC时钟分频选择位     0->Fosc/2, 1->Fosc/4, 2->Fosc/6, 3->Fosc/8, 4->Fosc/10, 5->Fosc/12, 6->Fosc/14, 7->Fosc/16;
//振荡模式：设置值越大,灵敏度越高    (0<= value <=7),;
#define TKLib_TKCKS                   1

//设置手指有效触摸检测次数,值越小灵敏度越高,值越大抗干扰越好      
//									 (1<= value<=14) 
#define TKLib_EFFECTIVE_TOUCH_TIME    5

//设置手指无效触摸检测次数,值越小灵敏度越高,值越大抗干扰越好  
//   								 (1<= value<=14)
#define TKLib_INVALID_TOUCH_TIME      4

//基值上升更新速度,一般不需要修改	 (1<= value<=14)
#define TKLib_BaseLineUpSpeed         10

//基值下降更新速度,一般不需要修改	 (1<= value<=14)
#define TKLib_BaseLineDownSpeed       10

//设置当被响应按键超过允许响应的最多按键数量时，是否需要复位触摸      
//                                    0->不复位触摸系统, 1->复位触摸系统 ; 一般不需要修改
#define TKLib_Multi_TOUCH_RST         1

//触摸数据采集次数,值越小灵敏度越高,不需要更改
//									 (3<= value< =254)	
#define TKLib_ScanCnt         		  10

// 触摸高灵敏度选择,开启后灵敏度高1倍 0：关闭高灵敏度		1：开启高灵敏度
//									 (0<= value< =1)	
#define TKLib_HighSensitivity         0 
//================================================================================
//触摸阈值： 取值需具体应用环境决定，最小8，最大254，值越小越灵敏
#define TKLib_TK0_F_THRESHOLD         20
#define TKLib_TK1_F_THRESHOLD         20
#define TKLib_TK2_F_THRESHOLD         20
#define TKLib_TK3_F_THRESHOLD         20
#define TKLib_TK4_F_THRESHOLD         20  
#define TKLib_TK5_F_THRESHOLD         20
//================================================================================
//触摸充电电压选择                   (0<= value<=1) ; 0->2.2V,1->VDD  一般不需要修改
//                                    注：必需保证IC 供电VDD > 设置充电电压 + 0.5V
//电荷转移模式                        设置值越大，灵敏度越低
//振荡模式                            设置值越大，灵敏度越高
#define TKLib_TK_VCS                  0  
//================================================================================
//触摸参考电压选择(电荷转移模式) 	 (0<= value<=1) ; 0->0.50*VCHG ,1->0.75*VCHG  一般不需要修改
//触摸参考振荡频率选择(振荡模式      (0<= value<=1) ; 0->低,1->高
//触摸灵敏度                          设置值越大，灵敏度越高
#define TKLib_TK_VLS                  1
//================================================================================
//触摸省电模式设定，一般运用请关闭此模式
//================================================================================
//设置触摸低功耗模式是否开启  		  0: 不使用触摸省电模式；1: 使用触摸省电模式
//休眠时间采用WDT时间，配置字WDT使能选择，必须选择始终开启WDT功能,建议WDT溢出时间选择72ms
#define TKLib_TouchLowerPower         0
//================================================================================
//以下用户不可修改
//================================================================================
#define TKLib_OPENED_TK_AMOUNT   (EnTk0+EnTk1+EnTk2+EnTk3+EnTk4+EnTk5)
#define TKLib_TK_EN_MASK         ((EnTk0<<0)|(EnTk1<<1)|(EnTk2<<2)|(EnTk3<<3)|(EnTk4<<4)|(EnTk5<<5))               
//================================================================================
#endif

//*********************************END OF FILE************************************

                             
