/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
* File Name          : M8P5170_Touch_UartDebug_LIB_Init.C
* Author             : MASSES CHIP
* Version            : V1.05
* Date               : 2025/12/18   
********************************************************************************

*******************************************************************************/
//================================================================================
#include "zc.h"
#include "M8P5170_Touch_UartDebug_LIB_Init.H"
//================================================================================
extern unsigned char RTkTemp1;  
extern unsigned char RTkTemp2;
// 此段为模拟串口定义数据不可删除
#if (TKUartDebugLib_DEBUG_UART_SELECT == 1)
unsigned char UartData;
unsigned char UartCnt;  
#endif
//====================================================================
#if (TKUartDebugLib_DEBUG_UART_SELECT == 1)
void TASK_UART_DATATX(void)
{
  __asm;
	movia   9
	bclr    P_UART_TX,N_UART_TX
    movar	_UartCnt
    goto	UartTX_Star_Bit_End    
LoopSend_Bit:
	jbts1	_UartData,0                 
	goto	UartTX_Bit_0               
UartTX_Bit_1_1:
	goto	UartTX_Bit_1               
UartTX_Bit_1:                          
    bset    P_UART_TX,N_UART_TX               
	goto	UartTX_Bit_End             
UartTX_Bit_0:
    bclr    P_UART_TX,N_UART_TX                 
	goto	UartTX_Bit_End             
UartTX_Bit_End:
    rrrnc   _UartData,r                 
UartTX_Star_Bit_End:                   
	nop
	nop
	nop
	nop
	nop
	goto    $+1
	goto    $+1
	goto    $+1
	goto    $+1
	goto    $+1
	goto    $+1
	goto    $+1
	goto    $+1
	movia	0
	jncmpar	_UartCnt
	return
    djzr    _UartCnt,r
	goto    LoopSend_Bit
	nop
	goto	UartTX_Bit_1_1
  __endasm;
}
#endif
//================================================================================
#if (TKUartDebugLib_DEBUG_UART_SELECT == 1)
void TK_TouchUartDebug_Init(void)
{
	__asm;	
	MESSG "    串口调试功能：已开启，请调试结束后关闭" 
    MESSG "    串口调试端口：使用的是IO软件模拟，端口可根据需求配置，软件串口使用的是定时器TC1，若与其它程序有冲突，请做调整 "	
#if (N_UART_TX==5)
	bset	PUA,N_UART_TX
#endif
	//初始化设置输出
	bset	OE_UART_TX,N_UART_TX
	bset	P_UART_TX,N_UART_TX
  __endasm;
}
#endif
//================================================================================
#if (TKUartDebugLib_DEBUG_UART_SELECT == 1)
void TK_Debug_Mode_Uart_SendChar(void)
{
  __asm;
	MOVAR   _UartData
	CALL    _TASK_UART_DATATX
  __endasm;
}
#endif
//================================================================================
#if (TKUartDebugLib_DEBUG_UART_SELECT == 1)
void TK_Debug_Mode_SendWord(void)
{
  __asm;
	MOVR	_RTkTemp2,a		
	MOVAR	_UartData 
	CALL	_TASK_UART_DATATX
	
	MOVR	_RTkTemp1,a		
	MOVAR	_UartData
	CALL	_TASK_UART_DATATX	
  __endasm;
}
#endif
//================================================================================

//*********************************END OF FILE************************************
