/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
* File Name          : MAIN.C
* Author             : MASSES CHIP
* Version            : V1.05
* Date               : 2025/12/18  
********************************************************************************
 16M/4T, WDT EN 72MS, RST IS IO ,BOR 2.4V,RST TIMER 18MS

*******************************************************************************/

//===============================================================================
#include "zc.h"
#include "MassesChip_Define.h"
#include "M8P5170_Touch_Lib.h"
#include "M8P5170_Touch_Lib_CFG.H"
#include "M8P5170_Touch_UartDebug_LIB_Init.h"
//===============================================================================

//====================================================================
// T0 BASE TIME  SET
#define T_500US_C_Init_DF            8
#define TKLib_CaliBaseTime           195  

ob8 R_Time_Flag;
#define	bT_500US_F    R_Time_Flag.b0
#define	bT_10MS_F     R_Time_Flag.b1

unsigned char R_500US_COUNT  = T_500US_C_Init_DF;

#if TKLib_TouchLowerPower
#define T_GOTOLOWPOWERMODE_C_Init_DF 200
#define T_10MS_C_Init_DF             20
unsigned char R_GOTOLOWPOWERMODE_COUNT  = 0;  //无触摸下超时休眠检测次数，无触摸下超时休眠时间 ≈ 次数*10ms
unsigned char R_10MS_COUNT  = T_10MS_C_Init_DF;
#endif

// 关键寄存器备份寄存器，若中断中确保没用到，可删除对应代码，这样可节约寄存器
//unsigned char FSR0_BKR;
//unsigned char FSR1_BKR;
//unsigned char HBUF_BKR;
//===============================================================================
void KEY_TASK(void);
void SysInit(void);
//================================================================================
//main函数
//================================================================================
void main(void)
{
	SysInit();
#if TKUartDebugLib_DEBUG_UART_SELECT
	TK_TouchUartDebug_Init();
#endif
	TkInit();
	GIE =1;
	while(1)
	{
		__CLRWDT();
		TkScan();    //主循环一直扫描，故主循环间隔不宜过长以免影响响应时间
		/*查询一轮是否转换结束*/
		if(bOneScanDone)
		{     
#if TKUartDebugLib_DEBUG_UART_SELECT
			GIE =0;
			TK_TouchUartDebug(); //串口调试
			GIE =1;
#endif
			TkSignalHandle(); //一轮转换完成,数据处理
			bOneScanDone = 0; //一轮转换完成,清除标志
			
			KEY_TASK();  //按键标志用户处理
			
#if TKLib_TouchLowerPower
			if(!RKeyOnFlgL)
			{
				//全部按键松开
				if(bT_10MS_F)
				{
					bT_10MS_F = 0;
					if(++R_GOTOLOWPOWERMODE_COUNT > T_GOTOLOWPOWERMODE_C_Init_DF)
					{
						R_GOTOLOWPOWERMODE_COUNT = 0;
						bLowPowerModeRun = 1; //按键松开超过设定时间，置 bLowPowerModeRun 即允许睡眠
					}
				}
			}
			else
			{	
				R_GOTOLOWPOWERMODE_COUNT = 0;	
			}
			if(bLowPowerModeRun&&bBaseLineUpdateOK)
			{
//下面加睡眠前其它需要低功耗处理的操作(除触摸外的，触摸相关的TkLowPowerMode()会自行处理)
				TC1IE=0; //关闭其他唤醒源，本demo code外部只打开了T1，故只关闭T1
//触摸低功耗模式
				TkLowPowerMode();
//下面加唤醒后其它需要恢复的操作
				T1CR |= 0x01;
				TC1IE = 1;
			}
#endif
			ScanContinue();  //必须在TkLowPowerMode() 后面调用，且保证清除bOneScanDone后，一定能调用此程序
		}
    /* User code */
	}
}

//================================================================================
//中断处理程序
//================================================================================
void int_isr(void) __interrupt
{
	__PUSH();
//----------------------------------------
// 备份关键寄存器，若中断中确保没用到，可删除对应代码，这样可节约寄存器
//	FSR0_BKR = FSR0;
//	FSR1_BKR = FSR1;
//	HBUF_BKR = HBUF;
//----------------------------------------
//TC1产生64us中断时间
	if(TC1IE)
	{
		if(TC1IF)
		{
			TC1IF = 0;
			if(--R_500US_COUNT==0)
			{
				R_500US_COUNT = T_500US_C_Init_DF;
				bT_500US_F = 1;
				//触摸更新时基，必须保证标志正常
				if(++RTK_CaliBaseTime_Cnt >= TKLib_CaliBaseTime)
				{
					RTK_CaliBaseTime_Cnt = 0;
					if(++RTK_LongKeyBaseTime_Cnt >= TKLib_LongKeyBaseTime)
					{
						RTK_LongKeyBaseTime_Cnt = 0;
						bT_TK_LBT_F = 1;
					}
				}
#if TKLib_TouchLowerPower
				if(--R_10MS_COUNT==0)
				{
					R_10MS_COUNT = T_10MS_C_Init_DF;
					bT_10MS_F = 1;
				}
#endif
			}
		}
	}

//----------------------------------------
// 备份关键寄存器，若中断中确保没用到，可删除对应代码，这样可节约寄存器
//	FSR0 = FSR0_BKR;
//	FSR1 = FSR1_BKR;
//	HBUF = HBUF_BKR;
//----------------------------------------
	__POP();
}
//================================================================================
//触摸按键处理
//================================================================================
void KEY_TASK(void)
{
	if(F_TK0_On)
	{
	  //注：添加__NOP();只是为了防止编译器报错，具体功能请根据需求增加
	  __NOP();
	}
	else if(F_TK1_On)
	{
	  __NOP();
	}
	/*else if(F_TK3_On)
	{
	  __NOP();
	}
	else
	{
	  __NOP();
	}*/
}
//================================================================================
//触摸口设置成输出模式,输出全0  
//================================================================================
void SysInit(void)
{
	//IO_Init:触摸口设置成输出模式,输出全0  
	OEA = Bin(00111111);  //1:output  0:input
	PUA = Bin(00000000);  
	IOA = 0;
	
	//T1_Init:TC1定时器初始化，定时64us 
	T1CR |= 0x01;
	TC1IE = 1;
	
	//InitalRAM:RAM初始化清零
	__asm
	clrr    FSR0          //0x00
_ClrRam_loop:
	clrr    INDF0
	incr    FSR0,r
	movr    FSR0,a
	jcmpai  low(0x3f+1)   //0x7f+1
	goto    _ClrRam_loop
	__endasm;	
}
//================================================================================
// 在触摸低功耗模式下，需要处理的操作在此添加
//================================================================================
#if TKLib_TouchLowerPower
void WDT_WakeUp_Handle(void)
{
//此程序是在触摸低功耗模式下，需要处理的操作，如有需要可增加操作程序  
//如RTC时钟1S计时程序,LCD时钟刷新显示程序等等
  
// bLowPowerModeRun = 0 ; //可根据需求，判断系统是否需要强制唤醒(清bLowPowerModeRun，强制唤醒系统)  
}
#endif

/*********************************END OF FILE************************************/

