;*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
;* File Name          : M8P615_Touch_UartDebug_LIB_Init.ASM
;* Author             : MASSES CHIP
;* Version            : V2.04
;* Date               : 2025/12/10
;********************************************************************************
; 
; 
;
;********************************************************************************

#include zc.inc
#include M8R_P_MACRO.inc 
#include M8P615_Touch_UartDebug_LIB_Init.INC

;================================================================================
#if TKUartDebugLib_DEBUG_UART_SELECT 
 GLOBAL _TK_TouchUartDebug_Init   
 GLOBAL _TK_Debug_Mode_Uart_SendChar   
 GLOBAL _TK_Debug_Mode_SendWord   
#endif 
;================================================================================ 
 extern _RTkTemp1   
 extern _RTkTemp2

#if (TKUartDebugLib_DEBUG_UART_SELECT==1) 
 extern UartData
 extern UartCnt
#endif	
 
;================================================================================
 
 CODE
 
;================================================================================
#if TKUartDebugLib_DEBUG_UART_SELECT

 
_TK_TouchUartDebug_Init:
; Stack:	Level 1
; INPUT:	 
; OUTPUT:	
; OTHER	:	
    MESSG "    串口调试功能：已开启，请调试结束后关闭" 
	MESSG "    软件模拟波特率为 115200 不可修改" 
    MESSG "    串口调试端口：使用的是IO软件模拟，端口可根据需求配置，若与其它程序有冲突，请做调整 "	
#if (N_UART_TX==5)
;	bset	PUA,N_UART_TX
#endif
	;初始化设置输出
	bset	OE_UART_TX,N_UART_TX
	bset	P_UART_TX,N_UART_TX
	
	return
   
#endif	   

;================================================================================
#if TKUartDebugLib_DEBUG_UART_SELECT 
_TK_Debug_Mode_Uart_SendChar:
; Stack:	Level 1
; INPUT:	ACC 
; OUTPUT:	
; OTHER	:
	MOVAR   UartData
	CALL    _TASK_UART_DATATX
	return 
#endif

;================================================================================
#if TKUartDebugLib_DEBUG_UART_SELECT 	
_TK_Debug_Mode_SendWord:
; Stack:	Level 1
; INPUT:	RTkTemp1&RTkTemp2 
; OUTPUT:	
; OTHER	:
	MOV		UartData,_RTkTemp2  ;high
	CALL	_TASK_UART_DATATX
	
    MOV    	UartData,_RTkTemp1	;low
	CALL	_TASK_UART_DATATX		
    return
#endif

 
;====================================================================
; 
;====================================================================
#if TKUartDebugLib_DEBUG_UART_SELECT
_TASK_UART_DATATX:
    bclr    Uart_IO_Port
    movia   9
    movar	UartCnt
    goto	UartTX_Star_Bit_End

LoopSend_Bit:
	jbts1	UartData,0                 ;1
	goto	UartTX_Bit_0               ;2
UartTX_Bit_1:                          ;
    bset    Uart_IO_Port               ;
	goto	UartTX_Bit_End             ;
UartTX_Bit_0:
    bclr    Uart_IO_Port               ;
	goto    $+1	
UartTX_Bit_End:
    rrrnc   UartData,r                 ;
UartTX_Star_Bit_End:                   ;
    call    Wait_Bit_Time

    djzr    UartCnt,r
	goto    LoopSend_Bit
    bset    Uart_IO_Port
    call    Wait_Bit_Time
	return

;====================================================================
; 
;====================================================================
Wait_Bit_Time:	
	goto    $+1
	goto    $+1
	; ;---------------8T--------------
	goto    $+1  ;8T注释此段
	goto    $+1  ;8T注释此段
	goto    $+1  ;8T注释此段
	goto    $+1  ;8T注释此段
	goto    $+1  ;8T注释此段
	goto    $+1  ;8T注释此段
	goto    $+1  ;8T注释此段
	goto    $+1  ;8T注释此段

    return
#endif



;================================================================================
	
  end
  
;*********************************END OF FILE************************************

	