;*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
;* File Name          : M8P615_Touch_Lib_CFG.H
;* Author             : MASSES CHIP
;* Version            : V2.04
;* Date               : 2025/12/10
;********************************************************************************
;================================================================================
#ifndef __M8P615_Touch_Lib_CFG_H__
#define __M8P615_Touch_Lib_CFG_H__

; 设置CDC需要检测的通道  0: 该通道按键不检测；1: 该通道按键需检测。
#define    EnTk0    	 1
#define    EnTk1    	 1
#define    EnTk2    	 1
#define    EnTk3    	 0
#define    EnTk4    	 0
#define    EnTk5    	 0
#define    EnTk6    	 1

; 设置确认允许响应的最多按键数量     (1 <= value <= TKLib_M0_OPENED_TK_AMOUNT)
#define TKLib_TOUCH_NUM               3

; 设置手指触摸最长有效时间           (0<= value <=15) ; 0: 屏蔽此功能；1: 禁止配置；2~15：时间 = value*长按保护检测基准时基
#define TKLib_LONG_TOUCH_TIME         8

; 设置CDC时钟分频选择位               1->Fosc/8, 2->Fosc/16, 3->Fosc/32; 一般不需要修改
#define TKLib_TKCKS                   1

; 设置手指有效触摸检测次数           (1<= value<=15) ; 一般不需要修改
#define TKLib_EFFECTIVE_TOUCH_TIME    5

; 设置手指无效触摸检测次数           (1<= value<=15) ; 一般不需要修改
#define TKLib_INVALID_TOUCH_TIME      4

; 设置扫描当前通道时，其它触摸端口是否处理   0: 不处理；1: 输出固定低电平。; 一般不需要修改
#define TKLib_TOUCH_PORT_OUT_EN       1

; 设置当被响应按键超过允许响应的最多按键数量时，是否需要复位触摸      
;                                     0->不复位触摸系统, 1->复位触摸系统 ; 一般不需要修改
#define TKLib_Multi_TOUCH_RST         1

; 设置校准基准时基                   (1<= value <=254) ; 可根据时基需求调整
; 校准基准时基  = TKLib_CaliBaseTime * 调用时基，调用时基 Demo code 为1ms，可根据时基需求修改
#define TKLib_CaliBaseTime            20

; 设置长按保护检测基准时基           (1<= value <=254) ; 可根据时基需求调整
; 长按保护检测基准时基 = TKLib_LongKeyBaseTime * 校准基准时基，Democode为校准基准时基产生后计数，可根据时基需求修改
#define TKLib_LongKeyBaseTime         200

; 触摸数据采集次数,值越小灵敏度越高,不需要更改
;									 (3<= value< =254)	
#define TKLib_ScanCnt         		  8
;================================================================================
; 触摸阈值： 取值需具体应用环境决定，最小6，最大255，值越小越灵敏
#define     TKLib_TK0_F_THRESHOLD    30       
#define     TKLib_TK1_F_THRESHOLD    30 
#define     TKLib_TK2_F_THRESHOLD    30
#define     TKLib_TK3_F_THRESHOLD    30 
#define     TKLib_TK4_F_THRESHOLD    30
#define     TKLib_TK5_F_THRESHOLD    30 
#define     TKLib_TK6_F_THRESHOLD    30  
;================================================================================
; 触摸省电模式设定，一般运用请关闭此模式
;================================================================================
; 设置触摸低功耗模式是否开启  		 0: 不使用触摸省电模式；1: 使用触摸省电模式;
; 休眠时间采用WDT时间，配置字WDT使能选择，必须选择始终开启WDT功能,建议WDT溢出时间选择72ms
#define TKLib_TouchLowerPower        0

; 低功耗模式下触摸唤醒阈值： 取值需具体应用环境决定，最小3，最大255，值越小越灵敏
; 建议取值小于正常触摸下所有通道阈值中最小的值
#define TKLib_Sleep_F_THRESHOLD      10
;================================================================================
; 以下用户不可修改
;================================================================================
#define TKLib_OPENED_TK_AMOUNT   (EnTk0+EnTk1+EnTk2+EnTk3+EnTk4+EnTk5+EnTk6)
#define TKLib_TK_EN_MASK         ((EnTk0<<0)|(EnTk1<<1)|(EnTk2<<2)|(EnTk3<<3)|(EnTk4<<4)|(EnTk5<<5)|(EnTk6<<6))             
;================================================================================

#endif

;*********************************END OF FILE************************************

                             
