;*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
;* File Name          : M8P615_Touch_Lib_Data.INC
;* Author             : MASSES CHIP
;* Version            : V2.04
;* Date               : 2025/12/10
;********************************************************************************

;本文件不建议用户自行修改

;================================================================================ 
#include     M8P615_Touch_Lib_CFG.inc 
;================================================================================ 
     
;================================================================================ 
;触摸库RAM分配起始地址，不建议修改，或保证修改后有足够地址分配到触摸库使用
; RAM (0x3f+1-7-13-4*TKLib_OPENED_TK_AMOUNT)~0x3f 被触摸库中使用
RTKLibGroup0 udata (0x3f+1-12-2-6-7*TKLib_OPENED_TK_AMOUNT)  
;================================================================================ 
_RTkTemp0        res        1
_RTkTemp1        res        1
_RTkTemp2        res        1 
_RTkTemp3        res        1 
_RTkTemp4        res        1 
_RTkTemp5        res        1
_RTkTemp6        res        1          
_RTkTemp7        res        1         
_RTkTemp8        res        1
_RTkTemp9        res        1        
_RTkTemp10       res        1        
_RTkTemp11       res        1          
    
;以上RAM不调用触摸相关函数模块时，将释放使用，用户可以在其他程序中当临时变量使用

;以下RAM为不可释放RAM,消耗数量为 11+4*TKLib_OPENED_TK_AMOUNT,其中TKLib_OPENED_TK_AMOUNT为开启的按键数量      

#if  TKLib_OPENED_TK_AMOUNT
_RTkGBuff0       res        2*TKLib_OPENED_TK_AMOUNT   ;        
_RTkGBuff1       res        2*TKLib_OPENED_TK_AMOUNT         
_RTkGBuff2       res        1*TKLib_OPENED_TK_AMOUNT
_RTkGBuff3       res        1*TKLib_OPENED_TK_AMOUNT
_RTkGBuff4       res        2
_RTkGBuff5       res        1*TKLib_OPENED_TK_AMOUNT     
#endif

_RTkBuff0        res        1
_RTkBuff1        res        1
_RTkBuff2        res        1 

_RChannelEnL     res        1
_RKeyOnFlgL      res        1
_RTkBitFlag      res        1

;================================================================================  
; 程序区 0x03f4~0x03ff，用户不可使用
;================================================================================ 
#if TKLib_TouchLowerPower
TAB_TOUCH_TKLP_CFG_DATA:
 org    (0x03ff+1-7-2*TKLib_OPENED_TK_AMOUNT-1-1)   
TAB_TOUCH_TKLP_MASK_DATA:
 DW     ((TKLib_TK_EN_MASK&0xff)+((TKLib_Sleep_F_THRESHOLD&0xff)<<8))
#endif

TAB_TOUCH_CFG_DATA:
 org    (0x03ff+1-7-2*TKLib_OPENED_TK_AMOUNT-1)                   
TAB_TOUCH_TK_EN_MASK_DATA:
 RETIA	TKLib_TK_EN_MASK
 
TAB_TOUCH_TKCKS_And_Scan_SW_DATA:
 RETIA  (((TKLib_TOUCH_PORT_OUT_EN&0x01)<<6)+((TKLib_TKCKS&0x03)<<4))

; TAB_TOUCH_NUM_DATA:  
 ; DW     ((TKLib_Down_Calibration_Rate&0x07)+((TKLib_Up_Calibration_Rate&0x07)<<4)+((TKLib_LONG_TOUCH_TIME&0x0F)<<12) +((TKLib_TOUCH_NUM&0x07)<<8)+((TKLib_Multi_TOUCH_RST&0x01)<<11))
 
; TAB_TOUCH_CONFIRM_TIME_DATA: 
 ; DW     ((TKLib_EFFECTIVE_TOUCH_TIME&0x0F)+((TKLib_INVALID_TOUCH_TIME&0x0F)<<4) +((TKLib_Debounce_TIME&0x0FF)<<8))
TAB_TOUCH_OPENED_TK_AMOUNT_DATA: 
 RETIA     (TKLib_OPENED_TK_AMOUNT&0x0F)

TAB_TOUCH_NUM_DATA:
 RETIA     (((TKLib_TOUCH_NUM&0x0F)<<0)+((0)<<6)+((TKLib_Multi_TOUCH_RST&0x01)<<7))

TAB_TOUCH_LONG_TOUCH_TIME:  
 RETIA     (TKLib_LONG_TOUCH_TIME&0x0F)
 
TAB_TOUCH_CONFIRM_TIME_DATA: 
 RETIA     ((TKLib_EFFECTIVE_TOUCH_TIME&0x0F)+((TKLib_INVALID_TOUCH_TIME&0x0F)<<4))

TAB_TOUCH_SCAN_DATA:
 RETIA     (TKLib_ScanCnt-1)

TAB_TOUCH_CHANNEL_DATA:
#if EnTk0
 DW     (0xFE+(0<<8))
#endif

#if EnTk1
 DW     (0xFD+(1<<8))
#endif

#if EnTk2
 DW     (0xFB+(2<<8))
#endif

#if EnTk3
 DW     (0xF7+(3<<8))
#endif

#if EnTk4
 DW     (0xEF+(4<<8))
#endif

#if EnTk5
 DW     (0xDF+(5<<8))
#endif

#if EnTk6
 DW     (0xBF+(6<<8))
#endif

TAB_TOUCH_F_DATA:
#if EnTk0
 DW     ((TKLib_TK0_F_THRESHOLD&0xff)+((0x01&0xff)<<8))
#endif

#if EnTk1
 DW     ((TKLib_TK1_F_THRESHOLD&0xff)+((0x02&0xff)<<8))
#endif

#if EnTk2
 DW     ((TKLib_TK2_F_THRESHOLD&0xff)+((0x04&0xff)<<8))
#endif

#if EnTk3
 DW     ((TKLib_TK3_F_THRESHOLD&0xff)+((0x08&0xff)<<8))
#endif

#if EnTk4
 DW     ((TKLib_TK4_F_THRESHOLD&0xff)+((0x10&0xff)<<8))
#endif

#if EnTk5
 DW     ((TKLib_TK5_F_THRESHOLD&0xff)+((0x20&0xff)<<8))
#endif

#if EnTk6
 DW     ((TKLib_TK6_F_THRESHOLD&0xff)+((0x40&0xff)<<8))
#endif

 DW     (0x0309)

;================================================================================
 ; RAM
 GLOBAL _RTkTemp0   
 GLOBAL _RTkTemp1   
 GLOBAL _RTkTemp2    
 GLOBAL _RTkTemp3   
 GLOBAL _RTkTemp4  
 GLOBAL _RTkTemp5      
 GLOBAL _RTkTemp6    
 GLOBAL _RTkTemp7    
 GLOBAL _RTkTemp8    
 GLOBAL _RTkTemp9    
 GLOBAL _RTkTemp10   
 GLOBAL _RTkTemp11     

 GLOBAL _RTkBitFlag     
 GLOBAL _RKeyOnFlgL     
 GLOBAL _RChannelEnL     
 
 GLOBAL _RTkBuff0 
 GLOBAL _RTkBuff1
 GLOBAL _RTkBuff2 

 GLOBAL _RTkGBuff0     
 GLOBAL _RTkGBuff1    
 GLOBAL _RTkGBuff2     
 GLOBAL _RTkGBuff3 
 GLOBAL _RTkGBuff4 
 GLOBAL _RTkGBuff5     

 ; CODE
 GLOBAL TAB_TOUCH_OPENED_TK_AMOUNT_DATA
 GLOBAL TAB_TOUCH_TK_EN_MASK_DATA          
 GLOBAL TAB_TOUCH_TKCKS_And_Scan_SW_DATA           
 GLOBAL TAB_TOUCH_CONFIRM_TIME_DATA   
 GLOBAL TAB_TOUCH_NUM_DATA  
 GLOBAL TAB_TOUCH_CHANNEL_DATA
 GLOBAL TAB_TOUCH_F_DATA
 GLOBAL TAB_TOUCH_SCAN_DATA
 GLOBAL TAB_TOUCH_LONG_TOUCH_TIME

#if TKLib_TouchLowerPower 
 ; CODE         
 GLOBAL TAB_TOUCH_TKLP_MASK_DATA 

#endif 

;================================================================================ 
;以下信息用户可不查看

;================================================================================  
#if 1         ; 0:关闭触摸配置信息提示，1:开启触摸配置信息提示
;================================================================================
#if EnTk0
    MESSG "    TK0: Enable"  
#endif
#if EnTk1
    MESSG "    TK1: Enable"  
#endif
#if EnTk2
    MESSG "    TK2: Enable"  
#endif
#if EnTk3
    MESSG "    TK3: Enable"  
#endif
#if EnTk4
    MESSG "    TK4: Enable"  
#endif
#if EnTk5
    MESSG "    TK5: Enable"  
#endif
#if EnTk6
    MESSG "    TK6: Enable"  
#endif

;================================================================================
#if (TKLib_OPENED_TK_AMOUNT == 0)
    Error "    No channel is enabled,Please reconfigure EnTk0~EnTk7"  
#endif	

;================================================================================
;CDC Clock
#if (TKLib_TKCKS == 0)
    Error "    Error: Please setting TKLib_TKCKS > 0"  
#endif
#if (TKLib_TKCKS == 1)
    MESSG "    CDC0 Clock: Fosc/8"  
#endif
#if (TKLib_TKCKS == 2)
    MESSG "    CDC0 Clock: Fosc/16"  
#endif
#if (TKLib_TKCKS == 3)
    MESSG "    CDC0 Clock: Fosc/32" 
#endif
#if (TKLib_TKCKS > 3)
    Error "    Error: Please setting TKLib_TKCKS <= 3"  
#endif


;================================================================================
#if (TKLib_TOUCH_NUM == 0)
    Error "    Error: Please setting TKLib_TOUCH_NUM > 0"  
#endif
;================================================================================
#if (TKLib_LONG_TOUCH_TIME == 0)
    MESSG "    屏蔽按键最长输出时间功能，即触摸不离开，按键标志一直会置位 "
#endif
#if (TKLib_LONG_TOUCH_TIME == 1)
    Error "    禁止配置 " 
#endif

#if (TKLib_LONG_TOUCH_TIME > 15)
    Error "    Error: Please setting TKLib_LONG_TOUCH_TIME <= 15"  
#endif

;================================================================================
#if (TKLib_Multi_TOUCH_RST > 1)
    Error "    Error: Please setting TKLib_Multi_TOUCH_RST ∈ {0,1}  "  
#endif

;================================================================================
#if (TKLib_CaliBaseTime < 1)
    Error "    Error: Please setting TKLib_CaliBaseTime >= 1" 
#endif
#if (TKLib_CaliBaseTime > 254)
    Error "    Error: Please setting TKLib_CaliBaseTime <= 254"  
#endif

#if (TKLib_LongKeyBaseTime < 1)
    Error "    Error: Please setting TKLib_LongKeyBaseTime >= 1" 
#endif
#if (TKLib_LongKeyBaseTime > 254)
    Error "    Error: Please setting TKLib_LongKeyBaseTime <= 254"  
#endif

;================================================================================
#if (TKLib_EFFECTIVE_TOUCH_TIME == 0)
    Error "    Error: Please setting TKLib_EFFECTIVE_TOUCH_TIME > 0"  
#endif
#if (TKLib_EFFECTIVE_TOUCH_TIME > 15)
    Error "    Error: Please setting TKLib_EFFECTIVE_TOUCH_TIME <= 15"  
#endif

;================================================================================
#if (TKLib_INVALID_TOUCH_TIME == 0)
    Error "    Error: Please setting TKLib_INVALID_TOUCH_TIME > 0"  
#endif
#if (TKLib_INVALID_TOUCH_TIME > 15)
    Error "    Error: Please setting TKLib_INVALID_TOUCH_TIME <= 15"  
#endif

;================================================================================
#if (TKLib_TK0_F_THRESHOLD > 255)
    Error "    Error: Please setting TKLib_TK0_F_THRESHOLD <= 255"  
#endif
#if (TKLib_TK1_F_THRESHOLD > 255)
    Error "    Error: Please setting TKLib_TK1_F_THRESHOLD <= 255"  
#endif
#if (TKLib_TK2_F_THRESHOLD > 255)
    Error "    Error: Please setting TKLib_TK2_F_THRESHOLD <= 255"  
#endif
#if (TKLib_TK3_F_THRESHOLD > 255)
    Error "    Error: Please setting TKLib_TK3_F_THRESHOLD <= 255"  
#endif
#if (TKLib_TK4_F_THRESHOLD > 255)
    Error "    Error: Please setting TKLib_TK4_F_THRESHOLD <= 255"  
#endif
#if (TKLib_TK5_F_THRESHOLD > 255)
    Error "    Error: Please setting TKLib_TK5_F_THRESHOLD <= 255"  
#endif
#if (TKLib_TK6_F_THRESHOLD > 255)
    Error "    Error: Please setting TKLib_TK6_F_THRESHOLD <= 255"  
#endif

;================================================================================
#if (TKLib_TK0_F_THRESHOLD <6)
    Error "    Error: Please setting TKLib_TK0_F_THRESHOLD >= 6"
#endif
#if (TKLib_TK1_F_THRESHOLD <6)
    Error "    Error: Please setting TKLib_TK1_F_THRESHOLD >= 6"
#endif
#if (TKLib_TK2_F_THRESHOLD <6)
    Error "    Error: Please setting TKLib_TK2_F_THRESHOLD >= 6"
#endif
#if (TKLib_TK3_F_THRESHOLD <6)
    Error "    Error: Please setting TKLib_TK3_F_THRESHOLD >= 6"  
#endif
#if (TKLib_TK4_F_THRESHOLD <6)
    Error "    Error: Please setting TKLib_TK4_F_THRESHOLD >= 6"
#endif
#if (TKLib_TK5_F_THRESHOLD <6)
    Error "    Error: Please setting TKLib_TK5_F_THRESHOLD >= 6"
#endif
#if (TKLib_TK6_F_THRESHOLD <6)
    Error "    Error: Please setting TKLib_TK6_F_THRESHOLD >= 6"
#endif

;================================================================================
#if (TKLib_TOUCH_PORT_OUT_EN==0)
    MESSG "    扫描当前通道时，其它触摸触摸端口不处理 "	
#endif	
#if (TKLib_TOUCH_PORT_OUT_EN==1)
    MESSG "    扫描当前通道时，其它触摸触摸端口输出低 "	
#endif
#if (TKLib_TOUCH_PORT_OUT_EN>1)
    Error "    Error: Please setting TKLib_TOUCH_PORT_OUT_EN ∈ {0,1}  "	
#endif

;================================================================================
#if (TKLib_TouchLowerPower==1)
    MESSG "    触摸低功耗模式：已开启 " 
#endif   
#if (TKLib_TouchLowerPower==0)
    MESSG "    触摸低功耗模式：未开启 "	
#endif
#if (TKLib_TouchLowerPower>1)
    Error "    触摸低功耗模式：配置错误，TKLib_TouchLowerPower ∈ {0,1} "	
#endif

;================================================================================
#endif

;*********************************END OF FILE************************************

                                   