;*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
;* File Name          : MAIN.ASM
;* Author             : MASSES CHIP
;* Version            : V2.04
;* Date               : 2025/12/10
;********************************************************************************
; 
; 16M/4T, WDT EN 72MS, RST IS IO ,BOR 2.4V,RST TIMER 18MS
;
;******************************************************************************** 
;================================================================================  
#include zc.inc   
#include M8R_P_MACRO.inc 

;================================================================================  
#include M8P615_Touch_Lib.inc
#include M8P615_Touch_Lib_Data.inc 
#include M8P615_Touch_Lib_CFG.inc
#include M8P615_Touch_UartDebug_LIB_Init.INC
;================================================================================  
#if TKLib_TouchLowerPower 
 GLOBAL WDT_WakeUp_Handle
#endif  

;================================================================================  
 CODE 
;================================================================================  
userdata  udata 0
R_Time_Flag                res    1;EQU     h'00'
#define bT_125US_F    R_Time_Flag,0
#define	bT_1MS_F      R_Time_Flag,1
#define	bT_10MS_F     R_Time_Flag,2

R_1MS_COUNT                res    1;EQU    h'01'
R_10MS_COUNT               res    1;EQU    h'02'
R_GOTOLOWPOWERMODE_COUNT   res    1;EQU    h'03'

; T0 BASE TIME  SET
#define	T0_BASE_US                    125   
#define T0_LOAD_C_Init	              T0_BASE_US*16000000/16/1000000

#define T_1MS_C_Init_DF               D'8'

#define T_10MS_C_Init_DF              D'10'
#define T_GOTOLOWPOWERMODE_C_Init_DF  D'200'  ;无触摸下超时休眠检测次数，无触摸下超时休眠时间 = 次数*10ms
;====================================================================
;此段为模拟串口定义数据不可删除
#if TKUartDebugLib_DEBUG_UART_SELECT
UartData   res    1
UartCnt    res    1
 GLOBAL UartData
 GLOBAL UartCnt
#endif
;====================================================================                   
    org     0x0000          
    GOTO    MainProgram
           
    org     .8
ISR_Handle:
    push
	
T0_ISR:	
     jbts0   INTCR0,TC0IE
     GOTO	ISR_T0_Handle
;    GOTO    ISR_Handle_END


ISR_Handle_END:
    pop
    retie 

ISR_T0_Handle:
     jbts1   INTF0,TC0IF
     GOTO    ISR_Handle_END
;	 BSET	 bT_125US_F

;1MS	
    DJZR    R_1MS_COUNT,R
    GOTO    ISR_T0_Handle_END
    MOVI    R_1MS_COUNT,T_1MS_C_Init_DF
    BSET    bT_1MS_F

TK_BASETIMER:
;触摸库需要的时基，不可删除，但可以调整位置，即只需要产生下列时基即可
;校准基准时基
    INCR    RTK_CaliBaseTime_Cnt,R
    MOVIA   (TKLib_CaliBaseTime-1)
    JLAR    RTK_CaliBaseTime_Cnt    
    GOTO    TK_BASETIMER_END
    CLRR    RTK_CaliBaseTime_Cnt
    ;MOVI    RTKCBTFlag,TKLib_TK_EN_MASK   ;必须定时产生此标志

;长按长按保护检测基准时基 
    INCR    RTK_LongKeyBaseTime_Cnt,R
    MOVIA   (TKLib_LongKeyBaseTime-1)
    JLAR    RTK_LongKeyBaseTime_Cnt    
    GOTO    TK_BASETIMER_END
    CLRR    RTK_LongKeyBaseTime_Cnt
    ;MOVI    RTKLBTFlag,TKLib_TK_EN_MASK  ;若开启长按保护，必须定时产生此标志
	BSET    bT_TK_LBT_F   ;若开启长按保护，必须定时产生此标志

TK_BASETIMER_END:
	 
;10MS
    DJZR    R_10MS_COUNT,R
    GOTO    ISR_T0_Handle_END
    MOVI    R_10MS_COUNT,T_10MS_C_Init_DF
    BSET    bT_10MS_F

ISR_T0_Handle_END:
    BCLR	INTF0,TC0IF
    GOTO    ISR_Handle_END
	
;==================================================================== 
MainProgram:
    call    Init
#if TKUartDebugLib_DEBUG_UART_SELECT
	call	_TK_TouchUartDebug_Init
#endif
    call    _TkInit
	
MainLoop:
    CALL    _TkScan          ;主循环一直查询
    JBTS1   bOneScanDone     ;查询一轮是否转换结束    
    goto    MainLoop_1


	call    _TkSignalHandle 
	BCLR    bOneScanDone     ;一轮转换完成,清除标志
	
#if TKUartDebugLib_DEBUG_UART_SELECT
	bclr	INTCR0,TC0IE
	call	_TK_TouchUartDebug
	bset	INTCR0,TC0IE
#endif
	
; 按键响应
    CJZ1 _RKeyOnFlgL,ALLKEY_UP_Handle  ;检查是否有按键被按下
    MOVI R_GOTOLOWPOWERMODE_COUNT,T_GOTOLOWPOWERMODE_C_Init_DF		
;	NOP
;    jbts0   F_TK0_On
;    bclr    iob,1
;    jbts0   F_TK1_On
;    bclr    iob,2
;    jbts0   F_TK2_On
;    bclr    iob,3
	
    goto    ALLKEY_UP_Handle_end	
	
ALLKEY_UP_Handle:
;全部按键松开
    JBTS1   bT_10MS_F   
    GOTO    ALLKEY_UP_Handle_end
    BCLR    bT_10MS_F

    DJZR    R_GOTOLOWPOWERMODE_COUNT,R
    GOTO    ALLKEY_UP_Handle_end
    MOVI    R_GOTOLOWPOWERMODE_COUNT,T_GOTOLOWPOWERMODE_C_Init_DF
	
#if TKLib_TouchLowerPower
    ;BCLR    bLowPowerModeReset ;允许清零则每次进入休眠前会复位参考，不容易进低功耗模式时可考虑打开	
    BSET    bLowPowerModeRun   ;按键松开超过设定时间，置 bLowPowerModeRun 即允许睡眠
#endif


ALLKEY_UP_Handle_end:

#if TKLib_TouchLowerPower 
    JBTS1   bLowPowerModeRun 
    goto    Next_OneScan

;下面加睡眠前其它需要低功耗处理的操作(除触摸外的，触摸相关的_TkLowPowerMode会自行处理)	
;如低功耗模式下端口处理，外设模块等
;WDT 与 CPU 工作模式 用户不需要处理




    BCLR    INTCR0,TC0IE   ;关闭其他唤醒源，本demo code外部只打开了T0，故只关闭T0
;触摸低功耗模式	
    call    TkLowPowerMode

;下面加唤醒后其它需要恢复的操作		
    BSET    INTCR0,TC0IE


	
#endif 

Next_OneScan:
    CALL    _ScanContinue	;必须在TkLowPowerMode 后面调用，且保证清除bOneScanDone后，一定能调用此程序
 		
; 其它组循环 	
MainLoop_1:
    CLRWDT
	
    goto    MainLoop  
 
;====================================================================                                                 
init: 
; Stack:	Level 5
IO_init: 

    movia   b'11111111'  ;tk
    movar   ansa
	
    movia   b'00000000'  ;tk0~6
    movar   ioa

    movia   b'11111111'  ;tk0~6
    movar   oea

    movia   b'00001111'  ; 1：output  0：input
    movar   iob
	
    movia   b'00111111'  ; 1：output  0：input
    movar   oeb
    CLRR    IOB
	
	CLRR	PDAB
	

RAM_INIT:	
ClrRam:        
    clrr    fsr0     ;0x00
ClrRam_loop:
    clrr    indf0
    incr    fsr0,r
    movr    fsr0,a
    jcmpai  low(0x3f+1)   ;0xff (clr ram addar +1)
    goto    ClrRam_loop
ClrRam_end:	

; RAM 数据赋值
    MOVI    R_1MS_COUNT,T_1MS_C_Init_DF
    MOVI    R_GOTOLOWPOWERMODE_COUNT,T_GOTOLOWPOWERMODE_C_Init_DF	
    MOVI    R_10MS_COUNT,T_10MS_C_Init_DF
	
RAM_INIT_END:

TKM0_INIT:


;AD
    MOVIA  0x0A
    MOVAR   adcon0 
   
    bset    adcon1,0  ; CDC VREF  ;调用TkInit此程序前，必须打开ADC模块2V/3V/4V之任一参考电源
 
;TK 
TKM0_INIT_END:
	
T0_INIT:
    CLRR    TC0CH
    MOVIA   T0_LOAD_C_Init
    MOVAR   TC0CL
	
    MOVIA   b'10001100'	; 16Mhz, 16分频, 
    MOVAR   T0CR
    BSET    INTCR0,TC0IE
	
T0_INIT_END:	

;ENALBE gie	
    bset    option,gie	
	
    return  
   
;====================================================================  

;==================================================================== 
#if TKLib_TouchLowerPower
WDT_WakeUp_Handle:
 ;此程序是在触摸低功耗模式下，需要处理的操作，如有需要可增加操作程序  
 ;如RTC时钟1S计时程序,LCD时钟刷新显示程序等等
  
  
  
  
 ; bclr  bLowPowerModeRun ; 可根据需求，判断系统是否需要强制唤醒(清bLowPowerModeRun，强制唤醒系统)
                         
    return 
#endif  

         
     END 
	 
;*********************************END OF FILE************************************
                                  
