;*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
;* File Name          : M8P626_Touch_Lib_CFG.INC
;* Author             : MASSES CHIP
;* Version            : V2.03
;* Date               : 2025/12/02
;********************************************************************************


;================================================================================
#ifndef __M8P626_Touch_Lib_CFG_INC__
#define __M8P626_Touch_Lib_CFG_INC__

;================================================================================
; 触摸正常模式设定
;================================================================================
; 设置CDC模块需要检测的通道  0: 该通道按键不检测；1: 该通道按键需检测。
#define EnTk0    1
#define EnTk1    0
#define EnTk2    0
#define EnTk3    0
#define EnTk4    0
#define EnTk5    0
#define EnTk6    0
#define EnTk7    0
#define EnTk8    0
#define EnTk9    0
#define EnTk10   0

; 设置触摸工作模式                    0->电荷转移模式(需外接电容), 1->振荡模式(无需外接电容) 建议使用电荷转移模式
#define TKLib_TKMODE                  0

; 设置确认允许响应的最多按键数量     (1 <= value <= TKLib_OPENED_TK_AMOUNT)
#define TKLib_TOUCH_NUM               1
   
; 设置手指触摸最长有效时间           (0<= value <=15) ; 0: 屏蔽此功能；1: 禁止配置；2~15：时间 = value*长按保护检测基准时基
#define TKLib_LONG_TOUCH_TIME         15

; 设置CDC时钟分频选择位               0->Fosc/4, 1->Fosc/8, 2->Fosc/16, 3->Fosc/32 ; 一般不需要修改
; 振荡模式                            设置值越大，灵敏度越高。(电荷转移模式下，一般情况不影响灵敏度)
#define TKLib_TKCKS                   0

; 设置手指有效触摸检测次数,值越小灵敏度越高,值越大抗干扰越好  
;									 (1<= value<=14) 
#define TKLib_EFFECTIVE_TOUCH_TIME    5

; 设置手指无效触摸检测次数,值越小灵敏度越高,值越大抗干扰越好  
;									 (1<= value<=14)
#define TKLib_INVALID_TOUCH_TIME      4

; 基值上升更新速度,一般不需要修改	 (1<= value<=14)
#define TKLib_BaseLineUpSpeed         5

; 基值下降更新速度,一般不需要修改	 (1<= value<=14)
#define TKLib_BaseLineDownSpeed       5

; 设置当被响应按键超过允许响应的最多按键数量时，是否需要复位触摸      
;                                     0->不复位触摸系统, 1->复位触摸系统 ; 一般不需要修改
#define TKLib_Multi_TOUCH_RST         1

; 设置校准基准时基                   (1<= value <=254) ; 可根据时基需求调整
; 校准基准时基  = TKLib_CaliBaseTime * 调用时基，调用时基 Demo code 为0.5ms，可根据时基需求修改
#define TKLib_CaliBaseTime            200

; 设置长按保护检测基准时基           (1<= value <=254) ; 可根据时基需求调整
; 长按保护检测基准时基 = TKLib_LongKeyBaseTime * 校准基准时基，Democode为校准基准时基产生后计数，可根据时基需求修改
#define TKLib_LongKeyBaseTime         10

; 触摸数据采集次数,值越小灵敏度越高,不需要更改
;									 (3<= value< =254)	
#define TKLib_ScanCnt         		  8

; 上电按键有效延时时间,可根据实际需求修改,默认2S				 
;									 (0<= value< =254) value*100ms 
#define TKLib_PowerOn_Delay_Time      20   
;================================================================================
; 触摸阈值： 取值需具体应用环境决定，最小8，最大254，值越小越灵敏
#define TKLib_TK0_F_THRESHOLD         20
#define TKLib_TK1_F_THRESHOLD         20
#define TKLib_TK2_F_THRESHOLD         20
#define TKLib_TK3_F_THRESHOLD         20
#define TKLib_TK4_F_THRESHOLD         20
#define TKLib_TK5_F_THRESHOLD         20
#define TKLib_TK6_F_THRESHOLD         20
#define TKLib_TK7_F_THRESHOLD         20
#define TKLib_TK8_F_THRESHOLD         20 
#define TKLib_TK9_F_THRESHOLD         20
#define TKLib_TK10_F_THRESHOLD        20

;================================================================================
; 触摸端口补偿电容配置               (1<= value<=15) ;补偿电容 ≈ 0.5pF * TKLib_TKx_CAPS  
#define TKLib_TK0_CAPS                0
#define TKLib_TK1_CAPS                0
#define TKLib_TK2_CAPS                0
#define TKLib_TK3_CAPS                0
#define TKLib_TK4_CAPS                0
#define TKLib_TK5_CAPS                0
#define TKLib_TK6_CAPS                0
#define TKLib_TK7_CAPS                0
#define TKLib_TK8_CAPS                0
#define TKLib_TK9_CAPS                0
#define TKLib_TK10_CAPS               0

;================================================================================
; 触摸充电电压选择                   (0<= value<=3) ; 0->2V, 1->3V, 2->4V, 3->VDD  一般不需要修改
;                                     注：必需保证IC 供电VDD > 设置充电电压 + 0.5V
; 电荷转移模式                        设置值越大，灵敏度越低
; 振荡模式                            设置值越大，灵敏度越高
#define TKLib_TK_VCHG                 0

;================================================================================
; 触摸参考电压选择(电荷转移模式)     (0<= value<=3) ; 0->1.2V, 1->0.5*VCHG, 2->0.75*VCHG, 3->0.9*VCHG  一般不需要修改
; 触摸参考振荡频率选择(振荡模式)     (1<= value<=3) ; 1->低, 2->中, 3->高
; 触摸灵敏度                          设置值越大，灵敏度越高
#define TKLib_TK_VCS                  2

;================================================================================
; 触摸省电模式设定，一般运用请关闭此模式
;================================================================================
; 设置触摸低功耗模式是否开启  		  0: 不使用触摸省电模式；1: 使用触摸省电模式。
#define TKLib_TouchLowerPower         0

; 设置触摸低功耗休眠时间			 (0<= value<=255)  value*1ms = 100MS
#define TKLib_LP_SLEEPTIME            100

;================================================================================
; 触摸省电模式下低频振荡器是否校准，一般运用无需配置
;================================================================================
;设置低功耗模式是否校准低频时钟：     0: 不校准低频时钟；1: 开启校准低频时钟。
#define TKLib_SleepWaKeUpTimeCheck    1

; 设置校准间隔时间:  		         (0 <= value <= 255) 值越大间隔时间越久
; 校准时间 = value*设置触摸低功耗模式唤醒时间 
#define TKLib_LP_CHECK_TIMER          60
;================================================================================ 
; 以下用户不可修改
;================================================================================
#define TKLib_OPENED_TK_AMOUNT   (EnTk0+EnTk1+EnTk2+EnTk3+EnTk4+EnTk5+EnTk6+EnTk7+EnTk8+EnTk9+EnTk10)
#define TKLib_TK_EN_MASK         ((EnTk0<<0)|(EnTk1<<1)|(EnTk2<<2)|(EnTk3<<3)|(EnTk4<<4)|(EnTk5<<5)|(EnTk6<<6)|(EnTk7<<7)|(EnTk8<<8)|(EnTk9<<9)|(EnTk10<<10))             
;================================================================================
#endif

;*********************************END OF FILE************************************

                             
