;*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
;* File Name          : M8P626_Touch_Lib_Data.INC
;* Author             : MASSES CHIP
;* Version            : V2.03
;* Date               : 2025/12/02
;********************************************************************************

;本文件不建议用户修改

;================================================================================ 
#include     M8P626_Touch_Lib_CFG.INC 

;================================================================================ 

;================================================================================ 
;触摸库RAM分配起始地址，不建议修改，或保证修改后有足够地址分配到触摸库使用
; RAM RTKLibGroup0 分配的起始地址 ~ 0x7f 被触摸库中使用
RTKLibGroup0 udata (0x7f+1-14-8-6-8*TKLib_OPENED_TK_AMOUNT)  
;================================================================================ 
;17
_RTkTemp0        res        1
_RTkTemp1        res        1
_RTkTemp2        res        1 
_RTkTemp3        res        1 
_RTkTemp4        res        1 
_RTkTemp5        res        1
_RTkTemp6        res        1          
_RTkTemp7        res        1         
_RTkTemp8        res        1
_RTkTemp9        res        1        
_RTkTemp10       res        1        
_RTkTemp11       res        1          
_RTkTemp12       res        1  
_RTkTemp13       res        1  

_RTkBuff2        res        1
_RTkBuff4        res        1
_RTkBuff5        res        1

#if  TKLib_OPENED_TK_AMOUNT
_RTkGBuff0       res        2*TKLib_OPENED_TK_AMOUNT   ;        
_RTkGBuff1       res        2*TKLib_OPENED_TK_AMOUNT         
_RTkGBuff2       res        1*TKLib_OPENED_TK_AMOUNT
_RTkGBuff3       res        1*TKLib_OPENED_TK_AMOUNT
_RTkGBuff4       res        6
_RTkGBuff5       res        1*TKLib_OPENED_TK_AMOUNT
_RTkGBuff6       res        1*TKLib_OPENED_TK_AMOUNT
#endif

;5
_RChannelEnL     res        1       
_RChannelEnH     res        1       
_RKeyOnFlgL      res        1
_RKeyOnFlgH      res        1 
_RTkBitFlag      res        1  

;================================================================================  
; 程序区   ~ 0x07EF，用户不可使用
;================================================================================ 
#if TKLib_TouchLowerPower
TAB_TOUCH_TKLP_CFG_DATA:
 org    (0x07EF+1-14-TKLib_OPENED_TK_AMOUNT-2)

TAB_LPTOUCH_CONFIRM_TIME_DATA:
 RETIA		4

TAB_TOUCH_TKLP_LP_SLEEPTIME:
 RETIA     (TKLib_LP_SLEEPTIME&0xff)

#endif
 
TAB_TOUCH_CFG_DATA:
 org    (0x07EF+1-14-TKLib_OPENED_TK_AMOUNT)

TAB_TOUCH_TK_EN_MASK_L_DATA:
 RETIA     (TKLib_TK_EN_MASK&0X00FF)
 
TAB_TOUCH_TK_EN_MASK_H_DATA:
 RETIA     (TKLib_TK_EN_MASK>>8)
 
TAB_TOUCH_OPENED_TK_AMOUNT_DATA: 
 RETIA     (TKLib_OPENED_TK_AMOUNT&0x0F) 
 
TAB_TOUCH_TKCKS_DATA: 
 RETIA     (((TKLib_TKMODE&0x01)<<3)+(0x01<<7)+((TKLib_TKCKS&0x03)<<4)) 
 
TAB_TOUCH_TK_VCS_VCHG_DATA: 
 RETIA     (((TKLib_TK_VCS&0x03)<<6)+((TKLib_TK_VCHG&0x03)<<4))

TAB_TOUCH_NUM_DATA:
 RETIA     (((TKLib_TOUCH_NUM&0x0F)<<0)+((0)<<6)+((TKLib_Multi_TOUCH_RST&0x01)<<7))

TAB_TOUCH_LONG_TOUCH_TIME:  
 RETIA     (TKLib_LONG_TOUCH_TIME&0x0F)
 
TAB_TOUCH_CONFIRM_TIME_DATA: 
 RETIA     ((TKLib_EFFECTIVE_TOUCH_TIME&0x0F)+((TKLib_INVALID_TOUCH_TIME&0x0F)<<4))

TAB_TOUCH_SCAN_DATA:
 RETIA     (TKLib_ScanCnt-1)
 
TAB_TOUCH_POWER_ON_DELAY_TIME:
 RETIA     (TKLib_PowerOn_Delay_Time&0xff)
 
TAB_TOUCH_BASELINE_UP_SPEED:
 RETIA		(TKLib_BaseLineUpSpeed&0x0f)
 
TAB_TOUCH_BASELINE_DOWN_SPEED:
 RETIA		(TKLib_BaseLineDownSpeed&0x0f)

TAB_TOUCH_FN_DATA: 
#if EnTk0  
 DW     ((TKLib_TK0_CAPS&0x0f)+((TKLib_TK0_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk1 
 DW     ((TKLib_TK1_CAPS&0x0f)+((TKLib_TK1_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk2 
 DW     ((TKLib_TK2_CAPS&0x0f)+((TKLib_TK2_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk3 
 DW     ((TKLib_TK3_CAPS&0x0f)+((TKLib_TK3_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk4 
 DW     ((TKLib_TK4_CAPS&0x0f)+((TKLib_TK4_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk5 
 DW     ((TKLib_TK5_CAPS&0x0f)+((TKLib_TK5_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk6 
 DW     ((TKLib_TK6_CAPS&0x0f)+((TKLib_TK6_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk7 
 DW     ((TKLib_TK7_CAPS&0x0f)+((TKLib_TK7_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk8 
 DW     ((TKLib_TK8_CAPS&0x0f)+((TKLib_TK8_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk9 
 DW     ((TKLib_TK9_CAPS&0x0f)+((TKLib_TK9_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk10 
 DW     ((TKLib_TK10_CAPS&0x0f)+((TKLib_TK10_F_THRESHOLD&0xff)<<8))
#endif
 DW     (0x0309)
 
;================================================================================         
 ; RAM
 GLOBAL _RTkTemp0   
 GLOBAL _RTkTemp1   
 GLOBAL _RTkTemp2    
 GLOBAL _RTkTemp3   
 GLOBAL _RTkTemp4  
 GLOBAL _RTkTemp5      
 GLOBAL _RTkTemp6    
 GLOBAL _RTkTemp7    
 GLOBAL _RTkTemp8    
 GLOBAL _RTkTemp9    
 GLOBAL _RTkTemp10   
 GLOBAL _RTkTemp11     
 GLOBAL _RTkTemp12 
 GLOBAL _RTkTemp13 

 GLOBAL _RTkBitFlag     
 GLOBAL _RKeyOnFlgL   
 GLOBAL _RKeyOnFlgH   
 GLOBAL _RChannelEnL     
 GLOBAL _RChannelEnH 
 
 GLOBAL _RTkBuff2
 GLOBAL _RTkBuff4
 GLOBAL _RTkBuff5 

 GLOBAL _RTkGBuff0     
 GLOBAL _RTkGBuff1    
 GLOBAL _RTkGBuff2     
 GLOBAL _RTkGBuff3 
 GLOBAL _RTkGBuff4 
 GLOBAL _RTkGBuff5 
 GLOBAL _RTkGBuff6
 
 ; CODE
 GLOBAL TAB_TOUCH_TK_EN_MASK_L_DATA 
 GLOBAL TAB_TOUCH_TK_EN_MASK_H_DATA 
 GLOBAL TAB_TOUCH_OPENED_TK_AMOUNT_DATA           
 GLOBAL TAB_TOUCH_TKCKS_DATA   
 GLOBAL TAB_TOUCH_TK_VCS_VCHG_DATA 
 GLOBAL TAB_TOUCH_NUM_DATA
 GLOBAL TAB_TOUCH_LONG_TOUCH_TIME
 GLOBAL TAB_TOUCH_CONFIRM_TIME_DATA 
 GLOBAL TAB_TOUCH_SCAN_DATA
 GLOBAL	TAB_TOUCH_POWER_ON_DELAY_TIME 
 GLOBAL	TAB_TOUCH_BASELINE_UP_SPEED
 GLOBAL	TAB_TOUCH_BASELINE_DOWN_SPEED
 GLOBAL TAB_TOUCH_FN_DATA 
 
#if TKLib_TouchLowerPower 
 ; CODE
 GLOBAL TAB_LPTOUCH_CONFIRM_TIME_DATA
 GLOBAL TAB_TOUCH_TKLP_LP_SLEEPTIME
#endif

;================================================================================
#if 1         ; 0:关闭触摸配置信息提示，1:开启触摸配置信息提示
;================================================================================
;CDC MODE
#if (TKLib_TKMODE > 1)
    Error "    Error: Please setting TKLib_TKMODE ∈ {0,1}  "  
#endif

#if (TKLib_TKMODE == 0)
    MESSG "    触摸工作模式: 电荷转移模式"  
#endif
#if (TKLib_TKMODE == 1)
    MESSG "    触摸工作模式: 振荡模式" 
#endif

;================================================================================
#if EnTk0
    MESSG "    TK0: Enable"  
#endif
#if EnTk1
    MESSG "    TK1: Enable"  
#endif
#if EnTk2
    MESSG "    TK2: Enable"  
#endif
#if EnTk3
    MESSG "    TK3: Enable"  
#endif
#if EnTk4
    MESSG "    TK4: Enable"  
#endif
#if EnTk5
    MESSG "    TK5: Enable"  
#endif
#if EnTk6
    MESSG "    TK6: Enable"  
#endif
#if EnTk7
    MESSG "    TK7: Enable"  
#endif
#if EnTk8
    MESSG "    TK8: Enable"  
#endif
#if EnTk9
    MESSG "    TK9: Enable"  
#endif
#if EnTk10
    MESSG "    TK10: Enable"  
#endif

;================================================================================
#if (TKLib_OPENED_TK_AMOUNT == 0)
    Error "    No channel is enabled,Please reconfigure EnTk0~EnTk10"  
#endif	

;================================================================================
;CDC clock
#if (TKLib_TKCKS > 3)
    Error "    Error: Please setting TKLib_TKCKS <= 3 "  
#endif

#if (TKLib_TKCKS == 0)
    MESSG "    CDC Clock: Fosc/4"  
#endif
#if (TKLib_TKCKS == 1)
    MESSG "    CDC Clock: Fosc/8"  
#endif
#if (TKLib_TKCKS == 2)
    MESSG "    CDC Clock: Fosc/16"  
#endif
#if (TKLib_TKCKS == 3)
    MESSG "    CDC Clock: Fosc/32" 
#endif

;================================================================================
#if (TKLib_TOUCH_NUM == 0)
    Error "    Error: Please setting TKLib_TOUCH_NUM > 0"  
#endif
;================================================================================
#if (TKLib_LONG_TOUCH_TIME == 0)
    MESSG "    屏蔽按键最长输出时间功能，即触摸不离开，按键标志一直会置位 " 
#endif
#if (TKLib_LONG_TOUCH_TIME == 1)
    Error "    禁止配置 " 
#endif
#if (TKLib_LONG_TOUCH_TIME > 15)
    Error "    Error: Please setting TKLib_LONG_TOUCH_TIME <= 15"  
#else
#if (TKLib_LONG_TOUCH_TIME > 1)
    MESSG "    开启按键最长输出时间功能，若触摸不离开，按键标志会输出一段时间后，会清零 " 
#endif
#endif

;================================================================================
#if (TKLib_Multi_TOUCH_RST > 1)
    Error "    Error: Please setting TKLib_Multi_TOUCH_RST ∈ {0,1}  "  
#endif

;================================================================================
#if (TKLib_CaliBaseTime < 1)
    Error "    Error: Please setting TKLib_CaliBaseTime >= 1" 
#endif
#if (TKLib_CaliBaseTime > 254)
    Error "    Error: Please setting TKLib_CaliBaseTime <= 254"  
#endif

#if (TKLib_LongKeyBaseTime < 1)
    Error "    Error: Please setting TKLib_LongKeyBaseTime >= 1" 
#endif
#if (TKLib_LongKeyBaseTime > 254)
    Error "    Error: Please setting TKLib_LongKeyBaseTime <= 254"  
#endif

;================================================================================
#if (TKLib_EFFECTIVE_TOUCH_TIME == 0)
    Error "    Error: Please setting TKLib_EFFECTIVE_TOUCH_TIME > 0"  
#endif
#if (TKLib_EFFECTIVE_TOUCH_TIME > 14)
    Error "    Error: Please setting TKLib_EFFECTIVE_TOUCH_TIME <= 14"  
#endif

;================================================================================
#if (TKLib_INVALID_TOUCH_TIME == 0)
    Error "    Error: Please setting TKLib_INVALID_TOUCH_TIME > 0"  
#endif
#if (TKLib_INVALID_TOUCH_TIME > 14)
    Error "    Error: Please setting TKLib_INVALID_TOUCH_TIME <= 14"  
#endif

;================================================================================
#if (TKLib_TK0_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK0_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK1_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK1_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK2_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK2_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK3_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK3_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK4_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK4_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK5_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK5_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK6_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK6_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK7_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK7_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK8_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK8_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK9_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK9_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK10_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK10_F_THRESHOLD <= 254"  
#endif

;================================================================================
#if (TKLib_TK0_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK0_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK1_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK1_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK2_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK2_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK3_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK3_F_THRESHOLD >= 8"  
#endif
#if (TKLib_TK4_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK4_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK5_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK5_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK6_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK6_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK7_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK7_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK8_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK8_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK9_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK9_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK10_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK10_F_THRESHOLD >= 8"
#endif

;================================================================================
;CDC VCHG
#if (TKLib_TK_VCHG > 3)
    Error "    Error: Please setting TKLib_TK_VCHG <= 3 "  
#endif

#if (TKLib_TK_VCHG == 0)
    MESSG "    触摸充电电压: 2V"  
#endif
#if (TKLib_TK_VCHG == 1)
    MESSG "    触摸充电电压: 3V"   
#endif
#if (TKLib_TK_VCHG == 2)
    MESSG "    触摸充电电压: 4V"   
#endif
#if (TKLib_TK_VCHG == 3)
    MESSG "    触摸充电电压: VDD" 
#endif

;================================================================================
;CDC VCS
#if (TKLib_TKMODE == 0)
#if (TKLib_TK_VCS > 3)
    Error "    Error: Please setting TKLib_TK_VCS  ∈ {0,1,2,3} "  
#endif
#if (TKLib_TK_VCS == 0)
    MESSG "    触摸参考电压: 1.2V"  
#endif
#if (TKLib_TK_VCS == 1)
    MESSG "    触摸参考电压: 0.5 * 触摸充电电压"   
#endif
#if (TKLib_TK_VCS == 2)
    MESSG "    触摸参考电压: 0.75 * 触摸充电电压"   
#endif
#if (TKLib_TK_VCS == 3)
    MESSG "    触摸参考电压: 0.9 * 触摸充电电压" 
#endif
#else
#if (TKLib_TK_VCS > 3)
    Error "    Error: Please setting TKLib_TK_VCS  ∈ {1,2,3} "  
#endif
#if (TKLib_TK_VCS == 0)
    Error "    Error: Please setting TKLib_TK_VCS  ∈ {1,2,3} " 
#endif
#if (TKLib_TK_VCS == 1)
    MESSG "    触摸参考振荡频率: 低"   
#endif
#if (TKLib_TK_VCS == 2)
    MESSG "    触摸参考振荡频率: 中"   
#endif
#if (TKLib_TK_VCS == 3)
    MESSG "    触摸参考振荡频率: 高" 
#endif
#endif

;================================================================================
#if (TKLib_TouchLowerPower==1)
    MESSG "    触摸低功耗模式：已开启 " 
#endif   
#if (TKLib_TouchLowerPower>1)
    MESSG "    触摸低功耗模式：配置错误，TKLib_TouchLowerPower ∈ {0,1} "	
#endif 
;================================================================================
#if (TKLib_ScanCnt < 3 )
    Error "    Error: Please setting TKLib_ScanCnt >= 3"  
#endif
#if (TKLib_ScanCnt > 254)
    Error "    Error: Please setting TKLib_ScanCnt < 255"  
#endif
;================================================================================
#if (TKLib_PowerOn_Delay_Time < 0 )
    Error "    Error: Please setting TKLib_PowerOn_Delay_Time >= 0"  
#endif
#if (TKLib_PowerOn_Delay_Time > 254)
    Error "    Error: Please setting TKLib_PowerOn_Delay_Time < 255"  
#endif
;================================================================================
#if (TKLib_BaseLineUpSpeed < 1 )
    Error "    Error: Please setting TKLib_BaseLineUpSpeed >= 1"  
#endif
#if (TKLib_BaseLineUpSpeed > 14)
    Error "    Error: Please setting TKLib_BaseLineUpSpeed < 15"  
#endif
;================================================================================
#if (TKLib_BaseLineDownSpeed < 1 )
    Error "    Error: Please setting TKLib_BaseLineDownSpeed >= 1"  
#endif
#if (TKLib_BaseLineDownSpeed > 14)
    Error "    Error: Please setting TKLib_BaseLineDownSpeed < 15"  
#endif
;================================================================================
#endif

;*********************************END OF FILE************************************
                                 