;*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
;* File Name          : M8P626_Touch_UartDebug_LIB_Init.ASM
;* Author             : MASSES CHIP
;* Version            : V2.03
;* Date               : 2025/12/02
;********************************************************************************
; 
; 
;
;********************************************************************************

#include     zc.inc   
#include 	 M8R_P_MACRO.inc 
#include 	 M8P626_Touch_UartDebug_LIB_Init.INC
	
;================================================================================
#if TKUartDebugLib_DEBUG_MODE_SWITCH
 GLOBAL _TK_TouchUartDebug_Init   
 GLOBAL _TK_Debug_Mode_Uart_SendChar   
 GLOBAL _TK_Debug_Mode_SendWord   
#endif 
;================================================================================ 
 extern _RTkTemp1   
 extern _RTkTemp2

#if (TKUartDebugLib_DEBUG_UART_SELECT==0) 
 extern _RTkTemp9
 extern _RTkTemp10

#define    T1_LOAD_C_Init	(16000000/8/TKUartDebugLib_BAUDRATE) 
 
#endif	
 
;================================================================================
 
 CODE
 
;================================================================================
#if TKUartDebugLib_DEBUG_MODE_SWITCH

 
_TK_TouchUartDebug_Init:
; Stack:	Level 1
; INPUT:	 
; OUTPUT:	
; OTHER	:	
    MESSG "    串口调试功能：已开启，请调试结束后关闭" 

#if TKUartDebugLib_DEBUG_UART_SELECT
;tx  PIN PB4
    bset    oeb,3	     ;tx pin out put
    movia   b'10000000'  ; txen 异步 8bit 1:4
    movar   TXCR	
	
    movia   high(16000000/4/TKUartDebugLib_BAUDRATE-1)
    movar   BRGDH	
    movia   low(16000000/4/TKUartDebugLib_BAUDRATE-1)  ; 16M(fosc)/4/(0x03+1) = 1M Baudrate = fosc/n/(BRGDH+1) 
    movar   BRGDL
    	
    MESSG "    串口调试端口：使用的是MCU硬件资源，端口只能在PB3上 "
     	
#else	
    BSET    OE_UART_TX,N_UART_TX	     ;tx pin out put
     		
    MOVIA   b'00001011' ; UP FOSC 1:8
    MOVAR   T1CR

    MOVIA   low(T1_LOAD_C_Init)
    MOVAR   TC1CL
    
    MESSG "    串口调试端口：使用的是IO软件模拟，端口可根据需求配置，软件串口使用的是定时器TC1，若与其它程序有冲突，请做调整 "	
    		
#endif	

   return
   
#endif	   

;================================================================================
#if TKUartDebugLib_DEBUG_MODE_SWITCH 
_TK_Debug_Mode_Uart_SendChar:
; Stack:	Level 1
; INPUT:	ACC 
; OUTPUT:	
; OTHER	:	
#if TKUartDebugLib_DEBUG_UART_SELECT
    MOVAR   TXREG
    jbts1   TXCR,6 
    goto    $-1
#else	
    MOVAR   R_UART_TX_BUF
    CALL    _TASK_UART_DATATX		
#endif	   
    return 
    
#endif	

;================================================================================
#if TKUartDebugLib_DEBUG_MODE_SWITCH 	
_TK_Debug_Mode_SendWord:
; Stack:	Level 1
; INPUT:	RTkTemp1&RTkTemp2 
; OUTPUT:	
; OTHER	:	  
#if TKUartDebugLib_DEBUG_UART_SELECT
    MOV    TXREG,_RTkTemp2 ;high
    jbts1  INTF0,TXIF
    goto   $-1
	
    MOV    TXREG,_RTkTemp1	;low
    jbts1  TXCR,6  
    goto   $-1
#else	
	
    MOV		R_UART_TX_BUF,_RTkTemp2  ;high
	CALL	_TASK_UART_DATATX
	
    MOV    	R_UART_TX_BUF,_RTkTemp1	;low
	CALL	_TASK_UART_DATATX	
#endif		
    return
	
#endif

#if (TKUartDebugLib_DEBUG_MODE_SWITCH&&(TKUartDebugLib_DEBUG_UART_SELECT==0))
;====================================================================
_TASK_UART_DATATX:
	BCLR		bTC1IF
	BSET		bTC1IE
	CLRR		TC1CH
	BSET		T1CR,7
	CLRR		R_UART_TX_CNT

UART_LOOP:
	JBTS0		bTC1IE
	GOTO		UART_LOOP

	BCLR		T1CR,7
	RETURN
	
#endif		
;================================================================================
	
  end
  
;*********************************END OF FILE************************************

	