/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
* File Name          : M8P626_Touch_Lib_CFG.C
* Author             : MASSES CHIP
* Version            : V2.03
* Date               : 2025/12/02 
;********************************************************************************   
// 本文件用户不可自行修改

*******************************************************************************/

//================================================================================
#include "zc.h"
#include "MassesChip_Define.h"
#include "M8P626_Touch_Lib_CFG.h"
#include "M8P626_Touch_Lib.h"

//================================================================================
#if TKLib_TouchLowerPower
void WDT_WakeUp_Handle(void)
{
//此程序是在触摸低功耗模式下，需要处理的操作，如有需要可增加操作程序  
//如RTC时钟1S计时程序,LCD时钟刷新显示程序等等
  

  
  
// bLowPowerModeRun = 0 ; //可根据需求，判断系统是否需要强制唤醒(清bLowPowerModeRun，强制唤醒系统)
  
}


void SleepTimeCheckHandle(void)
{
#if TKLib_SleepWaKeUpTimeCheck
  __asm 
 extern TAB_TOUCH_TKLP_LP_SLEEPTIME 
 extern _RTkTemp0  

	movia	0
	jcmpar	_RTkTemp0
	goto	SleepTimeCheckHandle_1

	bclr	T0CR,7
    CLRR    TC0CL
    CLRR    TC0CH

    MOVIA   b'01000000' ;UP FOSC 1:1
    MOVAR   T0CR

	movia	0xff
	movar	TC1CL
	movar	TC1CH
	
	movia	0xE8
	subra	TC1CL,r
	movia	0x03
	sbcra	TC1CH,r

; 用定时器1选择高频定时1Ms
    bclr    bTC1IF
    MOVIA   b'11001100' ;UP fosch 1:16
    MOVAR   T1CR	
	bset	T0CR,7
	jbts1	bTC1IF
	goto	$-1
	bclr	T0CR,7
	bclr	T1CR,7
	call    TAB_TOUCH_TKLP_LP_SLEEPTIME
	movar	_RTkTemp2
	;incr	_RTkTemp11,r

	clrr	TC1CL
	clrr	TC1CH

SleepTimeCheckHandle_Loop:
	movr    TC0CL,a
	addar	TC1CL,r
	movr    TC0CH,a
	adcar	TC1CH,r
	djzr	_RTkTemp2,r
	goto	SleepTimeCheckHandle_Loop

	call	TC1C_DIV_2
	call	TC1C_DIV_2
	call	TC1C_DIV_2
	call	TC1C_DIV_2
	call	TC1C_DIV_2	
	call	TC1C_DIV_2

	movr	TC1CL,a
	movar	TC0CL
	movia	1
	movar	TC0CH
	MOVIA   b'00000110'
    MOVAR   T0CR
	bset	T0CR,7

SleepTimeCheckHandle_1:
	incr	_RTkTemp0,r
	movia	60
	jlar	_RTkTemp0
	goto	SleepTimeCheckHandle_End
	clrr	_RTkTemp0
	goto	SleepTimeCheckHandle_End

TC1C_DIV_2:
	bclr	STATUS,0
	rrr		TC1CH,r
	rrr		TC1CL,r
	return

SleepTimeCheckHandle_End:
  __endasm; 
  

#endif
}




#endif

//================================================================================
void ScanNextChannel(void)
{
  __asm  
 
; Stack:	Level 3
; INPUT:	 
; OUTPUT:	
; OTHER	:	

 extern TKCOM_PIN_OUT
 extern _READ_TK_EN_MASK_DATA 
 
 extern TAB_TOUCH_FN_DATA 
 extern _RChannelEnL    
 extern _RChannelEnH   
  
 extern _RTkTemp4 
#define _R_CNT          _RTkTemp4

 extern _RTkBuff2 
#define RTk_CH            _RTkBuff2  
  
    CALL    TKCOM_PIN_OUT 	

; set tk ch	
    clrr    TKCHSL
    clrr    TKCHSH  ;关闭所有连接的通道

;CLR TK CH CAPS	
    MOVIA   0XF0
    ANDAR	  TKCTR1,R ;CLR CAPS
	
    movia   high(TAB_TOUCH_FN_DATA)
    movar   FSR1
    movia   low(TAB_TOUCH_FN_DATA)
    movar   FSR0	

#if EnTk0		
    jbts0   _RChannelEnL,0
    goto    scantk0_set
#endif

#if EnTk1	    
    jbts0   _RChannelEnL,1
    goto    scantk1_set
#endif

#if EnTk2	    
    jbts0   _RChannelEnL,2
    goto    scantk2_set
#endif

#if EnTk3	    
    jbts0   _RChannelEnL,3
    goto    scantk3_set
#endif

#if EnTk4	    
    jbts0   _RChannelEnL,4
    goto    scantk4_set
#endif

#if EnTk5	    
    jbts0   _RChannelEnL,5
    goto    scantk5_set
#endif

#if EnTk6	    
    jbts0   _RChannelEnL,6
    goto    scantk6_set
#endif

#if EnTk7	    
    jbts0   _RChannelEnL,7
    goto    scantk7_set
#endif

#if EnTk8	    
    jbts0   _RChannelEnH,0
    goto    scantk8_set
#endif

#if EnTk9	    
    jbts0   _RChannelEnH,1
    goto    scantk9_set
#endif

#if EnTk10	    
    jbts0   _RChannelEnH,2
    goto    scantk10_set
#endif

    bset    _RTkBitFlag,0
    CALL    _READ_TK_EN_MASK_DATA  
    goto    ScanNextChannel_end ;error	
    
#if EnTk0		
scantk0_set:
    bclr    _RChannelEnL,0	 
    bset    TKCHSL,0  		
    goto    ScanNextChannel_end_1			
#endif

#if EnTk1		
scantk1_set:
    bclr    _RChannelEnL,1		 
    bset    TKCHSL,1  		
    goto    ScanNextChannel_end_1	
#endif

#if EnTk2		 
scantk2_set:
    bclr    _RChannelEnL,2		 
    bset    TKCHSL,2  		
    goto    ScanNextChannel_end_1
#endif

#if EnTk3	
scantk3_set:
    bclr    _RChannelEnL,3	 
    bset    TKCHSL,3  		
    goto    ScanNextChannel_end_1
#endif

#if EnTk4			 
scantk4_set:
    bclr    _RChannelEnL,4	 
    bset    TKCHSL,4  		
    goto    ScanNextChannel_end_1
#endif

#if EnTk5		 
scantk5_set:
    bclr    _RChannelEnL,5	 
    bset    TKCHSL,5  		
    goto    ScanNextChannel_end_1
#endif

#if EnTk6		 
scantk6_set:
    bclr    _RChannelEnL,6	 
    bset    TKCHSL,6 		
    goto    ScanNextChannel_end_1
#endif

#if EnTk7		 
scantk7_set:
    bclr    _RChannelEnL,7	 
    bset    TKCHSL,7  		
    goto    ScanNextChannel_end_1
#endif

#if EnTk8		 
scantk8_set:
    bclr    _RChannelEnH,0		 
    bset    TKCHSH,0  		
    goto    ScanNextChannel_end_1
#endif

#if EnTk9	 
scantk9_set:
    bclr    _RChannelEnH,1	 
    bset    TKCHSH,1  		
    goto    ScanNextChannel_end_1
#endif

#if EnTk10		 
scantk10_set:
    bclr    _RChannelEnH,2	 
    bset    TKCHSH,2  		
    goto    ScanNextChannel_end_1
#endif
	
ScanNextChannel_end_1:
    incr    RTk_CH,r
    movr    RTk_CH,A

    addar   FSR0,r	
    rdt
    ORAR    TKCTR1,R   ;SELECT CAPS  
  
ScanNextChannel_end:	
    CLRR    _R_CNT	  
  
  __endasm;  
}

//================================================================================
void TkSignalHandle_Next(void)
{
  __asm  
; Stack:	Level 1
; INPUT:	 
; OUTPUT:	
; OTHER	:

 extern _RTkTemp9    
 extern _RTkTemp10 
#define RTkmaskL        _RTkTemp9
#define RTkmaskH        _RTkTemp10

 extern _RTkTemp2 
#define berror_F        _RTkTemp2,4 

;read finger data
    clrr    RTkmaskL 
    clrr    RTkmaskH

    movia   high(TAB_TOUCH_FN_DATA)
    movar   FSR1
    movia   low(TAB_TOUCH_FN_DATA)
    movar   FSR0	 

#if EnTk0	 
    jbts0   _RChannelEnL,0
    goto    READ_tk0_FN
#endif

#if EnTk1    
    jbts0   _RChannelEnL,1
    goto    READ_tk1_FN
#endif

#if EnTk2    
    jbts0   _RChannelEnL,2
    goto    READ_tk2_FN
#endif

#if EnTk3    
    jbts0   _RChannelEnL,3
    goto    READ_tk3_FN
#endif

#if EnTk4    
    jbts0   _RChannelEnL,4
    goto    READ_tk4_FN
#endif

#if EnTk5    
    jbts0   _RChannelEnL,5
    goto    READ_tk5_FN
 #endif

#if EnTk6   
    jbts0   _RChannelEnL,6
    goto    READ_tk6_FN
#endif

#if EnTk7    
    jbts0   _RChannelEnL,7
    goto    READ_tk7_FN
#endif

#if EnTk8    
    jbts0   _RChannelEnH,0
    goto    READ_tk8_FN
#endif

#if EnTk9    
    jbts0   _RChannelEnH,1
    goto    READ_tk9_FN
#endif

#if EnTk10    
    jbts0   _RChannelEnH,2
    goto    READ_tk10_FN    
#endif

    bset    berror_F
    goto    READ_tkx_FN_end_1   ;error,no tk ch en 

#if EnTk0 
READ_tk0_FN:
    bset     RTkmaskL,0
    bclr     _RChannelEnL,0	 	
    goto     READ_tkx_FN_end_1			
#endif

#if EnTk1	
READ_tk1_FN:
    bset     RTkmaskL,1
    bclr     _RChannelEnL,1	 		
    goto     READ_tkx_FN_end_1	
#endif

#if EnTk2	 
READ_tk2_FN:
    bset     RTkmaskL,2 
    bclr     _RChannelEnL,2		 
    goto     READ_tkx_FN_end_1
#endif

#if EnTk3
READ_tk3_FN:
    bset     RTkmaskL,3 
    bclr     _RChannelEnL,3	 	
    goto     READ_tkx_FN_end_1
#endif

#if EnTk4		 
READ_tk4_FN:
    bset     RTkmaskL,4 
    bclr     _RChannelEnL,4	 		
    goto     READ_tkx_FN_end_1
#endif

#if EnTk5	 
READ_tk5_FN:
    bset     RTkmaskL,5 
    bclr     _RChannelEnL,5	 	
    goto     READ_tkx_FN_end_1
#endif

#if EnTk6	 
READ_tk6_FN:
    bset     RTkmaskL,6
    bclr     _RChannelEnL,6	 	
    goto     READ_tkx_FN_end_1
#endif

#if EnTk7	 
READ_tk7_FN:
    bset     RTkmaskL,7 
    bclr     _RChannelEnL,7	  
    goto     READ_tkx_FN_end_1
#endif

#if EnTk8	 
READ_tk8_FN:
    bset     RTkmaskH,0 
    bclr     _RChannelEnH,0		 
    goto    READ_tkx_FN_end_1
#endif

#if EnTk9	 
READ_tk9_FN:
    bset     RTkmaskH,1 
    bclr    _RChannelEnH,1	 	
    goto    READ_tkx_FN_end_1
#endif

#if EnTk10	 
READ_tk10_FN:
    bset     RTkmaskH,2 
    bclr     _RChannelEnH,2	 
    goto     READ_tkx_FN_end_1
#endif
	 
READ_tkx_FN_end_1: 

  __endasm;    
}


//*********************************END OF FILE************************************
