/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
* File Name          : M8P626_Touch_Lib_Data.C
* Author             : MASSES CHIP
* Version            : V2.03
* Date               : 2025/12/02   
********************************************************************************   
// ļû޸

*******************************************************************************/

//================================================================================
#include "MassesChip_Define.h"
#include "M8P626_Touch_Lib_CFG.H"

//================================================================================
#define TKLib_FILTER_LEVEL_NUM        6  
//================================================================================
//RAMʼַ޸ģ֤޸ĺ㹻ַ䵽ʹ
// RAM (0x7f+1-14-11-8*TKLib_OPENED_TK_AMOUNT-2*TKLib_TouchLowerPower*TKLib_LP_OPENEDGROUP_AMOUNT) ~ 0x7f ʹ

//================================================================================
__at(0x7b-17-TKLib_FILTER_LEVEL_NUM-8*TKLib_OPENED_TK_AMOUNT) unsigned char RTkTemp0;
__at(0x7b-16-TKLib_FILTER_LEVEL_NUM-8*TKLib_OPENED_TK_AMOUNT) unsigned char RTkTemp1;
__at(0x7b-15-TKLib_FILTER_LEVEL_NUM-8*TKLib_OPENED_TK_AMOUNT) unsigned char RTkTemp2;
__at(0x7b-14-TKLib_FILTER_LEVEL_NUM-8*TKLib_OPENED_TK_AMOUNT) unsigned char RTkTemp3;
__at(0x7b-13-TKLib_FILTER_LEVEL_NUM-8*TKLib_OPENED_TK_AMOUNT) unsigned char RTkTemp4;
__at(0x7b-12-TKLib_FILTER_LEVEL_NUM-8*TKLib_OPENED_TK_AMOUNT) unsigned char RTkTemp5;
__at(0x7b-11-TKLib_FILTER_LEVEL_NUM-8*TKLib_OPENED_TK_AMOUNT) unsigned char RTkTemp6;
__at(0x7b-10-TKLib_FILTER_LEVEL_NUM-8*TKLib_OPENED_TK_AMOUNT) unsigned char RTkTemp7;
__at(0x7b-9-TKLib_FILTER_LEVEL_NUM-8*TKLib_OPENED_TK_AMOUNT) unsigned char RTkTemp8;
__at(0x7b-8-TKLib_FILTER_LEVEL_NUM-8*TKLib_OPENED_TK_AMOUNT) unsigned char RTkTemp9;
__at(0x7b-7-TKLib_FILTER_LEVEL_NUM-8*TKLib_OPENED_TK_AMOUNT) unsigned char RTkTemp10;
__at(0x7b-6-TKLib_FILTER_LEVEL_NUM-8*TKLib_OPENED_TK_AMOUNT) unsigned char RTkTemp11;
__at(0x7b-5-TKLib_FILTER_LEVEL_NUM-8*TKLib_OPENED_TK_AMOUNT) unsigned char RTkTemp12;
__at(0x7b-4-TKLib_FILTER_LEVEL_NUM-8*TKLib_OPENED_TK_AMOUNT) unsigned char RTkTemp13;

__at(0x7b-3-TKLib_FILTER_LEVEL_NUM-8*TKLib_OPENED_TK_AMOUNT) unsigned char RTkBuff2;
__at(0x7b-2-TKLib_FILTER_LEVEL_NUM-8*TKLib_OPENED_TK_AMOUNT) unsigned char RTkBuff4;
__at(0x7b-1-TKLib_FILTER_LEVEL_NUM-8*TKLib_OPENED_TK_AMOUNT) unsigned char RTkBuff5;

#if  TKLib_OPENED_TK_AMOUNT
__at(0x7b-TKLib_FILTER_LEVEL_NUM-8*TKLib_OPENED_TK_AMOUNT) unsigned int RTkGBuff0[TKLib_OPENED_TK_AMOUNT];
__at(0x7b-TKLib_FILTER_LEVEL_NUM-6*TKLib_OPENED_TK_AMOUNT) unsigned int RTkGBuff1[TKLib_OPENED_TK_AMOUNT];
__at(0x7b-TKLib_FILTER_LEVEL_NUM-4*TKLib_OPENED_TK_AMOUNT) unsigned char RTkGBuff2[TKLib_OPENED_TK_AMOUNT];
__at(0x7b-TKLib_FILTER_LEVEL_NUM-3*TKLib_OPENED_TK_AMOUNT) unsigned char RTkGBuff3[TKLib_OPENED_TK_AMOUNT];
__at(0x7b-TKLib_FILTER_LEVEL_NUM-2*TKLib_OPENED_TK_AMOUNT) unsigned char RTkGBuff5[TKLib_OPENED_TK_AMOUNT];
__at(0x7b-TKLib_FILTER_LEVEL_NUM-1*TKLib_OPENED_TK_AMOUNT) unsigned char RTkGBuff6[TKLib_OPENED_TK_AMOUNT];

__at(0x7b-TKLib_FILTER_LEVEL_NUM) unsigned char RTkGBuff4[6]; 

#endif

__at(0x7b) unsigned char RChannelEnL;
__at(0x7c) unsigned char RChannelEnH;
__at(0x7d) unsigned char RKeyOnFlgL;
__at(0x7e) unsigned char RKeyOnFlgH;
__at(0x7f) unsigned char RTkBitFlag;

//================================================================================
//    ~ 0x07EFûʹ
//================================================================================
void Touch_Lib_Data(void)
{
  __asm;
#if (TKLib_TouchLowerPower==1)
TAB_TOUCH_TKLP_CFG_DATA:
 org   (0x07EF+1-14-TKLib_OPENED_TK_AMOUNT-2)

TAB_LPTOUCH_CONFIRM_TIME_DATA:
 RETIA		4

TAB_TOUCH_TKLP_LP_SLEEPTIME:
 RETIA     (TKLib_LP_SLEEPTIME&0xff)
#endif

TAB_TOUCH_CFG_DATA:
 org    (0x07EF+1-14-TKLib_OPENED_TK_AMOUNT)
 
TAB_TOUCH_TK_EN_MASK_L_DATA:
 RETIA     (TKLib_TK_EN_MASK&0X00FF)
 
TAB_TOUCH_TK_EN_MASK_H_DATA:
 RETIA     (TKLib_TK_EN_MASK>>8)
 
TAB_TOUCH_OPENED_TK_AMOUNT_DATA: 
 RETIA     (TKLib_OPENED_TK_AMOUNT&0x0F) 
 
TAB_TOUCH_TKCKS_DATA: 
 RETIA     (((TKLib_TKMODE&0x01)<<3)+(0x01<<7)+((TKLib_TKCKS&0x03)<<4)) 
 
TAB_TOUCH_TK_VCS_VCHG_DATA: 
 RETIA     (((TKLib_TK_VCS&0x03)<<6)+((TKLib_TK_VCHG&0x03)<<4))

TAB_TOUCH_NUM_DATA:
 RETIA     (((TKLib_TOUCH_NUM&0x0F)<<0)+((0)<<6)+((TKLib_Multi_TOUCH_RST&0x01)<<7))

TAB_TOUCH_LONG_TOUCH_TIME:  
 RETIA     (TKLib_LONG_TOUCH_TIME&0x0F)
 
TAB_TOUCH_CONFIRM_TIME_DATA: 
 RETIA     ((TKLib_EFFECTIVE_TOUCH_TIME&0x0F)+((TKLib_INVALID_TOUCH_TIME&0x0F)<<4))

TAB_TOUCH_SCAN_DATA:
 RETIA     (TKLib_ScanCnt-1)
 
TAB_TOUCH_POWER_ON_DELAY_TIME:
 RETIA     (TKLib_PowerOn_Delay_Time&0xff)
 
TAB_TOUCH_BASELINE_UP_SPEED:
 RETIA		(TKLib_BaseLineUpSpeed&0x0f)
 
TAB_TOUCH_BASELINE_DOWN_SPEED:
 RETIA		(TKLib_BaseLineDownSpeed&0x0f)

TAB_TOUCH_FN_DATA: 
#if EnTk0  
 DW     ((TKLib_TK0_CAPS&0x0f)+((TKLib_TK0_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk1 
 DW     ((TKLib_TK1_CAPS&0x0f)+((TKLib_TK1_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk2 
 DW     ((TKLib_TK2_CAPS&0x0f)+((TKLib_TK2_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk3 
 DW     ((TKLib_TK3_CAPS&0x0f)+((TKLib_TK3_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk4 
 DW     ((TKLib_TK4_CAPS&0x0f)+((TKLib_TK4_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk5 
 DW     ((TKLib_TK5_CAPS&0x0f)+((TKLib_TK5_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk6 
 DW     ((TKLib_TK6_CAPS&0x0f)+((TKLib_TK6_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk7 
 DW     ((TKLib_TK7_CAPS&0x0f)+((TKLib_TK7_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk8 
 DW     ((TKLib_TK8_CAPS&0x0f)+((TKLib_TK8_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk9 
 DW     ((TKLib_TK9_CAPS&0x0f)+((TKLib_TK9_F_THRESHOLD&0xff)<<8))
#endif

#if EnTk10 
 DW     ((TKLib_TK10_CAPS&0x0f)+((TKLib_TK10_F_THRESHOLD&0xff)<<8))
#endif

#if (TKLib_TouchLowerPower==1)
 GLOBAL TAB_LPTOUCH_CONFIRM_TIME_DATA
 GLOBAL TAB_TOUCH_TKLP_LP_SLEEPTIME
#endif

 GLOBAL TAB_TOUCH_TK_EN_MASK_L_DATA 
 GLOBAL TAB_TOUCH_TK_EN_MASK_H_DATA 
 GLOBAL TAB_TOUCH_OPENED_TK_AMOUNT_DATA           
 GLOBAL TAB_TOUCH_TKCKS_DATA   
 GLOBAL TAB_TOUCH_TK_VCS_VCHG_DATA 
 GLOBAL TAB_TOUCH_NUM_DATA
 GLOBAL TAB_TOUCH_LONG_TOUCH_TIME
 GLOBAL TAB_TOUCH_CONFIRM_TIME_DATA 
 GLOBAL TAB_TOUCH_SCAN_DATA
 GLOBAL	TAB_TOUCH_POWER_ON_DELAY_TIME 
 GLOBAL	TAB_TOUCH_BASELINE_UP_SPEED
 GLOBAL	TAB_TOUCH_BASELINE_DOWN_SPEED 
 GLOBAL TAB_TOUCH_FN_DATA 

//================================================================================
#if 1       // 0:رմϢʾ1:Ϣʾ
//================================================================================
//CDC MODE
#if (TKLib_TKMODE > 1)
    Error "    Error:Please setting TKLib_TKMODE  {0,1}  "  
#endif

#if (TKLib_TKMODE == 0)
    MESSG "    ģʽ:תģʽ"  
#endif
#if (TKLib_TKMODE == 1)
    MESSG "    ģʽ:ģʽ"  
#endif

//================================================================================

#if EnTk0
  MESSG "    TK0:Enable"
#endif
#if EnTk1
  MESSG "    TK1:Enable"
#endif
#if EnTk2
  MESSG "    TK2:Enable"
#endif
#if EnTk3
  MESSG "    TK3:Enable"
#endif
#if EnTk4
  MESSG "    TK4:Enable"
#endif
#if EnTk5
  MESSG "    TK5:Enable"
#endif
#if EnTk6
  MESSG "    TK6:Enable"
#endif
#if EnTk7
  MESSG "    TK7:Enable"
#endif
#if EnTk8
  MESSG "    TK8:Enable"
#endif
#if EnTk9
  MESSG "    TK9:Enable"
#endif
#if EnTk10
  MESSG "    TK10:Enable"
#endif

//================================================================================
#if (TKLib_OPENED_TK_AMOUNT == 0)
  Error "    No channel is enabled,Please reconfigure EnTk0~EnTk10"
#endif

//================================================================================
//CDC clock
#if (TKLib_TKCKS > 3)
    Error "    Error: Please setting TKLib_TKCKS <= 3 "  
#endif

#if (TKLib_TKCKS == 0)
  MESSG "    CDC Clock:Fosc/4"
#endif
#if (TKLib_TKCKS == 1)
  MESSG "    CDC Clock:Fosc/8"
#endif
#if (TKLib_TKCKS == 2)
  MESSG "    CDC Clock:Fosc/16"
#endif
#if (TKLib_TKCKS == 3)
  MESSG "    CDC Clock:Fosc/32"
#endif

//================================================================================
#if (TKLib_TOUCH_NUM == 0)
  Error "    Error:Please setting TKLib_TOUCH_NUM > 0"
#endif

//================================================================================
#if (TKLib_LONG_TOUCH_TIME == 0)
  MESSG "    ΰʱ书ܣ뿪־һֱλ "
#endif
#if (TKLib_LONG_TOUCH_TIME == 1)
  Error "    ֹ "
#endif
#if (TKLib_LONG_TOUCH_TIME > 15)
  Error "    Error:Please setting TKLib_LONG_TOUCH_TIME <= 15"
#else
#if (TKLib_LONG_TOUCH_TIME > 1)
  MESSG "    ʱ书ܣ뿪־һʱ󣬻 "
#endif
#endif

//================================================================================
#if (TKLib_Multi_TOUCH_RST > 1)
    Error "    Error:Please setting TKLib_Multi_TOUCH_RST  {0,1}  "  
#endif

//================================================================================
#if (TKLib_CaliBaseTime < 1)
    Error "    Error: Please setting TKLib_CaliBaseTime >= 1" 
#endif
#if (TKLib_CaliBaseTime > 254)
    Error "    Error: Please setting TKLib_CaliBaseTime <= 254"  
#endif

#if (TKLib_LongKeyBaseTime < 1)
    Error "    Error: Please setting TKLib_LongKeyBaseTime >= 1" 
#endif
#if (TKLib_LongKeyBaseTime > 254)
    Error "    Error: Please setting TKLib_LongKeyBaseTime <= 254"  
#endif

//================================================================================
#if (TKLib_EFFECTIVE_TOUCH_TIME == 0)
  Error "    Error:Please setting TKLib_EFFECTIVE_TOUCH_TIME > 0"
#endif
#if (TKLib_EFFECTIVE_TOUCH_TIME > 14)
  Error "    Error:Please setting TKLib_EFFECTIVE_TOUCH_TIME <= 14"
#endif

//================================================================================
#if (TKLib_INVALID_TOUCH_TIME == 0)
  Error "    Error:Please setting TKLib_INVALID_TOUCH_TIME > 0"
#endif
#if (TKLib_INVALID_TOUCH_TIME > 14)
  Error "    Error:Please setting TKLib_INVALID_TOUCH_TIME <= 14"
#endif

//================================================================================
#if (TKLib_TK0_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK0_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK1_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK1_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK2_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK2_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK3_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK3_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK4_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK4_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK5_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK5_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK6_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK6_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK7_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK7_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK8_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK8_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK9_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK9_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK10_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK10_F_THRESHOLD <= 254"  
#endif

//================================================================================
#if (TKLib_TK0_F_THRESHOLD <8)
  Error "    Error:Please setting TKLib_TK0_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK1_F_THRESHOLD <8)
  Error "    Error:Please setting TKLib_TK1_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK2_F_THRESHOLD <8)
  Error "    Error:Please setting TKLib_TK2_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK3_F_THRESHOLD <8)
  Error "    Error:Please setting TKLib_TK3_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK4_F_THRESHOLD <8)
  Error "    Error:Please setting TKLib_TK4_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK5_F_THRESHOLD <8)
  Error "    Error:Please setting TKLib_TK5_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK6_F_THRESHOLD <8)
  Error "    Error:Please setting TKLib_TK6_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK7_F_THRESHOLD <8)
  Error "    Error:Please setting TKLib_TK7_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK8_F_THRESHOLD <8)
  Error "    Error:Please setting TKLib_TK8_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK9_F_THRESHOLD <8)
  Error "    Error:Please setting TKLib_TK9_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK10_F_THRESHOLD <8)
  Error "    Error:Please setting TKLib_TK10_F_THRESHOLD >= 8"
#endif

//================================================================================
//CDC VCHG
#if (TKLib_TK_VCHG > 3)
    Error "    Error:Please setting TKLib_TK_VCHG <= 3 "  
#endif

#if (TKLib_TK_VCHG == 0)
    MESSG "    ѹ:2V"  
#endif
#if (TKLib_TK_VCHG == 1)
    MESSG "    ѹ:3V"   
#endif
#if (TKLib_TK_VCHG == 2)
    MESSG "    ѹ:4V"   
#endif
#if (TKLib_TK_VCHG == 3)
    MESSG "    ѹ:VDD" 
#endif

//================================================================================
//CDC VCS
#if (TKLib_TKMODE == 0)
#if (TKLib_TK_VCS > 3)
    Error "    Error:Please setting TKLib_TK_VCS   {0,1,2,3} "  
#endif
#if (TKLib_TK_VCS == 0)
    MESSG "    οѹ:1.2V"  
#endif
#if (TKLib_TK_VCS == 1)
    MESSG "    οѹ:0.5 * ѹ"   
#endif
#if (TKLib_TK_VCS == 2)
    MESSG "    οѹ:0.75 * ѹ"   
#endif
#if (TKLib_TK_VCS == 3)
    MESSG "    οѹ:0.9 * ѹ" 
#endif
#else
#if (TKLib_TK_VCS > 3)
    Error "    Error:Please setting TKLib_TK_VCS   {1,2,3} "  
#endif
#if (TKLib_TK_VCS == 0)
    Error "    Error:Please setting TKLib_TK_VCS   {1,2,3} " 
#endif
#if (TKLib_TK_VCS == 1)
    MESSG "    οƵ:"   
#endif
#if (TKLib_TK_VCS == 2)
    MESSG "    οƵ:"   
#endif
#if (TKLib_TK_VCS == 3)
    MESSG "    οƵ:" 
#endif
#endif

//================================================================================
#if (TKLib_TouchLowerPower==1)
  MESSG "    ͹ģʽѿ "
#endif
#if (TKLib_TouchLowerPower>1)
  MESSG "    ͹ģʽôTKLib_TouchLowerPower  {0,1} "
#endif
//================================================================================
#if (TKLib_ScanCnt < 3 )
    Error "    Error: Please setting TKLib_ScanCnt >= 3"  
#endif
#if (TKLib_ScanCnt > 254)
    Error "    Error: Please setting TKLib_ScanCnt < 255"  
#endif
//================================================================================
#if (TKLib_PowerOn_Delay_Time > 254)
    Error "    Error: Please setting TKLib_PowerOn_Delay_Time < 255"  
#endif
//================================================================================
#if (TKLib_BaseLineUpSpeed > 14)
    Error "    Error: Please setting TKLib_BaseLineUpSpeed < 15"  
#endif
//================================================================================
#if (TKLib_BaseLineDownSpeed > 14)
    Error "    Error: Please setting TKLib_BaseLineDownSpeed < 15"  
#endif
//================================================================================
#endif

  __endasm;
}

//*********************************END OF FILE************************************

