/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
* File Name          : M8P626_Touch_UartDebug_LIB_Init.C
* Author             : MASSES CHIP
* Version            : V2.03
* Date               : 2025/12/02 
********************************************************************************

*******************************************************************************/

//================================================================================
#include "zc.h"
#include "M8P626_Touch_UartDebug_LIB_Init.H"

//================================================================================
extern unsigned char RTkTemp1;
extern unsigned char RTkTemp2;

//================================================================================
#if TKUartDebugLib_DEBUG_MODE_SWITCH
void TK_TouchUartDebug_Init(void)
{
  __asm

  MESSG "    串口调试功能：已开启，请调试结束后关闭"

#if TKUartDebugLib_DEBUG_UART_SELECT
//tx  PIN PB3
  bset    OEB,3	     //tx pin out put
  movia   b'10000000'  // txen 异步 8bit 1:4
  movar   TXCR

  movia   high(16000000/4/TKUartDebugLib_BAUDRATE-1)
  movar   BRGDH
  movia   low(16000000/4/TKUartDebugLib_BAUDRATE-1)  // 16M(fosc)/4/(0x03+1) = 1M Baudrate = fosc/n/(BRGDH+1)
  movar   BRGDL

  MESSG "    串口调试端口使用的是MCU硬件资源，端口只能在PB3上 "

#else
  BSET    OE_UART_TX,N_UART_TX	     //tx pin out put

  MOVIA   b'00001011' // UP FOSC 1:8
  MOVAR   T1CR

    MOVIA   low(T1_LOAD_C_Init)
    MOVAR   TC1CL
  
  MESSG "    串口调试端口使用的是IO软件模拟，端口可根据需求配置，软件串口使用的是定时器TC1，若与其它程序有冲突，请做调整 "


#endif
  __endasm;
}

#endif

//================================================================================
#if TKUartDebugLib_DEBUG_MODE_SWITCH
void TK_Debug_Mode_Uart_SendChar(void)
{
  __asm
#if TKUartDebugLib_DEBUG_UART_SELECT
  MOVAR   TXREG
  jbts1   TXCR,6
  goto    $-1
#else
  MOVAR   R_UART_TX_BUF
  CALL    _TASK_UART_DATATX
#endif
  __endasm;
}

#endif

//================================================================================
#if TKUartDebugLib_DEBUG_MODE_SWITCH
void TK_Debug_Mode_SendWord(void)
{
  __asm
#if TKUartDebugLib_DEBUG_UART_SELECT
  MOVR    _RTkTemp2,A
  MOVAR   TXREG

  jbts1  INTF0,4 //TXIF
  goto   $-1

  MOVR    _RTkTemp1,A
  MOVAR   TXREG

  jbts1  TXCR,6
  goto   $-1
#else
  MOVR    _RTkTemp2,A
  MOVAR   R_UART_TX_BUF

  CALL    _TASK_UART_DATATX

  MOVR    _RTkTemp1,A
  MOVAR   R_UART_TX_BUF

  CALL    _TASK_UART_DATATX
#endif
  __endasm;
}

#endif

#if (TKUartDebugLib_DEBUG_MODE_SWITCH&&(TKUartDebugLib_DEBUG_UART_SELECT==0))
//====================================================================
void TASK_UART_DATATX(void)
{
  __asm
  BCLR		bTC1IF
  BSET		bTC1IE
  CLRR		TC1CH
  BSET		T1CR,7
  CLRR		R_UART_TX_CNT

  UART_LOOP:
  JBTS0		bTC1IE
  GOTO		UART_LOOP

  BCLR		T1CR,7
  __endasm;
}

#endif
//================================================================================

//*********************************END OF FILE************************************
