/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
* File Name          : M8P632_Touch_M0_Lib.H
* Author             : MASSES CHIP
* Version            : V3.04
* Date               : 2025/12/02
********************************************************************************

* 注意，触摸库中有用到间接寻址寄存器(FSR0,FSR1,HBUF)，若客户在中断中有使用，
*       请用户进入中断后先备份(push指令后备份)此3个寄存器，出中断后再恢复(pop指令前恢复)。

********************************************************************************/

//================================================================================ 
#ifndef __M8P632_Touch_M0_Lib_INC__
#define __M8P632_Touch_M0_Lib_INC__
//================================================================================ 
extern void TkInit(void);                 // 触摸模块初始化程序，堆栈深度4级，调用此程序前，必须打开ADC模块2V/3V/4V之任一参考电源
extern void TkScan(void);                 // 触摸按键扫描程序，堆栈深度3级，必需保证主循环中调用
extern void TkSignalHandle(void);         // 触摸数据处理程序，堆栈深度3级，bOneScanDone 被置"1" 后，调用一次
extern void ScanContinue(void);           // 触摸扫描启动程序，堆栈深度4级，先调用TkSignalHandle，先清除bOneScanDone，后调用ScanContinue
extern void BaseLineReset(void);          // 基线强制复位程序，堆栈深度3级
 
//================================================================================ 
extern void TkLowPowerMode(void);         // 触摸模块低功耗程序，堆栈深度3级，要求ScanContinue()程序必须跟随在后面
                                          // 调用此函数前必须将相关端口设置

//================================================================================ 
extern void TK_TouchUartDebug_Init(void); // 触摸串口调试初始化程序
extern void TK_TouchUartDebug(void);      // 触摸串口调试程序，堆栈深度3级
 
//================================================================================  
extern ob8 RTkBitFlag;

#define	bOneScanDone          RTkBitFlag.b0  //触摸扫描一轮完成标志，RTkBitFlag中其它BIT位用户请勿操作
#define	bT_TK_CBT_F           RTkBitFlag.b1  //触摸更新时基标志
#define	bT_TK_LBT_F           RTkBitFlag.b2  //长按清除时基标志 
#define bBaseLineUpdateOK 	  RTkBitFlag.b4  //基值赋初值结束
#define bPowerOnDelayTimeOK   RTkBitFlag.b5  //上电延时结束

#define	bLowPowerModeRun      RTkBitFlag.b7  //0: Normal; 1: LowPower
 
//================================================================================  
// 用户只读，不可写入操作，切记！ 
extern unsigned char RKeyOnFlgL; 
extern unsigned char RKeyOnFlgH;

#define F_TK0_On     (RKeyOnFlgL&0x01)  // TK0按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK1_On     (RKeyOnFlgL&0x02)  // TK1按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK2_On     (RKeyOnFlgL&0x04)  // TK2按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK3_On     (RKeyOnFlgL&0x08)  // TK3按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK4_On     (RKeyOnFlgL&0x10)  // TK4按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK5_On     (RKeyOnFlgL&0x20)  // TK5按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK6_On     (RKeyOnFlgL&0x40)  // TK6按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK7_On     (RKeyOnFlgL&0x80)  // TK7按键触摸响应标志，1：表示被触摸；0：未被触摸。


//================================================================================  
extern u8 RTkBuff4;
extern u8 RTkBuff5;

#define RTK_CaliBaseTime_Cnt           RTkBuff4  
#define RTK_LongKeyBaseTime_Cnt        RTkBuff5

#endif 
 
//*********************************END OF FILE************************************
