;*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
;* File Name          : MAIN.ASM
;* Author             : MASSES CHIP
;* Version            : V3.06
;* Date               : 2025/12/02
;********************************************************************************
; 
; 16M/4T, WDT EN 72MS, RST IS IO ,BOR 2.4V,RST TIMER 18MS
;
;********************************************************************************
  	 
;================================================================================  
#include     zc.inc   
#include     M8R_P_MACRO.inc 

;================================================================================  
#include     M8P632_Touch_M1_Lib.inc
#include     M8P632_Touch_M1_Lib_CFG.inc 
#include     M8P632_Touch_M1_Lib_Data.inc 
#include     M8P632_Touch_M1_UartDebug_LIB_Init.inc

;================================================================================  
 CODE 
;================================================================================  
userdata  udata 0
R_Time_Flag                 RES 1
#define bT_125US_F    R_Time_Flag,0
#define	bT_500US_F    R_Time_Flag,1
#define	bT_10MS_F     R_Time_Flag,2

R_500US_COUNT               RES 1
R_10MS_COUNT                RES 1

R_GOTOLOWPOWERMODE_COUNT    RES 1
;====================================================================   
; T0 BASE TIME  SET
#define	T0_125_US                     125   ;125U S(1 TIMER0 CLOCK) < T0_BASE_MS <4.096MS
#define T0_LOAD_C_Init	              T0_125_US*16000000/1000000 ; FOSC 1:1

#define T_500US_C_Init_DF             D'4'
#define T_10MS_C_Init_DF              D'20'
#define T_GOTOLOWPOWERMODE_C_Init_DF  D'250'  ;无触摸下超时休眠检测次数，无触摸下超时休眠时间 = 次数*触摸通道检测数*0.5ms


;====================================================================                   
    org     .0          
    GOTO    MainProgram
           
    org     .8
ISR_Handle:
    push

T0_ISR:
    jbts0   bTC0IE
    GOTO    ISR_T0_Handle
    
T1_ISR:	
#if (TKUartDebugLib_DEBUG_MODE_SWITCH&&(TKUartDebugLib_DEBUG_UART_SELECT==0)) 	
    jbts0   bTC1IE
    GOTO	ISR_UART_TX_ACT
;    GOTO    ISR_Handle_END
#endif

ISR_Handle_END:
    pop
    retie  
     
;====================================================================   
ISR_T0_Handle:
    jbts1   bTC0IF
    GOTO    T1_ISR
    BSET    bT_125US_F
	
;0.5MS
    DJZR    R_500US_COUNT,R
    GOTO    ISR_T0_Handle_END
    MOVI    R_500US_COUNT,T_500US_C_Init_DF
    BSET    bT_500US_F

TK_BASETIMER:
;触摸库需要的时基，不可删除，但可以调整位置，即只需要产生下列时基即可
;校准基准时基
    INCR    RTK_CaliBaseTime_Cnt,R
    MOVIA   (TKLib_CaliBaseTime-1)
    JLAR    RTK_CaliBaseTime_Cnt    
    GOTO    TK_BASETIMER_END
    CLRR    RTK_CaliBaseTime_Cnt
    BSET    bT_TK_CBT_F   ;必须定时产生此标志

;长按长按保护检测基准时基 
    INCR    RTK_LongKeyBaseTime_Cnt,R
    MOVIA   (TKLib_LongKeyBaseTime-1)
    JLAR    RTK_LongKeyBaseTime_Cnt    
    GOTO    TK_BASETIMER_END
    CLRR    RTK_LongKeyBaseTime_Cnt
    BSET    bT_TK_LBT_F   ;若开启长按保护，必须定时产生此标志

TK_BASETIMER_END:
	
    DJZR    R_10MS_COUNT,R
    GOTO    ISR_T0_Handle_END
    MOVI    R_10MS_COUNT,T_10MS_C_Init_DF
    BSET    bT_10MS_F
	
ISR_T0_Handle_END:
    BCLR    bTC0IF
    GOTO    ISR_Handle_END

;====================================================================   
#if (TKUartDebugLib_DEBUG_MODE_SWITCH&&(TKUartDebugLib_DEBUG_UART_SELECT==0)) 		
ISR_UART_TX_ACT:
	MOVR		R_UART_TX_CNT,A
	JBTS1		STATUS,Z
	GOTO		ISR_UART_TX_BODY
IST_UART_TX_START:
	BCLR		P_UART_TX,N_UART_TX
	GOTO		ISR_UART_TX_START_EXIT

ISR_UART_TX_BODY:
	JCMPAI		9
	GOTO		ISR_UART_TX_DATA
IST_UART_TX_END:
	BSET		P_UART_TX,N_UART_TX
  BCLR        bTC1IE
	GOTO		ISR_UART_TX_EXIT
	
ISR_UART_TX_DATA:
	JBTS0		R_UART_TX_BUF,0
	BSET		P_UART_TX,N_UART_TX
	JBTS1		R_UART_TX_BUF,0
	BCLR		P_UART_TX,N_UART_TX

ISR_UART_TX_DATA_EXIT:
	RRR		R_UART_TX_BUF,R	
ISR_UART_TX_START_EXIT:
	INCR		R_UART_TX_CNT,R
	GOTO		ISR_UART_TX_EXIT
;;----------------------------------
ISR_UART_TX_EXIT:
	BCLR		bTC1IF
	GOTO		ISR_Handle_END	
#endif	
	
;==================================================================== 
MainProgram:
    call    Init
     	 
MainLoop:
    CALL    _TkScan         ;主循环一直扫描，故主循环间隔不宜过长以免影响响应时间
    JBTS1   bOneScanDone    ;查询一轮是否转换结束     
    goto    MainLoop_1

#if TKUartDebugLib_DEBUG_MODE_SWITCH 
#if(TKUartDebugLib_DEBUG_UART_SELECT==0)
    BCLR    bTC0IE
#endif
	
    call    _TK_TouchUartDebug
	
#if(TKUartDebugLib_DEBUG_UART_SELECT==0)	
    BSET    bTC0IE	
#endif	
#endif	
	
    call    _TkSignalHandle ;一轮转换完成,清除标志
    BCLR    bOneScanDone
 	
; 按键响应
    CJZ2 _RKeyOnFlgL,_RKeyOnFlgH,ALLKEY_UP_Handle  ;检查是否有按键被按下
    MOVI R_GOTOLOWPOWERMODE_COUNT,T_GOTOLOWPOWERMODE_C_Init_DF

;    jbts0   F_TK0_On
;    bclr    iob,0
;    jbts0   F_TK2_On
;    bclr    iob,1
;    jbts0   F_TK4_On
;    bclr    iob,2
    goto    ALLKEY_UP_Handle_end
	
ALLKEY_UP_Handle:
    DJZR    R_GOTOLOWPOWERMODE_COUNT,R
    GOTO    ALLKEY_UP_Handle_end
    MOVI    R_GOTOLOWPOWERMODE_COUNT,T_GOTOLOWPOWERMODE_C_Init_DF
    BSET    bLowPowerModeRun	
	
ALLKEY_UP_Handle_end:

#if TKLib_TouchLowerPower 
    JBTS1   bPowerOnDelayTimeOK 
    goto    Next_OneScan
    JBTS1   bBaseLineUpdateOK 
    goto    Next_OneScan
    JBTS1   bLowPowerModeRun 
    goto    Next_OneScan


;下面加睡眠前其它需要低功耗处理的操作(除触摸外的，触摸相关的_TkLowPowerMode会自行处理)	
;如低功耗模式下端口处理，外设模块等
;WDT 与 CPU 工作模式 用户不需要处理





    BCLR    INTCR0,TC0IE   ;关闭其他唤醒源，本demo code外部只打开了T0，故只关闭T0
;触摸低功耗模式	
    call    _TkLowPowerMode

;下面加唤醒后其它需要恢复的操作	
	CLRR    TC0CH
    CLRR    TC0CL
	
    MOVIA   high(T0_LOAD_C_Init)
    MOVAR   TC0PRH
    MOVIA   low(T0_LOAD_C_Init)
    MOVAR   TC0PRL
	
    MOVIA   b'10001000' ;UP FOSC 1:1
    MOVAR   T0CR
    BSET    bTC0IE
	
#endif 

Next_OneScan:
    CALL    _ScanContinue	
	
; 其它主循环程序
MainLoop_1:
    CLRWDT
	
	
    goto    MainLoop  
 
;====================================================================                                                 
init: 
; Stack:	Level 5
IO_init: 
;触摸口建议设置成输出模式。如输出全0或全1 
    movia   b'11111111'  ;1：output  0：input
    movar   oea
    clrr    ioa
    movia   b'11111111'  ;1：output  0：input
    movar   oeb
    clrr    iob   
    movia   b'11101111'  ;1：output  0：input
    movar   oec
    clrr    ioc
    movia   b'11111111'  ;1：output  0：input
    movar   oed
    movia   b'11111111'  ;1：output  0：input	
    movar   iod

RAM_INIT:	
ClrRam:        
    clrr    fsr0     ;0x00ok
ClrRam_loop:
    clrr    indf0
    incr    fsr0,r
    movr    fsr0,a
    jcmpai  low(0xff+1)   ;0xff (clr ram addar +1)
    goto    ClrRam_loop
ClrRam_end:	

; RAM 数据赋值
    MOVI	R_500US_COUNT,T_500US_C_Init_DF
    MOVI    R_10MS_COUNT,T_10MS_C_Init_DF	
    MOVI    R_GOTOLOWPOWERMODE_COUNT,T_GOTOLOWPOWERMODE_C_Init_DF	
RAM_INIT_END:

TK_INIT:
#if TKUartDebugLib_DEBUG_MODE_SWITCH 
    call    _TK_TouchUartDebug_Init
#endif

;AD   
    movia   b'00001110'  ; adc ch = gnd
    movar   adcon0   
  
    bset    adcon1,0  ; CDC VREF  ;调用TkInit此程序前，必须打开ADC模块2V/3V/4V之任一参考电源
;    bset    adcon1,1  ; CDC VREF  
  
;TK  
    call    _TkInit
	
TK_INIT_END:
	
T0_INIT:
    CLRR    TC0CH
    CLRR    TC0CL
	
    MOVIA   high(T0_LOAD_C_Init)
    MOVAR   TC0PRH
    MOVIA   low(T0_LOAD_C_Init)
    MOVAR   TC0PRL
	
    MOVIA   b'10001000' ;UP FOSC 1:1
    MOVAR   T0CR
    BSET    bTC0IE
	
T0_INIT_END:	

;ENALBE gie	
    bset    option,gie	
	
    return  
   
;====================================================================           
     END 
	 
;*********************************END OF FILE************************************
