/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
* File Name          : M8P632_Touch_M1_Lib_CFG.C
* Author             : MASSES CHIP
* Version            : V3.06
* Date               : 2025/12/02
********************************************************************************

// 本文件用户不可自行修改

*******************************************************************************/

//================================================================================
#include "zc.h"
#include "MassesChip_Define.h"
#include "M8P632_Touch_M1_Lib_CFG.h"
#include "M8P632_Touch_M1_Lib.h"


//================================================================================
#if TKLib_TouchLowerPower
void WDT_WakeUp_Handle(void)
{
//此程序是在触摸低功耗模式下，需要处理的操作，如有需要可增加操作程序  
//如RTC时钟1S计时程序,LCD时钟刷新显示程序等等
  
	IOA ^=0x01<<3;
  
  
//  bLowPowerModeRun = 0 ; //可根据需求，判断系统是否需要强制唤醒(清bLowPowerModeRun，强制唤醒系统)
 
}

void SleepTimeCheckHandle(void)
{
  __asm 
#if TKLib_SleepWaKeUpTimeCheck
 extern TAB_TOUCH_TKLP_LP_SLEEPTIME
 extern _RTkTemp0

	movia	0
	jcmpar	_RTkTemp0
	goto	SleepTimeCheckHandle_1

	bclr	T0CR,7
    CLRR    TC0CL
    CLRR    TC0CH

	movia	0xff
	movar	TC0PRL
	movar	TC0PRH

    MOVIA   b'00000000' ;UP FOSC 1:1
    MOVAR   T0CR

	bclr	T2CR,7
    CLRR    TC2CL
    CLRR    TC2CH

; 用定时器2选择高频定时1Ms
	movia	0xE7
	movar	TC2PRL
	movia	0x03
	movar	TC2PRH
    bclr    bTC2IF
    MOVIA   b'10001100' ;UP fosch 1:16
    MOVAR   T2CR	
	bset	T0CR,7
	jbts1	bTC2IF
	goto	$-1
	bclr	T0CR,7
	bclr	T2CR,7
	bclr	bTC2IF
	call    TAB_TOUCH_TKLP_LP_SLEEPTIME
	movar	_RTkTemp2

	clrr	TC0PRL
	clrr	TC0PRH
SleepTimeCheckHandle_Loop:
	movr    TC0CL,a
	addar	TC0PRL,r
	movr    TC0CH,a	
	adcar	TC0PRH,r
	djzr	_RTkTemp2,r
	goto	SleepTimeCheckHandle_Loop
	bset	T0CR,7
SleepTimeCheckHandle_1:
	incr	_RTkTemp0,r
	movia	TKLib_LP_CHECK_TIMER
	jlar	_RTkTemp0
	goto	SleepTimeCheckHandle_End
	clrr	_RTkTemp0

SleepTimeCheckHandle_End:
#endif
  __endasm;
}
#endif

//================================================================================
#if TKLib_TouchLowerPower
void RCOUT_OUTPUT_EN(void)
{
#if TKLPLib_RCOUT_EN
  P_RCOUT&=~(0X01<<N_RCOUT);
  OE_RCOUT|=(0X01<<N_RCOUT);
#endif
}
#endif


//================================================================================
#if TKLib_TouchLowerPower
void RCOUT_OUTPUT_DIS(void)
{
#if TKLPLib_RCOUT_EN
  OE_RCOUT&=~(0X01<<N_RCOUT);
#endif
}
#endif

//================================================================================
void ScanNextChannel(void)
{
  __asm  
 
; Stack:	Level 3
; INPUT:	 
; OUTPUT:	
; OTHER	:	

 extern TKCOM_PIN_OUT
 extern _READ_TK_EN_MASK_DATA 
 
 extern TAB_TOUCH_FN_DATA 
 extern _RChannelEnL    
 extern _RChannelEnH   
  
 extern _RTkTemp4 
#define _R_CNT          _RTkTemp4

 extern _RTkBuff2 
#define RTk_CH            _RTkBuff2  
  
    CALL    TKCOM_PIN_OUT 


; set tk ch	
    clrr    TK1CHSL
    clrr    TK1CHSH  ;关闭所有连接的通道

#if EnTk16		
    jbts0   _RChannelEnL,0
    goto    scantk16_set
#endif

#if EnTk17	    
    jbts0   _RChannelEnL,1
    goto    scantk17_set
#endif

#if EnTk18	    
    jbts0   _RChannelEnL,2
    goto    scantk18_set
#endif

#if EnTk19	    
    jbts0   _RChannelEnL,3
    goto    scantk19_set
#endif

#if EnTk20	    
    jbts0   _RChannelEnL,4
    goto    scantk20_set
#endif

#if EnTk21	    
    jbts0   _RChannelEnL,5
    goto    scantk21_set
#endif

#if EnTk30	    
    jbts0   _RChannelEnH,6
    goto    scantk30_set
#endif

#if EnTk31	    
    jbts0   _RChannelEnH,7
    goto    scantk31_set
#endif

    bset    _RTkBitFlag,0
    CALL    _READ_TK_EN_MASK_DATA  
    goto    ScanNextChannel_end ;error	
    
#if EnTk16		
scantk16_set:
    bclr    _RChannelEnL,0	 
    bset    TK1CHSL,0  		
    goto    ScanNextChannel_end_1			
#endif

#if EnTk17		
scantk17_set:
    bclr    _RChannelEnL,1		 
    bset    TK1CHSL,1  		
    goto    ScanNextChannel_end_1	
#endif

#if EnTk18		 
scantk18_set:
    bclr    _RChannelEnL,2		 
    bset    TK1CHSL,2  		
    goto    ScanNextChannel_end_1
#endif

#if EnTk19	
scantk19_set:
    bclr    _RChannelEnL,3	 
    bset    TK1CHSL,3  		
    goto    ScanNextChannel_end_1
#endif

#if EnTk20			 
scantk20_set:
    bclr    _RChannelEnL,4	 
    bset    TK1CHSL,4  		
    goto    ScanNextChannel_end_1
#endif

#if EnTk21		 
scantk21_set:
    bclr    _RChannelEnL,5	 
    bset    TK1CHSL,5  		
    goto    ScanNextChannel_end_1
#endif

#if EnTk30		 
scantk30_set:
    bclr    _RChannelEnH,6	 
    bset    TK1CHSH,6  		
    goto    ScanNextChannel_end_1
#endif

#if EnTk31		 
scantk31_set:
    bclr    _RChannelEnH,7	 
    bset    TK1CHSH,7  		
    goto    ScanNextChannel_end_1
#endif  
  
ScanNextChannel_end_1:
    incr    RTk_CH,r
	
ScanNextChannel_end:	
    CLRR    _R_CNT	

  __endasm;  
}

//================================================================================
void TkSignalHandle_Next(void)
{
  __asm  
; Stack:	Level 1
; INPUT:	 
; OUTPUT:	
; OTHER	:

 extern _RTkTemp9    
 extern _RTkTemp10 
#define RTkmaskL        _RTkTemp9
#define RTkmaskH        _RTkTemp10

 extern _RTkTemp2 
#define berror_F        _RTkTemp2,4 


;read finger data
    clrr    RTkmaskL 
    clrr    RTkmaskH

    movia   high(TAB_TOUCH_FN_DATA)
    movar   FSR1
    movia   low(TAB_TOUCH_FN_DATA)
    movar   FSR0	 

#if EnTk16	 
    jbts0   _RChannelEnL,0
    goto    READ_tk16_FN
#endif

#if EnTk17    
    jbts0   _RChannelEnL,1
    goto    READ_tk17_FN
#endif

#if EnTk18    
    jbts0   _RChannelEnL,2
    goto    READ_tk18_FN
#endif

#if EnTk19    
    jbts0   _RChannelEnL,3
    goto    READ_tk19_FN
#endif

#if EnTk20    
    jbts0   _RChannelEnL,4
    goto    READ_tk20_FN
#endif

#if EnTk21    
    jbts0   _RChannelEnL,5
    goto    READ_tk21_FN
#endif

#if EnTk30    
    jbts0   _RChannelEnH,6
    goto    READ_tk30_FN    
#endif

#if EnTk31    
    jbts0   _RChannelEnH,7
    goto    READ_tk31_FN    
#endif

    bset    berror_F
    goto    READ_tkx_FN_end_1   ;error,no tk ch en 

#if EnTk16 
READ_tk16_FN:
    bset     RTkmaskL,0
    bclr     _RChannelEnL,0	 	
    goto     READ_tkx_FN_end_1			
#endif

#if EnTk17	
READ_tk17_FN:
    bset     RTkmaskL,1
    bclr     _RChannelEnL,1	 		
    goto     READ_tkx_FN_end_1	
#endif

#if EnTk18	 
READ_tk18_FN:
    bset     RTkmaskL,2 
    bclr     _RChannelEnL,2		 
    goto     READ_tkx_FN_end_1
#endif

#if EnTk19
READ_tk19_FN:
    bset     RTkmaskL,3 
    bclr     _RChannelEnL,3	 	
    goto     READ_tkx_FN_end_1
#endif

#if EnTk20		 
READ_tk20_FN:
    bset     RTkmaskL,4 
    bclr     _RChannelEnL,4	 		
    goto     READ_tkx_FN_end_1
#endif

#if EnTk21	 
READ_tk21_FN:
    bset     RTkmaskL,5 
    bclr     _RChannelEnL,5	 	
    goto     READ_tkx_FN_end_1
#endif

#if EnTk30	 
READ_tk30_FN:
    bset     RTkmaskH,6 
    bclr     _RChannelEnH,6	 
    goto     READ_tkx_FN_end_1
#endif	

#if EnTk31	 
READ_tk31_FN:
    bset     RTkmaskH,7 
    bclr     _RChannelEnH,7	 
    goto     READ_tkx_FN_end_1
#endif
  
READ_tkx_FN_end_1:

  __endasm;  
}


//*********************************END OF FILE************************************
