/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
* File Name          : M8P632_Touch_M1_Lib_CFG.C
* Author             : MASSES CHIP
* Version            : V3.06
* Date               : 2025/12/02
********************************************************************************


********************************************************************************/

//================================================================================
#ifndef __M8P632_Touch_M1_Lib_CFG_H__
#define __M8P632_Touch_M1_Lib_CFG_H__

//================================================================================
// 触摸正常模式设定
//================================================================================
// 设置CDC模块1需要检测的通道  0: 该通道按键不检测；1: 该通道按键需检测。
#define    EnTk16   1
#define    EnTk17   0
#define    EnTk18   0 
#define    EnTk19   0 
#define    EnTk20   0
#define    EnTk21   0
#define    EnTk30   0
#define    EnTk31   0

// 设置确认允许响应的最多按键数量    (1 <= value <= TKLib_M0_OPENED_TK_AMOUNT)
#define TKLib_TOUCH_NUM               1  

// 设置手指触摸最长有效时间          (0<= value <=15) ; 0: 屏蔽此功能；1: 禁止配置；2~15：时间 = value*长按保护检测基准时基
#define TKLib_LONG_TOUCH_TIME         15

// 设置CDC时钟分频选择位              0->Fosc/4, 1->Fosc/8, 2->Fosc/16, 3->Fosc/32 ; 一般不需要修改
#define TKLib_TKCKS                   0

// 设置手指有效触摸检测次数,值越小灵敏度越高,值越大抗干扰越好  
//									 (1<= value<=14) 
#define TKLib_EFFECTIVE_TOUCH_TIME    5//9-TKLib_M1_OPENED_TK_AMOUNT/2

// 设置手指无效触摸检测次数,值越小灵敏度越高,值越大抗干扰越好  
//									 (1<= value<=14)
#define TKLib_INVALID_TOUCH_TIME      4//8-TKLib_M1_OPENED_TK_AMOUNT/2

// 基值上升更新速度,一般不需要修改	 (1<= value<=14)
#define TKLib_BaseLineUpSpeed         5

// 基值下降更新速度,一般不需要修改	 (1<= value<=14)
#define TKLib_BaseLineDownSpeed       5

// 设置当被响应按键超过允许响应的最多按键数量时，是否需要复位触摸      
// 									  0->不复位触摸系统, 1->复位触摸系统 ; 一般不需要修改
#define TKLib_Multi_TOUCH_RST         1

// 设置校准基准时基                  (1<= value <=254) ; 可根据时基需求调整
// 校准基准时基  = TKLib_CaliBaseTime * 调用时基，调用时基 Demo code 为0.5ms，可根据时基需求修改
#define TKLib_CaliBaseTime            200

// 设置长按保护检测基准时基          (1<= value <=254) ; 可根据时基需求调整
// 长按保护检测基准时基 = TKLib_LongKeyBaseTime * 校准基准时基，Democode为校准基准时基产生后计数，可根据时基需求修改
#define TKLib_LongKeyBaseTime         10

// 触摸数据采集次数,值越小灵敏度越高,不需要更改
//									 (3<= value< =254)	
#define TKLib_ScanCnt         		  8

// 上电按键有效延时时间,可根据实际需求修改,默认2S				 
//									 (0<= value<=255) value*100ms = 2S 
#define TKLib_PowerOn_Delay_Time      20  
//================================================================================
// 触摸阈值： 取值需具体应用环境决定，最小8，最大254，值越小越灵敏
#define     TKLib_TK16_F_THRESHOLD    20
#define     TKLib_TK17_F_THRESHOLD    20
#define     TKLib_TK18_F_THRESHOLD    20
#define     TKLib_TK19_F_THRESHOLD    20
#define     TKLib_TK20_F_THRESHOLD    20
#define     TKLib_TK21_F_THRESHOLD    20
#define     TKLib_TK30_F_THRESHOLD    20
#define     TKLib_TK31_F_THRESHOLD    20
//================================================================================
// 触摸省电模式设定，一般运用请关闭此模式
//================================================================================
// 设置触摸低功耗模式是否开启  		  0: 不使用触摸省电模式；1: 使用触摸省电模式。
#define TKLib_TouchLowerPower         0

// 设置触摸低功耗休眠时间			      (0<= value<=255)  value*1ms = 100MS
#define TKLib_LP_SLEEPTIME            100

//================================================================================
// 触摸省电模式下低频振荡器是否校准，一般运用无需配置
//================================================================================
//设置低功耗模式是否校准低频时钟：       0: 不校准低频时钟；1: 开启校准低频时钟。
#define TKLib_SleepWaKeUpTimeCheck     1

// 设置校准间隔时间:  		          (0 <= value <= 255) 值越大间隔时间越久
// 校准时间 = value*设置触摸低功耗模式唤醒时间 
#define TKLib_LP_CHECK_TIMER           60
//================================================================================
// 以下用户不可修改
//================================================================================
#define TKLib_M1_OPENED_TK_AMOUNT   (EnTk16+EnTk17+EnTk18+EnTk19+EnTk20+EnTk21+EnTk30+EnTk31)
#define TKLib_M1_TK_EN_MASK         ((EnTk16<<0)|(EnTk17<<1)|(EnTk18<<2)|(EnTk19<<3)|(EnTk20<<4)|(EnTk21<<5)|(EnTk30<<14)|(EnTk31<<15))             
   
//================================================================================

#endif

/*********************************END OF FILE************************************/
