/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
* File Name          : M8P634_Touch_M1_Lib_Data.C
* Author             : MASSES CHIP
* Version            : V3.04
* Date               : 2025/12/02
********************************************************************************
*本文件不建议用户修改

*******************************************************************************/

//================================================================================
#include "MassesChip_Define.h"
#include "M8P634_Touch_M1_Lib_CFG.H"

//================================================================================
#define TKLib_FILTER_LEVEL_NUM        6

//================================================================================
//触摸库RAM分配起始地址，不建议修改，或保证修改后有足够地址分配到触摸库使用

//================================================================================
__at(0xfb-17-TKLib_FILTER_LEVEL_NUM-8*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkTemp0;
__at(0xfb-16-TKLib_FILTER_LEVEL_NUM-8*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkTemp1;
__at(0xfb-15-TKLib_FILTER_LEVEL_NUM-8*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkTemp2;
__at(0xfb-14-TKLib_FILTER_LEVEL_NUM-8*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkTemp3;
__at(0xfb-13-TKLib_FILTER_LEVEL_NUM-8*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkTemp4;
__at(0xfb-12-TKLib_FILTER_LEVEL_NUM-8*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkTemp5;
__at(0xfb-11-TKLib_FILTER_LEVEL_NUM-8*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkTemp6;
__at(0xfb-10-TKLib_FILTER_LEVEL_NUM-8*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkTemp7;
__at(0xfb-9-TKLib_FILTER_LEVEL_NUM-8*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkTemp8;
__at(0xfb-8-TKLib_FILTER_LEVEL_NUM-8*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkTemp9;
__at(0xfb-7-TKLib_FILTER_LEVEL_NUM-8*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkTemp10;
__at(0xfb-6-TKLib_FILTER_LEVEL_NUM-8*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkTemp11;
__at(0xfb-5-TKLib_FILTER_LEVEL_NUM-8*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkTemp12;
__at(0xfb-4-TKLib_FILTER_LEVEL_NUM-8*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkTemp13;

//以上RAM不调用触摸相关函数模块时，将释放使用，用户可以在其他程序中当临时变量使用

//以下RAM为不可释放RAM
__at(0xfb-3-TKLib_FILTER_LEVEL_NUM-8*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkBuff2;
__at(0xfb-2-TKLib_FILTER_LEVEL_NUM-8*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkBuff4;
__at(0xfb-1-TKLib_FILTER_LEVEL_NUM-8*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkBuff5;

#if  TKLib_M1_OPENED_TK_AMOUNT
__at(0xfb-TKLib_FILTER_LEVEL_NUM-8*TKLib_M1_OPENED_TK_AMOUNT) unsigned int RTkGBuff0[TKLib_M1_OPENED_TK_AMOUNT];
__at(0xfb-TKLib_FILTER_LEVEL_NUM-6*TKLib_M1_OPENED_TK_AMOUNT) unsigned int RTkGBuff1[TKLib_M1_OPENED_TK_AMOUNT];
__at(0xfb-TKLib_FILTER_LEVEL_NUM-4*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkGBuff2[TKLib_M1_OPENED_TK_AMOUNT];
__at(0xfb-TKLib_FILTER_LEVEL_NUM-3*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkGBuff3[TKLib_M1_OPENED_TK_AMOUNT];
__at(0xfb-TKLib_FILTER_LEVEL_NUM-2*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkGBuff5[TKLib_M1_OPENED_TK_AMOUNT];
__at(0xfb-TKLib_FILTER_LEVEL_NUM-1*TKLib_M1_OPENED_TK_AMOUNT) unsigned char RTkGBuff6[TKLib_M1_OPENED_TK_AMOUNT];

__at(0xfb-TKLib_FILTER_LEVEL_NUM) unsigned char RTkGBuff4[6];  

#endif

__at(0xfb) unsigned char RChannelEnL;
__at(0xfc) unsigned char RChannelEnH;
__at(0xfd) unsigned char RKeyOnFlgL;
__at(0xfe) unsigned char RKeyOnFlgH;
__at(0xff) unsigned char RTkBitFlag;

//================================================================================
// 程序区,用户不可使用
//================================================================================
void Touch_Lib_Data(void)
{
  __asm//
#if (TKLib_TouchLowerPower==1)
TAB_TOUCH_TKLP_CFG_DATA:
 org    (0x0FEF+1-2-12-TKLib_M1_OPENED_TK_AMOUNT-2)

TAB_LPTOUCH_CONFIRM_TIME_DATA:
 RETIA		4
 
TAB_TOUCH_TKLP_LP_SLEEPTIME:
 RETIA     (TKLib_LP_SLEEPTIME&0xff)
#endif

TAB_TOUCH_CFG_DATA:
 org    (0x0FEF+1-2-12-TKLib_M1_OPENED_TK_AMOUNT) 

TAB_TOUCH_TK_EN_MASK_L_DATA:
 RETIA     (TKLib_M1_TK_EN_MASK&0X00FF)
 
TAB_TOUCH_TK_EN_MASK_H_DATA:
 RETIA     (TKLib_M1_TK_EN_MASK>>8)

TAB_TOUCH_OPENED_TK_AMOUNT_DATA: 
 RETIA     (TKLib_M1_OPENED_TK_AMOUNT&0x1F) 

TAB_TOUCH_TKCKS_DATA:
 RETIA      ((TKLib_TKCKS&0x03)<<4)
 
TAB_TOUCH_NUM_DATA:  
 RETIA     (((TKLib_TOUCH_NUM&0x0F)<<0)+((0)<<6)+((TKLib_Multi_TOUCH_RST&0x01)<<7))

TAB_TOUCH_LONG_TOUCH_TIME:  
  RETIA     (TKLib_LONG_TOUCH_TIME&0x0F)

TAB_TOUCH_CONFIRM_TIME_DATA: 
  RETIA     ((TKLib_EFFECTIVE_TOUCH_TIME&0x0F)+((TKLib_INVALID_TOUCH_TIME&0x0F)<<4))

TAB_TOUCH_SCAN_DATA:
  RETIA     (TKLib_ScanCnt-1)
  
TAB_TOUCH_POWER_ON_DELAY_TIME:
  RETIA     (TKLib_PowerOn_Delay_Time&0xff)
 
TAB_TOUCH_BASELINE_UP_SPEED:
  RETIA		(TKLib_BaseLineUpSpeed&0x0f)
 
TAB_TOUCH_BASELINE_DOWN_SPEED:
  RETIA		(TKLib_BaseLineDownSpeed&0x0f)

TAB_TOUCH_FN_DATA:
#if EnTk16  
 DW     ((TKLib_TK16_F_THRESHOLD&0xff)<<8)
#endif

#if EnTk17 
 DW     ((TKLib_TK17_F_THRESHOLD&0xff)<<8)
#endif

#if EnTk18  
 DW     ((TKLib_TK18_F_THRESHOLD&0xff)<<8)
#endif

#if EnTk19  
 DW     ((TKLib_TK19_F_THRESHOLD&0xff)<<8)
#endif

#if EnTk20  
 DW     ((TKLib_TK20_F_THRESHOLD&0xff)<<8)
#endif

#if EnTk21  
 DW     ((TKLib_TK21_F_THRESHOLD&0xff)<<8)
#endif

#if EnTk22  
 DW     ((TKLib_TK22_F_THRESHOLD&0xff)<<8)
#endif

#if EnTk23  
 DW     ((TKLib_TK23_F_THRESHOLD&0xff)<<8)
#endif

#if EnTk24  
 DW     ((TKLib_TK24_F_THRESHOLD&0xff)<<8)
#endif

#if EnTk25  
 DW     ((TKLib_TK25_F_THRESHOLD&0xff)<<8)
#endif

#if EnTk26  
 DW     ((TKLib_TK26_F_THRESHOLD&0xff)<<8)
#endif

#if EnTk27  
 DW     ((TKLib_TK27_F_THRESHOLD&0xff)<<8)
#endif

#if EnTk28  
 DW     ((TKLib_TK28_F_THRESHOLD&0xff)<<8)
#endif

#if EnTk29  
 DW     ((TKLib_TK29_F_THRESHOLD&0xff)<<8)
#endif

#if EnTk30  
 DW     ((TKLib_TK30_F_THRESHOLD&0xff)<<8)
#endif

#if EnTk31  
 DW     ((TKLib_TK31_F_THRESHOLD&0xff)<<8)
#endif

#if (TKLib_TouchLowerPower==1)
  GLOBAL TAB_LPTOUCH_CONFIRM_TIME_DATA
  GLOBAL TAB_TOUCH_TKLP_LP_SLEEPTIME  
#endif

  GLOBAL TAB_TOUCH_TK_EN_MASK_L_DATA 
  GLOBAL TAB_TOUCH_TK_EN_MASK_H_DATA 
  GLOBAL TAB_TOUCH_OPENED_TK_AMOUNT_DATA           
  GLOBAL TAB_TOUCH_TKCKS_DATA   
  GLOBAL TAB_TOUCH_NUM_DATA
  GLOBAL TAB_TOUCH_LONG_TOUCH_TIME
  GLOBAL TAB_TOUCH_CONFIRM_TIME_DATA 
  GLOBAL TAB_TOUCH_SCAN_DATA 
  GLOBAL TAB_TOUCH_POWER_ON_DELAY_TIME 
  GLOBAL TAB_TOUCH_BASELINE_UP_SPEED
  GLOBAL TAB_TOUCH_BASELINE_DOWN_SPEED
  GLOBAL TAB_TOUCH_FN_DATA 


//================================================================================
#if 1
//================================================================================
#if EnTk16
  MESSG "    TK16:Enable"
#endif
#if EnTk17
  MESSG "    TK17:Enable"
#endif
#if EnTk18
  MESSG "    TK18:Enable"
#endif
#if EnTk19
  MESSG "    TK19:Enable"
#endif
#if EnTk20
  MESSG "    TK20:Enable"
#endif
#if EnTk21
  MESSG "    TK21:Enable"
#endif
#if EnTk22
  MESSG "    TK22:Enable"
#endif
#if EnTk23
  MESSG "    TK23:Enable"
#endif
#if EnTk24
  MESSG "    TK24:Enable"
#endif
#if EnTk25
  MESSG "    TK25:Enable"
#endif
#if EnTk26
  MESSG "    TK26:Enable"
#endif
#if EnTk27
  MESSG "    TK27:Enable"
#endif
#if EnTk28
  MESSG "    TK28:Enable"
#endif
#if EnTk29
  MESSG "    TK29:Enable"
#endif
#if EnTk30
  MESSG "    TK30:Enable"
#endif
#if EnTk31
  MESSG "    TK31:Enable"
#endif

//================================================================================
#if (TKLib_M1_OPENED_TK_AMOUNT == 0)
  Error "    No channel is enabled,Please reconfigure EnTk16~EnTk31"
#endif

//================================================================================
//CDC Clock
#if (TKLib_TKCKS == 0)
  MESSG "    CDC1 Clock:Fosc/4"
#endif
#if (TKLib_TKCKS == 1)
  MESSG "    CDC1 Clock:Fosc/8"
#endif
#if (TKLib_TKCKS == 2)
  MESSG "    CDC1 Clock:Fosc/16"
#endif
#if (TKLib_TKCKS == 3)
  MESSG "    CDC1 Clock:Fosc/32"
#endif

//================================================================================
#if (TKLib_TOUCH_NUM == 0)
  Error "    Error:Please setting TKLib_TOUCH_NUM > 0"
#endif

//================================================================================
#if (TKLib_LONG_TOUCH_TIME == 0)
  MESSG "    屏蔽按键最长输出时间功能，即触摸不离开，按键标志一直会置位 "
#endif
#if (TKLib_LONG_TOUCH_TIME == 1)
  Error "    禁止配置 "
#endif

#if (TKLib_LONG_TOUCH_TIME > 15)
  Error "    Error:Please setting TKLib_LONG_TOUCH_TIME <= 15"
#endif

//================================================================================
#if (TKLib_Multi_TOUCH_RST > 1)
    Error "    Error:Please setting TKLib_Multi_TOUCH_RST ∈ {0,1}  "  
#endif

//================================================================================
#if (TKLib_CaliBaseTime < 1)
    Error "    Error: Please setting TKLib_CaliBaseTime >= 1" 
#endif
#if (TKLib_CaliBaseTime > 254)
    Error "    Error: Please setting TKLib_CaliBaseTime <= 254"  
#endif

#if (TKLib_LongKeyBaseTime < 1)
    Error "    Error: Please setting TKLib_LongKeyBaseTime >= 1" 
#endif
#if (TKLib_LongKeyBaseTime > 254)
    Error "    Error: Please setting TKLib_LongKeyBaseTime <= 254"  
#endif

//================================================================================
#if (TKLib_EFFECTIVE_TOUCH_TIME == 0)
  Error "    Error:Please setting TKLib_EFFECTIVE_TOUCH_TIME > 0"
#endif
#if (TKLib_EFFECTIVE_TOUCH_TIME > 14)
  Error "    Error:Please setting TKLib_EFFECTIVE_TOUCH_TIME <= 14"
#endif

//================================================================================
#if (TKLib_INVALID_TOUCH_TIME == 0)
  Error "    Error:Please setting TKLib_INVALID_TOUCH_TIME > 0"
#endif
#if (TKLib_INVALID_TOUCH_TIME > 14)
  Error "    Error:Please setting TKLib_INVALID_TOUCH_TIME <= 14"
#endif

//================================================================================
#if (TKLib_TK16_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK16_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK17_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK17_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK18_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK18_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK19_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK19_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK20_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK20_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK21_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK21_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK22_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK22_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK23_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK23_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK24_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK24_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK25_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK25_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK26_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK26_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK27_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK27_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK28_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK28_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK29_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK29_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK30_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK30_F_THRESHOLD <= 254"  
#endif
#if (TKLib_TK31_F_THRESHOLD > 254)
    Error "    Error: Please setting TKLib_TK31_F_THRESHOLD <= 254"  
#endif


//================================================================================
#if (TKLib_TK16_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK16_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK17_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK17_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK18_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK18_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK19_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK19_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK20_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK20_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK21_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK21_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK22_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK22_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK23_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK23_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK24_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK24_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK25_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK25_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK26_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK26_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK27_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK27_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK28_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK28_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK29_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK29_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK30_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK30_F_THRESHOLD >= 8"
#endif
#if (TKLib_TK31_F_THRESHOLD <8)
    Error "    Error: Please setting TKLib_TK31_F_THRESHOLD >= 8"
#endif

//================================================================================
#if TKLib_TouchLowerPower
  MESSG "    触摸低功耗模式：已开启 "
#else
  MESSG "    触摸低功耗模式：未开启 "
#endif
#if (TKLib_TouchLowerPower>1)
  MESSG "    触摸低功耗模式：配置错误，TKLib_TouchLowerPower ∈ {0,1} "
#endif
//================================================================================
#if (TKLib_ScanCnt < 3 )
    Error "    Error: Please setting TKLib_ScanCnt >= 3"  
#endif
#if (TKLib_ScanCnt > 254)
    Error "    Error: Please setting TKLib_ScanCnt < 255"  
#endif
//================================================================================
#if (TKLib_PowerOn_Delay_Time < 0 )
    Error "    Error: Please setting TKLib_PowerOn_Delay_Time >= 0"  
#endif
#if (TKLib_PowerOn_Delay_Time > 254)
    Error "    Error: Please setting TKLib_PowerOn_Delay_Time < 255"  
#endif
//================================================================================
#if (TKLib_BaseLineUpSpeed < 1 )
    Error "    Error: Please setting TKLib_BaseLineUpSpeed >= 1"  
#endif
#if (TKLib_BaseLineUpSpeed > 14)
    Error "    Error: Please setting TKLib_BaseLineUpSpeed < 15"  
#endif
//================================================================================
#if (TKLib_BaseLineDownSpeed < 1 )
    Error "    Error: Please setting TKLib_BaseLineDownSpeed >= 1"  
#endif
#if (TKLib_BaseLineDownSpeed > 14)
    Error "    Error: Please setting TKLib_BaseLineDownSpeed < 15"  
#endif
//================================================================================
#endif

  __endasm;

}

//*********************************END OF FILE************************************
