/*******************(C) COPYRIGHT 2023 Masses-Chip ******************************
* File Name          : MAIN.C
* Author             : MASSES CHIP
* Version            : V3.01
* Date               : 2023/06/20
********************************************************************************

 16M/4T, WDT EN 72MS, RST IS IO ,BOR 2.4V,RST TIMER 18MS

*******************************************************************************/





//===============================================================================
#include "M8P634.h"
#include "MassesChip_Define.h"
#include "M8P634_Touch_M1_Lib.h"
#include "M8P634_Touch_M1_Lib_CFG.H"
#include "M8P634_Touch_M1_UartDebug_LIB_Init.h"

//===============================================================================

//====================================================================
// T0 BASE TIME  SET
#define	T0_125_US                    125
#define T0_LOAD_C_Init	            (T0_125_US*16000000/1000000)  //FOSC 1:1
#define T0H_LOAD_C_Init             (T0_LOAD_C_Init/256)
#define T0L_LOAD_C_Init             (T0_LOAD_C_Init%256)

#define T_500US_C_Init_DF            4
#define T_10MS_C_Init_DF             20
#define T_GOTOLOWPOWERMODE_C_Init_DF 250

ob8 R_Time_Flag;
#define	bT_125UF_F    R_Time_Flag.b0
#define	bT_500US_F    R_Time_Flag.b1
#define	bT_10MS_F     R_Time_Flag.b2

unsigned char R_500US_COUNT  = T_500US_C_Init_DF;
unsigned char R_10MS_COUNT  = T_10MS_C_Init_DF;
unsigned char R_GOTOLOWPOWERMODE_COUNT  = T_GOTOLOWPOWERMODE_C_Init_DF;  //无触摸下超时休眠检测次数，无触摸下超时休眠时间 ≈ 次数*10ms

// 关键寄存器备份寄存器，若中断中确保没用到，可删除对应代码，这样可节约寄存器
unsigned char FSR0_BKR;
unsigned char FSR1_BKR;
unsigned char HBUF_BKR;

//===============================================================================
void InitalRAM(void);
void IO_Init(void);
void T0_Init(void);

//===============================================================================
void main(void)
{
  IO_Init();
  InitalRAM();
  T0_Init();

#if TKUartDebugLib_DEBUG_MODE_SWITCH
  TK_TouchUartDebug_Init();
#endif

  ADCON1|=0x01;    //CDC VREF 调用TkInit();前必须先打开ADC模块内部任一参考电源
  TkInit();

  GIE =1;
  while(1)
  {
      __CLRWDT();
      TkScan(); //主循环一直扫描，故主循环间隔不宜过长以免影响响应时间

    /*查询一轮是否转换结束*/
    if(bOneScanDone)
    {    
#if TKUartDebugLib_DEBUG_MODE_SWITCH
#if(TKUartDebugLib_DEBUG_UART_SELECT==0)
      TC0IE=0;
#endif
      TK_TouchUartDebug(); //串口调试

#if(TKUartDebugLib_DEBUG_UART_SELECT==0)
      TC0IE=1;
#endif
#endif      
      
      TkSignalHandle(); //一轮转换完成,数据处理
      bOneScanDone = 0; //一轮转换完成,清除标志

      if((RKeyOnFlgL==0)&&(RKeyOnFlgH==0))
      {
        if(--R_GOTOLOWPOWERMODE_COUNT==0)
        {
          //全部按键松开
          R_GOTOLOWPOWERMODE_COUNT = T_GOTOLOWPOWERMODE_C_Init_DF;
          bLowPowerModeRun = 1; //按键松开超过设定时间，置 bLowPowerModeRun 即允许睡眠
        }
      }
      else
      {
#if TKLib_TouchLowerPower
        R_GOTOLOWPOWERMODE_COUNT = T_GOTOLOWPOWERMODE_C_Init_DF;
#endif
//用户按键处理，如下：

        if(F_TK16_On)
        {
          //注：添加__NOP();只是为了防止编译器报错，具体功能请根据需求增加
          __NOP();
        }
        else if(F_TK17_On)
        {
          __NOP();
        }
        else if(F_TK18_On)
        {
          __NOP();
        }
        else if(F_TK19_On)
        {
          __NOP();
        }
        else
        {
          __NOP();
        }
      }

#if TKLib_TouchLowerPower
      if(bLowPowerModeRun&&bBaseLineUpdateOK&&bPowerOnDelayTimeOK)
      {
//下面加睡眠前其它需要低功耗处理的操作(除触摸外的，触摸相关的TkLowPowerMode()会自行处理)


        TC0IE=0; //关闭其他唤醒源，本demo code外部只打开了T0，故只关闭T0
//触摸低功耗模式
        TkLowPowerMode();
//下面加唤醒后其它需要恢复的操作
        T0_Init();


      }
#endif
      ScanContinue();  //必须在TkLowPowerMode() 后面调用，且保证清除bOneScanDone后，一定能调用此程序
    }

    /* User code */


  }
}

//===============================================================================
void int_isr(void) __interrupt
{
  __asm;
  push

  __endasm;
//----------------------------------------
// 备份关键寄存器，若中断中确保没用到，可删除对应代码，这样可节约寄存器
 FSR0_BKR = FSR0;
 FSR1_BKR = FSR1;
 HBUF_BKR = HBUF;
//----------------------------------------

  if(TC0IE)
  {
    if(TC0IF)
    {
      TC0IF = 0;
      if(--R_500US_COUNT==0)
      {
        R_500US_COUNT = T_500US_C_Init_DF;
        bT_500US_F = 1;

        //触摸更新时基，必须保证标志正常
        if(++RTK_CaliBaseTime_Cnt >= TKLib_CaliBaseTime)
        {
          RTK_CaliBaseTime_Cnt = 0;
          bT_TK_CBT_F = 1;
		  
          if(++RTK_LongKeyBaseTime_Cnt >= TKLib_LongKeyBaseTime)
          {
            RTK_LongKeyBaseTime_Cnt = 0;
            bT_TK_LBT_F = 1;
          }
        }

        if(--R_10MS_COUNT==0)
        {
          R_10MS_COUNT = T_10MS_C_Init_DF;
          bT_10MS_F = 1;
        }
      }
    }
  }

#if (TKUartDebugLib_DEBUG_MODE_SWITCH&&(TKUartDebugLib_DEBUG_UART_SELECT==0))
  if(TC1IE)
  {
    //Software uart
    if(TC1IF)
    {
      TC1IF = 0;
      __asm
      ISR_UART_TX_ACT:
      MOVR    R_UART_TX_CNT,A
      JBTS1   STATUS,2
      GOTO    ISR_UART_TX_BODY
      IST_UART_TX_START:
      BCLR    P_UART_TX,N_UART_TX
      GOTO    ISR_UART_TX_START_EXIT

      ISR_UART_TX_BODY:
      JCMPAI  9
      GOTO    ISR_UART_TX_DATA
      IST_UART_TX_END:
      BSET    P_UART_TX,N_UART_TX
      BCLR    bTC1IE
      GOTO    ISR_UART_TX_EXIT

      ISR_UART_TX_DATA:
      JBTS0   R_UART_TX_BUF,0
      BSET    P_UART_TX,N_UART_TX
      JBTS1   R_UART_TX_BUF,0
      BCLR    P_UART_TX,N_UART_TX

      ISR_UART_TX_DATA_EXIT:
      RRR     R_UART_TX_BUF,R
      ISR_UART_TX_START_EXIT:
      INCR    R_UART_TX_CNT,R
      GOTO    ISR_UART_TX_EXIT

      ISR_UART_TX_EXIT:
      BCLR    bTC1IF

      __endasm;
    }
  }
#endif

//----------------------------------------
// 备份关键寄存器，若中断中确保没用到，可删除对应代码，这样可节约寄存器
 FSR0 = FSR0_BKR;
 FSR1 = FSR1_BKR;
 HBUF = HBUF_BKR;
//----------------------------------------
  __asm
  pop

  __endasm;
}

//================================================================================
void IO_Init(void)
{
  //IO_init
  //触摸口建议设置成输出模式。如输出全0或全1  
  OEA = Bin(11111111);  //1:output  0:input
  IOA = 0;
  OEB = Bin(11111111);  //1:output  0:input
  IOB = 0;
  OEC = Bin(11101111);  //1:output  0:input
  IOC = 0;
  OED = Bin(11111111);  //1:output  0:input
  IOD = 0;
}

//================================================================================
void T0_Init(void)
{
  TC0CH = 0;
  TC0CL = 0;
  TC0PRH = T0H_LOAD_C_Init;
  TC0PRL = T0L_LOAD_C_Init;

  T0CR = Bin(10001000);
  TC0IE = 1;
}

//================================================================================
void InitalRAM()
{
  __asm
  clrr    FSR0          //0x00
  _ClrRam_loop:
  clrr    INDF0
  incr    FSR0,r
  movr    FSR0,a
  jcmpai  low(0xff+1)   //0x7f+1
  goto    _ClrRam_loop
  __endasm;
}


/*********************************END OF FILE************************************/

