/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
* File Name          : Touch_Lib.h
* Author             : MASSES CHIP
* Version            : V2.08
* Date               : 2025/12/09
*********************************************************************************



********************************************************************************/
#ifndef __M9F680_Touch_Lib_H__
#define __M9F680_Touch_Lib_H__

#include "MASSESCHIP_DEFINE.H"

//===================================================================================================
extern void CAL_LIRC(void);							//低功耗下校准低频时钟
extern void Touch_Init(void);           			//触摸模块初始化
extern void BaseLineReset(void);        			//复位所有通道基线
extern void TkLowPowerMode(void);					//触摸低功耗调用函数
extern void Touch_Key_Process(void);    			//建议扫描完成一轮后，调用一次
extern void	TouchFailDealMode(void);
//===================================================================================================
extern volatile bit OneCycleScanDone;   			//扫描一轮置位一次，一轮时间 ≈ 单个通道扫描时间 * 开启的检测通道个数
extern volatile bit bLowPowerModeRun;   			//触摸模块低功耗程序，调用此函数前必须将相关端口设置
extern volatile bit ChannelCalOvertimeFlag;       	//触摸转换超时标志
extern volatile bit ChannelCalOvertimeStartFlag;  	//触摸转换开始计时标志
// 用户只读，不可写入操作，切记！ 
extern u8	Caltimercount;							//低功耗模式下累计时间达到低频校准的间隔时间则校准低频
extern uc8 CFG_TK_TIMEOUT_CNT;          			//低功耗模式下低频校准的间隔时间
extern uc8   CFG_LP_CHECK_TIMER;					//低功耗模式下低频校准的间隔时间
extern volatile	u8	PoweOn_Cnt;						//上电延时累计Cnt
extern volatile u8  TouchKeyFailCnt;				//触摸卡死时间累计
extern volatile u32 TouchKeyFlag;       			//按键响应标志，每1BIT 对应一个通道
#define F_TK0_On    (TouchKeyFlag&(0x01ul<<0))  //TK0按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK1_On    (TouchKeyFlag&(0x01ul<<1))  //TK1按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK2_On    (TouchKeyFlag&(0x01ul<<2))  //TK2按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK3_On    (TouchKeyFlag&(0x01ul<<3))  //TK3按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK4_On    (TouchKeyFlag&(0x01ul<<4))  //TK4按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK5_On    (TouchKeyFlag&(0x01ul<<5))  //TK5按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK6_On    (TouchKeyFlag&(0x01ul<<6))  //TK6按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK7_On    (TouchKeyFlag&(0x01ul<<7))  //TK7按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK8_On    (TouchKeyFlag&(0x01ul<<8))  //TK8按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK9_On    (TouchKeyFlag&(0x01ul<<9))  //TK9按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK10_On   (TouchKeyFlag&(0x01ul<<10)) //TK10按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK11_On   (TouchKeyFlag&(0x01ul<<11)) //TK11按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK12_On   (TouchKeyFlag&(0x01ul<<12)) //TK12按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK13_On   (TouchKeyFlag&(0x01ul<<13)) //TK13按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK14_On   (TouchKeyFlag&(0x01ul<<14)) //TK14按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK15_On   (TouchKeyFlag&(0x01ul<<15)) //TK15按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK16_On   (TouchKeyFlag&(0x01ul<<16)) //TK16按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK17_On   (TouchKeyFlag&(0x01ul<<17)) //TK17按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK18_On   (TouchKeyFlag&(0x01ul<<18)) //TK18按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK19_On   (TouchKeyFlag&(0x01ul<<19)) //TK19按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK20_On   (TouchKeyFlag&(0x01ul<<20)) //TK20按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK21_On   (TouchKeyFlag&(0x01ul<<21)) //TK21按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK22_On   (TouchKeyFlag&(0x01ul<<22)) //TK22按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK23_On   (TouchKeyFlag&(0x01ul<<23)) //TK23按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK24_On   (TouchKeyFlag&(0x01ul<<24)) //TK24按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK25_On   (TouchKeyFlag&(0x01ul<<25)) //TK25按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK26_On   (TouchKeyFlag&(0x01ul<<26)) //TK26按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK27_On   (TouchKeyFlag&(0x01ul<<27)) //TK27按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK28_On   (TouchKeyFlag&(0x01ul<<28)) //TK28按键触摸响应标志，1：表示被触摸；0：未被触摸。
#define F_TK29_On   (TouchKeyFlag&(0x01ul<<29)) //TK29按键触摸响应标志，1：表示被触摸；0：未被触摸。

#endif /*__Touch_Lib_H__*/
