/*******************(C) COPYRIGHT 2023 Masses-Chip ******************************
* File Name          : M9F_AFIO_MP.h
* Author             : MASSES CHIP
* Version            : V2.02
* Date               : 2023/05/17
*********************************************************************************



********************************************************************************/

//================================================================================
#ifndef __M9F_AFIO_MP_H__
#define __M9F_AFIO_MP_H__

//================================================================================
#define PAMP       0x00
#define PBMP       0x10
#define PCMP       0x20
#define PDMP       0x30

#define PINNUM0    0x00
#define PINNUM1    0x01
#define PINNUM2    0x02
#define PINNUM3    0x03
#define PINNUM4    0x04
#define PINNUM5    0x05
#define PINNUM6    0x06
#define PINNUM7    0x07

//  port_num = A/B/C/...
//  pin_num = 0~7
#define MP(port_num,pin_num)                    ((P##port_num##MP) | (PINNUM##pin_num))

//digital_fun 对应可数字映射功能的名称  exp. 串口 发送端TX  则digital_fun = TX
//设置可数字映射功能到对应端口上
#define DF_MAP(digital_fun,port_num, pin_num)   (MP##digital_fun = ((P##port_num##MP) | (PINNUM##pin_num)))

#endif/* __M9F_AFIO_MP_H__ */
