/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
* File Name          : main.c
* Author             : MASSES CHIP
* Version            : V2.08
* Date               : 2025/12/09
*********************************************************************************



********************************************************************************/

#include "zc.h"
#include "MASSESCHIP_DEFINE.H"
#include "M9F_IO_INIT.h"
#include "M9F_AFIO_MP.h"

//================================================================================
//Touch_Lib
#include "M9F680_Touch_Lib.h"
#include "M9F680_Touch_Lib_CFG.h"
#include "M9F680_Touch_UartDebug_Lib.h"
#include "M9F680_Touch_UartDebug_Lib_CFG.h"

//================================================================================
// T0 BASE TIME  SET
#define	T0_125_US         125     //uS
#define T0_LOAD_C_Init    (T0_125_US*16000000/16/1000000)  //FOSC 1:16

u8  T_1MS_COUNT = 0;
u8  T_10MS_COUNT = 0;
ab8 Timer_Flag0;
#define bT_1MS_F             Timer_Flag0.oneBit.b0
#define bT_10MS_F            Timer_Flag0.oneBit.b1

#define T_1MS_DF        8       //8*125us
#define T_10MS_DF       10      //20*10ms


bit bKEY_TIG_INIT_EN_F;
u8  Key_Press_Flag = 0;

u8 R_GOTOLOWPOWERMODE_COUNT = 0;
//无按键进入休眠的时间
#define T_GOTOLOWPOWERMODE_C_Init_DF     50  // 无触摸下超时休眠检测次数，无触摸下超时休眠时间 = 次数*触摸通道检测数*0.5ms



//===============================================================================
//                    0: Touch Demo Code 不需要蜂鸣器或用户自行删除相关部分;
//                    1: Touch Demo Code 需要蜂鸣器。
#define	BUZZER_SW     0

#if BUZZER_SW
//BUZZER  basetimer 10ms
#define BZ_POWER_ON()   BUZZER_ON(1,20,0)  //上电长响一声20*10ms
#define BZ_KEY_TIG1()   BUZZER_ON(1,10,0)  //按键触发短响一声10*10ms 

#define BZ_PIN_OR       IOAOR      //IOAOR/IOBOR/IOCOR/...
#define BZ_PIN_NUM      BIT7       //蜂鸣器是软件pwm 在IOB3 口上 


#define BZ_TURN()       BZ_PIN_OR ^= BZ_PIN_NUM
bit bBZ_ON_F;
bit bBZ_MODE_F;
u8  T_BZT_COUNT = 0;
u8  T_BZC_TEMP = 0;
u8  T_BZE_TEMP = 0;
u8  T_BZD_TEMP = 0;

void BZ_Driver(void);
void BUZZER_ON(u8 num, u8 t_on, u8 t_off);
#endif

//===============================================================================
void SysInit(void);
void KEY_TASK(void);

//================================================================================
void main()
{
  SysInit();

#if BUZZER_SW
  BZ_POWER_ON();
#endif

  //触摸占用了低优先级中断
  Touch_Init();

  GIEH=1;

#if TouchUartDebugLib_SW
  Touch_UartDebug_Init();
#endif

  while(1)
  {
    CLRWDT();
	
	TouchFailDealMode();

    if(OneCycleScanDone)
    {
      //一轮转换完成
      OneCycleScanDone = 0;

#if TouchUartDebugLib_SW
      Touch_UartDebug();
#endif
      if(!TouchKeyFlag)
      {
        if(++R_GOTOLOWPOWERMODE_COUNT>T_GOTOLOWPOWERMODE_C_Init_DF)
        {
          R_GOTOLOWPOWERMODE_COUNT = 0;
  
          bLowPowerModeRun = 1;
#if TKLib_TouchLowerPower   
          /*下面加睡眠前其它需要低功耗处理的操作(除触摸外的，触摸相关的_TkLowPowerMode会自行处理)
            如低功耗模式下端口处理，外设模块等
            WDT 与 CPU 工作模式 用户不需要处理*/
          
          //关闭其他唤醒源，本demo code外部只打开了T0，固只关闭T0
          TC0IE = 0;
          //触摸低功耗模式

          if(bLowPowerModeRun)
          {
            TkLowPowerMode();
          }
          //下面加唤醒后其它需要恢复的操作
		  //注：休眠程序中使用了TC0和TC2,恢复之后如需使用,请重新配置

          TC0CH = 0;
          TC0CL = T0_LOAD_C_Init;
          T0CR = Bin(10101100);   //16M/1:16
          TC0IE = 1;
#endif
        }
      }
      else
      {
        R_GOTOLOWPOWERMODE_COUNT = 0;
      }
      Touch_Key_Process();

      KEY_TASK();  //按键标志用户处理
    }

    /* User code */

  }
}

//================================================================================
//中断
void interrupt  ISR_Process(void)
{
#asm   //禁止添加内容或删除及移动位置
  call _coverage_stack,f
#endasm

  if(TC0IF)  //本例程默认一直打开TC0IE，故没判断TC0IE标志 Demo Code 125us一次，中断时间非必要不要修改，若必须修改请询问厂家
  {
    TC0IF = 0;
//*******************************************************************************	
//该部分程序触摸库有用到，不可删除或修改
	if(++T_1MS_COUNT  >= T_1MS_DF)
    {
		T_1MS_COUNT = 0;
		bT_1MS_F = 1;
    }
	if(bT_1MS_F)
	{
		bT_1MS_F = 0;
		if(++T_10MS_COUNT  >= T_10MS_DF)
		{
			T_10MS_COUNT = 0;
			bT_10MS_F = 1;
			PoweOn_Cnt++;
		}
	}
	if(ChannelCalOvertimeStartFlag)
	{
		if(++TouchKeyFailCnt > CFG_TK_TIMEOUT_CNT)
		{
			ChannelCalOvertimeFlag = 1;
			ChannelCalOvertimeStartFlag = 0;
			TouchKeyFailCnt = 0;
		}
	}
//*******************************************************************************	
#if BUZZER_SW
    if(bBZ_ON_F)
    {
		BZ_TURN();
    }
#endif
    
	if(bT_10MS_F)
	{
		bT_10MS_F = 0;

#if BUZZER_SW
		BZ_Driver();
#endif

	}
  }
}

//================================================================================
void SysInit(void)
{
//开启的触摸口设置成输出0
  SET_aPORT_OUT(A,0,0);
//  SET_aPORT_OUT(A,1,0);
//  SET_aPORT_OUT(A,2,0);
//  SET_aPORT_OUT(A,3,0);


//BZ
#if BUZZER_SW
  SET_aPORT_OUT(A,7,0);  //蜂鸣器是软件pwm 在IOA7口上
#endif

//端口数字功能映射
//exp. UART TXD 口映射在IOD5上
//  MPTX = MP(D,5);


//T0
  TC0CH = 0;
  TC0CL = T0_LOAD_C_Init;

  T0CR = Bin(10101100);   //16M/1:16
  TC0IE = 1;

}

//================================================================================
void KEY_TASK(void)
{
//TK0
  if(F_TK0_On)
  {
    //按下
    if((Key_Press_Flag&0x01)==0)
    {
      Key_Press_Flag|=0x01;
      bKEY_TIG_INIT_EN_F = 1;
    }
  }
  else
  {
    //释放
    Key_Press_Flag &= ~0x01;
  }

  /*
  //TK1
    if(F_TK1_On)
    {//按下
      if((Key_Press_Flag&0x02)==0)
      {
        Key_Press_Flag|=0x02;
        bKEY_TIG_INIT_EN_F = 1;
      }
    }
    else
    {//释放
      Key_Press_Flag &= ~0x01;
    }

  //TK2
    if(F_TK2_On)
    {//按下
      if((Key_Press_Flag&0x04)==0)
      {
        Key_Press_Flag|=0x04;
        bKEY_TIG_INIT_EN_F = 1;
      }
    }
    else
    {//释放
      Key_Press_Flag &= ~0x04;
    }

  //TK3
    if(F_TK3_On)
    {//按下
      if((Key_Press_Flag&0x08)==0)
      {
        Key_Press_Flag|=0x08;
        bKEY_TIG_INIT_EN_F = 1;
      }
    }
    else
    {//释放
      Key_Press_Flag &= ~0x08;
    }
  */


  if(bKEY_TIG_INIT_EN_F)
  {
    bKEY_TIG_INIT_EN_F = 0;

#if BUZZER_SW
    BZ_KEY_TIG1();  //蜂鸣器响一声
#endif
  }
  
}


//===============================================================================
#if BUZZER_SW
void BUZZER_ON(u8 num, u8 t_on, u8 t_off)
{
  T_BZT_COUNT = 0;
  T_BZE_TEMP = t_on;
  T_BZD_TEMP = t_off;
  T_BZC_TEMP = num;

  if(T_BZC_TEMP)
  {
    bBZ_ON_F = 1 ;//PWM_On()	;
  }
  else
  {
    bBZ_ON_F = 0;//PWM_Off();
  }

  bBZ_MODE_F = 1;
}
#endif

//===============================================================================
#if BUZZER_SW
void BZ_Driver(void)
{
  if(T_BZC_TEMP != 0)
  {
    if(bBZ_MODE_F)
    {
      //ON
      T_BZT_COUNT++;
      if(T_BZT_COUNT >= T_BZE_TEMP)
      {
        T_BZT_COUNT = 0;
        T_BZC_TEMP--;
        bBZ_MODE_F = 0;
        bBZ_ON_F = 0;//PWM_Off();
      }
    }
    else
    {
      //OFF
      T_BZT_COUNT++;
      if(T_BZT_COUNT  >= T_BZD_TEMP)
      {
        T_BZT_COUNT = 0;

        if(T_BZC_TEMP > 0)
        {
          bBZ_MODE_F = 1;
          bBZ_ON_F = 1 ;//PWM_On()	;
        }
      }
    }
  }
}
#endif



//================================================================================
//为空函数，禁止添加内容或删除
void coverage_stack(void)
{

}
//================================================================================
// 此程序是在触摸低功耗模式下，需要处理的操作，如有需要可增加操作程序
// 如RTC时钟1S计时程序,LCD时钟刷新显示程序等等
#if TKLib_TouchLowerPower 
void WDT_WakeUp_Handle(void)
{
#if TKLib_SleepWaKeUpTimeCheck 
  if(Caltimercount++ > CFG_LP_CHECK_TIMER)
  {
	Caltimercount = 0;
	CAL_LIRC();
  }
#endif   
  // bLowPowerModeRun = 0; //可根据需求，判断系统是否需要强制唤醒(清bLowPowerModeRun，强制唤醒系统)
}
#endif
/*********************************END OF FILE************************************/
