/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
* File Name          : M9P6362_Touch_Lib_CFG.c
* Author             : MASSES CHIP
* Version            : V1.04
* Date               : 2025/12/15
*********************************************************************************

********************************************************************************/
//===================================================================================================
#include "MASSESCHIP_DEFINE.H"
#include "M9P6362_Touch_Lib_CFG.h"
#include "M9P6362_Touch_UartDebug_Lib_CFG.h"
//===================================================================================================
#define TKLib_OPENED_TK_AMOUNT \
(EnTk0+EnTk1+EnTk2+EnTk3+EnTk4+EnTk5+EnTk6+EnTk7+EnTk8+EnTk9+EnTk10+EnTk11+EnTk12+EnTk13+EnTk14+EnTk15+\
EnTk16+EnTk17+EnTk18+EnTk19+EnTk20+EnTk21+EnTk22+EnTk23+EnTk24+EnTk25+EnTk26+EnTk27)

#define TKLib_TK_EN_MASK  \
(((u32)EnTk0<<0)|((u32)EnTk1<<1)|((u32)EnTk2<<2)|((u32)EnTk3<<3)\
|((u32)EnTk4<<4)|((u32)EnTk5<<5)|((u32)EnTk6<<6)|((u32)EnTk7<<7)\
|((u32)EnTk8<<8)|((u32)EnTk9<<9)|((u32)EnTk10<<10)|((u32)EnTk11<<11)\
|((u32)EnTk12<<12)|((u32)EnTk13<<13)|((u32)EnTk14<<14)|((u32)EnTk15<<15)\
|((u32)EnTk16<<16)|((u32)EnTk17<<17)|((u32)EnTk18<<18)|((u32)EnTk19<<19)\
|((u32)EnTk20<<20)|((u32)EnTk21<<21)|((u32)EnTk22<<22)|((u32)EnTk23<<23)\
|((u32)EnTk24<<24)|((u32)EnTk25<<25)|((u32)EnTk26<<26)|((u32)EnTk27<<27)\
)
//===================================================================================================
#if EnTk0
#define _DF_TKLib_TK0_F_THRESHOLD    TKLib_TK0_F_THRESHOLD,
#define _DF_TKLib_TK0_EN_MASK        0,
#else
#define _DF_TKLib_TK0_F_THRESHOLD  
#define _DF_TKLib_TK0_EN_MASK
#endif

#if EnTk1
#define _DF_TKLib_TK1_F_THRESHOLD    TKLib_TK1_F_THRESHOLD,
#define _DF_TKLib_TK1_EN_MASK        1,
#else
#define _DF_TKLib_TK1_F_THRESHOLD 
#define _DF_TKLib_TK1_EN_MASK
#endif

#if EnTk2
#define _DF_TKLib_TK2_F_THRESHOLD    TKLib_TK2_F_THRESHOLD,
#define _DF_TKLib_TK2_EN_MASK        2,
#else
#define _DF_TKLib_TK2_F_THRESHOLD  
#define _DF_TKLib_TK2_EN_MASK
#endif

#if EnTk3
#define _DF_TKLib_TK3_F_THRESHOLD    TKLib_TK3_F_THRESHOLD,
#define _DF_TKLib_TK3_EN_MASK        3,
#else
#define _DF_TKLib_TK3_F_THRESHOLD
#define _DF_TKLib_TK3_EN_MASK
#endif

#if EnTk4
#define _DF_TKLib_TK4_F_THRESHOLD    TKLib_TK4_F_THRESHOLD,
#define _DF_TKLib_TK4_EN_MASK        4,
#else
#define _DF_TKLib_TK4_F_THRESHOLD
#define _DF_TKLib_TK4_EN_MASK
#endif

#if EnTk5
#define _DF_TKLib_TK5_F_THRESHOLD    TKLib_TK5_F_THRESHOLD,
#define _DF_TKLib_TK5_EN_MASK        5,
#else
#define _DF_TKLib_TK5_F_THRESHOLD
#define _DF_TKLib_TK5_EN_MASK
#endif

#if EnTk6
#define _DF_TKLib_TK6_F_THRESHOLD    TKLib_TK6_F_THRESHOLD,
#define _DF_TKLib_TK6_EN_MASK        6,
#else
#define _DF_TKLib_TK6_F_THRESHOLD
#define _DF_TKLib_TK6_EN_MASK
#endif

#if EnTk7
#define _DF_TKLib_TK7_F_THRESHOLD    TKLib_TK7_F_THRESHOLD,
#define _DF_TKLib_TK7_EN_MASK        7,
#else
#define _DF_TKLib_TK7_F_THRESHOLD
#define _DF_TKLib_TK7_EN_MASK
#endif

#if EnTk8
#define _DF_TKLib_TK8_F_THRESHOLD    TKLib_TK8_F_THRESHOLD,
#define _DF_TKLib_TK8_EN_MASK        8,
#else
#define _DF_TKLib_TK8_F_THRESHOLD
#define _DF_TKLib_TK8_EN_MASK
#endif

#if EnTk9
#define _DF_TKLib_TK9_F_THRESHOLD    TKLib_TK9_F_THRESHOLD,
#define _DF_TKLib_TK9_EN_MASK        9,
#else
#define _DF_TKLib_TK9_F_THRESHOLD
#define _DF_TKLib_TK9_EN_MASK
#endif

#if EnTk10
#define _DF_TKLib_TK10_F_THRESHOLD   TKLib_TK10_F_THRESHOLD,
#define _DF_TKLib_TK10_EN_MASK        10,
#else
#define _DF_TKLib_TK10_F_THRESHOLD
#define _DF_TKLib_TK10_EN_MASK
#endif

#if EnTk11
#define _DF_TKLib_TK11_F_THRESHOLD   TKLib_TK11_F_THRESHOLD,
#define _DF_TKLib_TK11_EN_MASK       11,
#else
#define _DF_TKLib_TK11_F_THRESHOLD
#define _DF_TKLib_TK11_EN_MASK
#endif

#if EnTk12
#define _DF_TKLib_TK12_F_THRESHOLD   TKLib_TK12_F_THRESHOLD,
#define _DF_TKLib_TK12_EN_MASK       12,
#else
#define _DF_TKLib_TK12_F_THRESHOLD
#define _DF_TKLib_TK12_EN_MASK
#endif

#if EnTk13
#define _DF_TKLib_TK13_F_THRESHOLD   TKLib_TK13_F_THRESHOLD,
#define _DF_TKLib_TK13_EN_MASK       13,
#else
#define _DF_TKLib_TK13_F_THRESHOLD
#define _DF_TKLib_TK13_EN_MASK
#endif

#if EnTk14
#define _DF_TKLib_TK14_F_THRESHOLD   TKLib_TK14_F_THRESHOLD,
#define _DF_TKLib_TK14_EN_MASK       14,
#else
#define _DF_TKLib_TK14_F_THRESHOLD
#define _DF_TKLib_TK14_EN_MASK
#endif

#if EnTk15
#define _DF_TKLib_TK15_F_THRESHOLD   TKLib_TK15_F_THRESHOLD,
#define _DF_TKLib_TK15_EN_MASK       15,
#else
#define _DF_TKLib_TK15_F_THRESHOLD
#define _DF_TKLib_TK15_EN_MASK
#endif

#if EnTk16
#define _DF_TKLib_TK16_F_THRESHOLD   TKLib_TK16_F_THRESHOLD,
#define _DF_TKLib_TK16_EN_MASK       16,
#else
#define _DF_TKLib_TK16_F_THRESHOLD
#define _DF_TKLib_TK16_EN_MASK
#endif

#if EnTk17
#define _DF_TKLib_TK17_F_THRESHOLD   TKLib_TK17_F_THRESHOLD,
#define _DF_TKLib_TK17_EN_MASK       17,
#else
#define _DF_TKLib_TK17_F_THRESHOLD
#define _DF_TKLib_TK17_EN_MASK
#endif

#if EnTk18
#define _DF_TKLib_TK18_F_THRESHOLD   TKLib_TK18_F_THRESHOLD,
#define _DF_TKLib_TK18_EN_MASK       18,
#else
#define _DF_TKLib_TK18_F_THRESHOLD
#define _DF_TKLib_TK18_EN_MASK
#endif

#if EnTk19
#define _DF_TKLib_TK19_F_THRESHOLD   TKLib_TK19_F_THRESHOLD,
#define _DF_TKLib_TK19_EN_MASK       19,
#else
#define _DF_TKLib_TK19_F_THRESHOLD
#define _DF_TKLib_TK19_EN_MASK
#endif

#if EnTk20
#define _DF_TKLib_TK20_F_THRESHOLD   TKLib_TK20_F_THRESHOLD,
#define _DF_TKLib_TK20_EN_MASK       20,
#else
#define _DF_TKLib_TK20_F_THRESHOLD
#define _DF_TKLib_TK20_EN_MASK
#endif

#if EnTk21
#define _DF_TKLib_TK21_F_THRESHOLD   TKLib_TK21_F_THRESHOLD,
#define _DF_TKLib_TK21_EN_MASK       21,
#else
#define _DF_TKLib_TK21_F_THRESHOLD
#define _DF_TKLib_TK21_EN_MASK
#endif

#if EnTk22
#define _DF_TKLib_TK22_F_THRESHOLD   TKLib_TK22_F_THRESHOLD,
#define _DF_TKLib_TK22_EN_MASK       22,
#else
#define _DF_TKLib_TK22_F_THRESHOLD
#define _DF_TKLib_TK22_EN_MASK
#endif

#if EnTk23
#define _DF_TKLib_TK23_F_THRESHOLD   TKLib_TK23_F_THRESHOLD,
#define _DF_TKLib_TK23_EN_MASK       23,
#else
#define _DF_TKLib_TK23_F_THRESHOLD
#define _DF_TKLib_TK23_EN_MASK
#endif

#if EnTk24
#define _DF_TKLib_TK24_F_THRESHOLD   TKLib_TK24_F_THRESHOLD,  
#define _DF_TKLib_TK24_EN_MASK       24,
#else
#define _DF_TKLib_TK24_F_THRESHOLD
#define _DF_TKLib_TK24_EN_MASK
#endif

#if EnTk25
#define _DF_TKLib_TK25_F_THRESHOLD   TKLib_TK25_F_THRESHOLD,
#define _DF_TKLib_TK25_EN_MASK       25,
#else
#define _DF_TKLib_TK25_F_THRESHOLD
#define _DF_TKLib_TK25_EN_MASK
#endif

#if EnTk26
#define _DF_TKLib_TK26_F_THRESHOLD   TKLib_TK26_F_THRESHOLD,
#define _DF_TKLib_TK26_EN_MASK       26,
#else
#define _DF_TKLib_TK26_F_THRESHOLD
#define _DF_TKLib_TK26_EN_MASK
#endif

#if EnTk27
#define _DF_TKLib_TK27_F_THRESHOLD   TKLib_TK27_F_THRESHOLD,
#define _DF_TKLib_TK27_EN_MASK       27,
#else
#define _DF_TKLib_TK27_F_THRESHOLD  
#define _DF_TKLib_TK27_EN_MASK
#endif

//===================================================================================================
#define TKLib_FINGER_THRESHOLD { \
 _DF_TKLib_TK0_F_THRESHOLD  _DF_TKLib_TK1_F_THRESHOLD  _DF_TKLib_TK2_F_THRESHOLD  _DF_TKLib_TK3_F_THRESHOLD  \
 _DF_TKLib_TK4_F_THRESHOLD  _DF_TKLib_TK5_F_THRESHOLD  _DF_TKLib_TK6_F_THRESHOLD  _DF_TKLib_TK7_F_THRESHOLD  \
 _DF_TKLib_TK8_F_THRESHOLD  _DF_TKLib_TK9_F_THRESHOLD  _DF_TKLib_TK10_F_THRESHOLD _DF_TKLib_TK11_F_THRESHOLD \
 _DF_TKLib_TK12_F_THRESHOLD _DF_TKLib_TK13_F_THRESHOLD _DF_TKLib_TK14_F_THRESHOLD _DF_TKLib_TK15_F_THRESHOLD \
 _DF_TKLib_TK16_F_THRESHOLD _DF_TKLib_TK17_F_THRESHOLD _DF_TKLib_TK18_F_THRESHOLD _DF_TKLib_TK19_F_THRESHOLD \
 _DF_TKLib_TK20_F_THRESHOLD _DF_TKLib_TK21_F_THRESHOLD _DF_TKLib_TK22_F_THRESHOLD _DF_TKLib_TK23_F_THRESHOLD \
 _DF_TKLib_TK24_F_THRESHOLD _DF_TKLib_TK25_F_THRESHOLD _DF_TKLib_TK26_F_THRESHOLD _DF_TKLib_TK27_F_THRESHOLD \
}

#define TKLib_TK_CH_MASK { \
 _DF_TKLib_TK0_EN_MASK  _DF_TKLib_TK1_EN_MASK  _DF_TKLib_TK2_EN_MASK  _DF_TKLib_TK3_EN_MASK  \
 _DF_TKLib_TK4_EN_MASK  _DF_TKLib_TK5_EN_MASK  _DF_TKLib_TK6_EN_MASK  _DF_TKLib_TK7_EN_MASK  \
 _DF_TKLib_TK8_EN_MASK  _DF_TKLib_TK9_EN_MASK  _DF_TKLib_TK10_EN_MASK _DF_TKLib_TK11_EN_MASK \
 _DF_TKLib_TK12_EN_MASK _DF_TKLib_TK13_EN_MASK _DF_TKLib_TK14_EN_MASK _DF_TKLib_TK15_EN_MASK \
 _DF_TKLib_TK16_EN_MASK _DF_TKLib_TK17_EN_MASK _DF_TKLib_TK18_EN_MASK _DF_TKLib_TK19_EN_MASK \
 _DF_TKLib_TK20_EN_MASK _DF_TKLib_TK21_EN_MASK _DF_TKLib_TK22_EN_MASK _DF_TKLib_TK23_EN_MASK \
 _DF_TKLib_TK24_EN_MASK _DF_TKLib_TK25_EN_MASK _DF_TKLib_TK26_EN_MASK _DF_TKLib_TK27_EN_MASK \
}
//===================================================================================================
#if(TKLib_OPENED_TK_AMOUNT > 16)
#define TKLib_TIM                         3
#define TKLib_CALIBRATE_TARGET_LINE       600
#define TKLib_CALIBRATE_TARGET_LINE_MIN   100
#define TKLib_CALIBRATE_TARGET_LINE_MAX   TKLib_CALIBRATE_TARGET_LINE + 700
#else
#if(TKLib_OPENED_TK_AMOUNT > 8)
#define TKLib_TIM                         5
#define TKLib_CALIBRATE_TARGET_LINE       800
#define TKLib_CALIBRATE_TARGET_LINE_MIN   100
#define TKLib_CALIBRATE_TARGET_LINE_MAX   TKLib_CALIBRATE_TARGET_LINE + 1100
#else
#define TKLib_TIM                         7
#define TKLib_CALIBRATE_TARGET_LINE       1000
#define TKLib_CALIBRATE_TARGET_LINE_MIN   100
#define TKLib_CALIBRATE_TARGET_LINE_MAX   TKLib_CALIBRATE_TARGET_LINE + 1500
#endif
#endif
#define TKLib_TKPHS                        TKLib_TKCKS/2 
//===================================================================================================
uc8   CFG_TKCTR0                    = (0<<4)|(2<<2)|(3<<0);
uc8   CFG_TKCTR1                    = (0<<6)|(2<<4)|(TKLib_TIM<<0);
uc8   CFG_TKCTR2                    = (0<<7)|(0<<5)|(TKLib_TKPHS<<0);
uc8   CFG_TKCTR3                    = (0<<7)|(TKLib_TKCKS<<0); 

uc16  CFG_FINGER_THRESHOLD[TKLib_OPENED_TK_AMOUNT]      = TKLib_FINGER_THRESHOLD;  
uc8   CFG_TK_CHANNEL[TKLib_OPENED_TK_AMOUNT]      		= TKLib_TK_CH_MASK;
uc8   CFG_TOUCH_NUM                 = TKLib_TOUCH_NUM;       
uc8   CFG_OPENED_TK_AMOUNT          = TKLib_OPENED_TK_AMOUNT;
uc16  CFG_CALIBRATE_TARGET_LINE     = TKLib_CALIBRATE_TARGET_LINE;
uc16  CFG_CALIBRATE_TARGET_LINE_MIN = TKLib_CALIBRATE_TARGET_LINE_MIN;
uc16  CFG_CALIBRATE_TARGET_LINE_MAX = TKLib_CALIBRATE_TARGET_LINE_MAX;
uc8   CFG_BASELINE_CALIBRATE_TIME   = TKLib_BASELINE_CALIBRATE_TIME;
uc8   CFG_CONFIRM_TOUCH_TIME        = TKLib_EFFECTIVE_TOUCH_TIME;
uc8   CFG_CONFIRM_NOTOUCH_TIME      = TKLib_INVALID_TOUCH_TIME;
uc8   CFG_PowerOn_Delay_Time 		= TKLib_PowerOn_Delay_Time;
uc16  CFG_CONFIRM_LONGTOUCH_TIME    = TKLib_LONG_TOUCH_TIME;
uc8   CFG_TKRCTR_DATA 				= TKLib_TKRCTR_DATA;
uc8   CFG_TK_ScanCnt 				= TKLib_ScanCnt;

#if TouchUartDebugLib_SW          
uc8   CFG_TouchUartToolVer 			= TouchUartToolVer;
uc32  CFG_TK_CH_MASK                = TKLib_TK_EN_MASK;
#endif


#if TKLib_TouchLowerPower
uc16  CFG_SLEEPTIME                 = 10*TKLib_SlEEP_WAKEUP_TIMER; 
uc8   CFG_LP_FILTER_LEVEL           = TKLib_TIM;
uc8   CFG_LP_CHECK_TIMER            = TKLib_LP_CHECK_TIMER;
#if (TKLib_LP_FILTER_LEVEL == 0)
uc8   CFG_LP_Debounce_TIME          = 3;
#else
uc8   CFG_LP_Debounce_TIME          = 10;
#endif
#endif
//===================================================================================================
#define CRAM	 0x30    
#if(TKLib_SaveRAM == 0)
u16 BaseLine    	[TKLib_OPENED_TK_AMOUNT] = {0};
u16 RawData     	[TKLib_OPENED_TK_AMOUNT] = {0};
u16 TKCAL       	[TKLib_OPENED_TK_AMOUNT] = {0};
u8  BaseCnt     	[TKLib_OPENED_TK_AMOUNT] = {0};
u8  TouchCnt    	[TKLib_OPENED_TK_AMOUNT] = {0};
#if		TKLib_NormTouchLibrary
u16 RawdataRef  	[TKLib_OPENED_TK_AMOUNT] = {0};
u8  RefAddCnt	  	[TKLib_OPENED_TK_AMOUNT] = {0};
u8  RefSubCnt  		[TKLib_OPENED_TK_AMOUNT] = {0};
#endif
#else
u16 BaseLine    	[TKLib_OPENED_TK_AMOUNT]@(CRAM + 0*TKLib_OPENED_TK_AMOUNT) ={0};
u16 RawData     	[TKLib_OPENED_TK_AMOUNT]@(CRAM + 2*TKLib_OPENED_TK_AMOUNT) ={0};
u16 TKCAL       	[TKLib_OPENED_TK_AMOUNT]@(CRAM + 4*TKLib_OPENED_TK_AMOUNT) ={0};
u8  BaseCnt     	[TKLib_OPENED_TK_AMOUNT]@(CRAM + 6*TKLib_OPENED_TK_AMOUNT) ={0};
u8  TouchCnt    	[TKLib_OPENED_TK_AMOUNT]@(CRAM + 7*TKLib_OPENED_TK_AMOUNT) ={0};
#if		TKLib_NormTouchLibrary
u16 RawdataRef  	[TKLib_OPENED_TK_AMOUNT]@(CRAM + 8*TKLib_OPENED_TK_AMOUNT) ={0};
u8  RefAddCnt	  	[TKLib_OPENED_TK_AMOUNT]@(CRAM + 10*TKLib_OPENED_TK_AMOUNT) ={0};
u8  RefSubCnt  		[TKLib_OPENED_TK_AMOUNT]@(CRAM + 11*TKLib_OPENED_TK_AMOUNT) ={0};
#endif
#endif
//===================================================================================================
//
//===================================================================================================
#if (TKLib_OPENED_TK_AMOUNT ==0)      
#error "没有通道被检测，请重新设置EnTkn (n=0...27)"
#endif

//***************************************************************************************************
#if EnTk0
#info "TK0:Enable"
#endif
#if EnTk1
#info "TK1:Enable"
#endif
#if EnTk2
#info "TK2:Enable"
#endif 
#if EnTk3
#info "TK3:Enable"
#endif
#if EnTk4
#info "TK4:Enable"
#endif
#if EnTk5
#info "TK5:Enable"
#endif
#if EnTk6
#info "TK6:Enable"
#endif
#if EnTk7
#info "TK7:Enable"
#endif
#if EnTk8
#info "TK8:Enable"
#endif
#if EnTk9
#info "TK9:Enable"
#endif
#if EnTk10
#info "TK10:Enable"
#endif
#if EnTk11
#info "TK11:Enable"
#endif
#if EnTk12
#info "TK12:Enable"
#endif
#if EnTk13
#info "TK13:Enable"
#endif
#if EnTk14
#info "TK14:Enable"
#endif
#if EnTk15
#info "TK15:Enable"
#endif
#if EnTk16
#info "TK16:Enable"
#endif
#if EnTk17
#info "TK17:Enable"
#endif
#if EnTk18
#info "TK18:Enable"
#endif
#if EnTk19
#info "TK19:Enable"
#endif
#if EnTk20
#info "TK20:Enable"
#endif
#if EnTk21
#info "TK21:Enable"
#endif
#if EnTk22
#info "TK22:Enable"
#endif
#if EnTk23
#info "TK23:Enable"
#endif
#if EnTk24
#info "TK24:Enable"
#endif
#if EnTk25
#info "TK25:Enable"
#endif
#if EnTk26
#info "TK26:Enable"
#endif
#if EnTk27
#info "TK27:Enable"
#endif
//***************************************************************************************************
#if TKLib_TouchLowerPower
#info "  触摸低功耗模式：已开启"
#info "  低功耗模式WDT使能选择：绿色或休眠下关闭"
#else
#info "  触摸低功耗模式：未开启"
#endif
//***************************************************************************************************
#if ((TKLib_TK0_F_THRESHOLD <50)||(TKLib_TK0_F_THRESHOLD >500))
#error "TK0通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK1_F_THRESHOLD <50)||(TKLib_TK1_F_THRESHOLD >500))
#error "TK1通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK2_F_THRESHOLD <50)||(TKLib_TK2_F_THRESHOLD >500))
#error "TK2通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK3_F_THRESHOLD <50)||(TKLib_TK3_F_THRESHOLD >500))
#error "TK3通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK4_F_THRESHOLD <50)||(TKLib_TK4_F_THRESHOLD >500))
#error "TK4通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK5_F_THRESHOLD <50)||(TKLib_TK5_F_THRESHOLD >500))
#error "TK5通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK6_F_THRESHOLD <50)||(TKLib_TK6_F_THRESHOLD >500))
#error "TK6通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK8_F_THRESHOLD <50)||(TKLib_TK8_F_THRESHOLD >500))
#error "TK8通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK7_F_THRESHOLD <50)||(TKLib_TK7_F_THRESHOLD >500))
#error "TK7通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK9_F_THRESHOLD <50)||(TKLib_TK9_F_THRESHOLD >500))
#error "TK9通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK10_F_THRESHOLD <50)||(TKLib_TK10_F_THRESHOLD >500))
#error "TK10通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK11_F_THRESHOLD <50)||(TKLib_TK11_F_THRESHOLD >500))
#error "TK11通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK12_F_THRESHOLD <50)||(TKLib_TK12_F_THRESHOLD >500))
#error "TK12通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK13_F_THRESHOLD <50)||(TKLib_TK13_F_THRESHOLD >500))
#error "TK13通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK14_F_THRESHOLD <50)||(TKLib_TK14_F_THRESHOLD >500))
#error "TK14通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK15_F_THRESHOLD <50)||(TKLib_TK15_F_THRESHOLD >500))
#error "TK15通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK16_F_THRESHOLD <50)||(TKLib_TK16_F_THRESHOLD >500))
#error "TK16通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK17_F_THRESHOLD <50)||(TKLib_TK17_F_THRESHOLD >500))
#error "TK17通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK18_F_THRESHOLD <50)||(TKLib_TK18_F_THRESHOLD >500))
#error "TK18通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK19_F_THRESHOLD <50)||(TKLib_TK19_F_THRESHOLD >500))
#error "TK19通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK20_F_THRESHOLD <50)||(TKLib_TK20_F_THRESHOLD >500))
#error "TK20通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK21_F_THRESHOLD <50)||(TKLib_TK21_F_THRESHOLD >500))
#error "TK21通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK22_F_THRESHOLD <50)||(TKLib_TK22_F_THRESHOLD >500))
#error "TK22通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK23_F_THRESHOLD <50)||(TKLib_TK23_F_THRESHOLD >500))
#error "TK23通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK24_F_THRESHOLD <50)||(TKLib_TK24_F_THRESHOLD >500))
#error "TK24通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK25_F_THRESHOLD <50)||(TKLib_TK25_F_THRESHOLD >500))
#error "TK25通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK26_F_THRESHOLD <50)||(TKLib_TK26_F_THRESHOLD >500))
#error "TK26通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
#if ((TKLib_TK27_F_THRESHOLD <50)||(TKLib_TK27_F_THRESHOLD >500))
#error "TK27通道的阈值取值，应符合50 <= 设定值 <= 500，请重新设置"
#endif
//***************************************************************************************************
#if (TKLib_TOUCH_NUM == 0)      
#error "TKLib_TOUCH_NUM取值，应符合 1 <= 设定值 <= 开启的通道总数，请重新设置"
#endif

#if (TKLib_TOUCH_NUM > TKLib_OPENED_TK_AMOUNT)      
#error "TKLib_TOUCH_NUM取值，应符合 1 <= 设定值 <= 开启的通道总数，请重新设置"
#endif
//***************************************************************************************************
#if (TKLib_LONG_TOUCH_TIME==0)
#info "TKLib_LONG_TOUCH_TIME取值不建议为0，因为取值为0时，在异常情况下，必需系统重新上电才能恢复"
#endif

#if (TKLib_LONG_TOUCH_TIME > 65535)
#error "TKLib_LONG_TOUCH_TIME最大只能为65535，请重新设置"
#endif
//***************************************************************************************************
#if ((TKLib_BASELINE_CALIBRATE_TIME < 1)||(TKLib_BASELINE_CALIBRATE_TIME > 14))
#error "触摸按键基线更新速度TKLib_BASELINE_CALIBRATE_TIME取值，应符合1 <= 设定值 <= 14，请重新设置"
#endif
//***************************************************************************************************
#if ((TKLib_TKCKS < 7 )||(TKLib_TKCKS > 31))
#error "TKLib_TKCKS取值，应符合7 <= 设定值 <= 31，请重新设置"
#endif
//***************************************************************************************************
#if ((TKLib_EFFECTIVE_TOUCH_TIME < 1)||(TKLib_EFFECTIVE_TOUCH_TIME > 15))
#error "按键确认次数TKLib_EFFECTIVE_TOUCH_TIME取值，应符合1 <= 设定值 <= 15，请重新设置"
#endif

#if ((TKLib_INVALID_TOUCH_TIME < 1)||(TKLib_INVALID_TOUCH_TIME > 15))
#error "按键取消次数TKLib_INVALID_TOUCH_TIME取值，应符合1 <= 设定值 <= 15，请重新设置"
#endif
//***************************************************************************************************
#if ((TKLib_TKRCTR_DATA == 0)||(TKLib_TKRCTR_DATA > 63))
#error "TKLib_TKRCTR_DATA取值，应符合0 <= 设定值 <= 63，请重新设置"
#endif
//***************************************************************************************************
#if ((TKLib_ScanCnt < 1)||(TKLib_ScanCnt > 30))
#error "TKLib_ScanCnt取值，应符合1 <= 设定值 <= 30，请重新设置"
#endif
//***************************************************************************************************
#if ((TKLib_PowerOn_Delay_Time < 0)||(TKLib_PowerOn_Delay_Time > 254))
#error "TKLib_PowerOn_Delay_Time取值，应符合0 <= 设定值 <= 254，请重新设置"
#endif
//***************************************************************************************************
#if (TKLib_SaveRAM > 1)
#error "TKLib_SaveRAM取值 ∈ {0,1}，请重新设置"
#endif
//***************************************************************************************************
#if (TouchUartToolVer > 1)
#error "TouchUartToolVer取值 ∈ {0,1}，请重新设置"
#endif
//***************************************************************************************************
/*********************************END OF FILE************************************/
