 /*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
* File Name          : M9P6362_Touch_Lib_CFG.h
* Author             : MASSES CHIP
* Version            : V1.04
* Date               : 2025/12/15
*********************************************************************************



********************************************************************************/
#ifndef __M9P6362_Touch_Lib_CFG_H__  
#define __M9P6362_Touch_Lib_CFG_H__

//===================================================================================================
//               		0: 该通道按键不检测；1: 该通道按键需检测。
#define EnTk0    		0
#define EnTk1    		0
#define EnTk2    		1
#define EnTk3    		0
#define EnTk4    		0
#define EnTk5    		0
#define EnTk6    		0
#define EnTk7    		0 
#define EnTk8    		0
#define EnTk9    		0
#define EnTk10   		0
#define EnTk11   		0
#define EnTk12   		0
#define EnTk13   		0
#define EnTk14   		0
#define EnTk15   		0
#define EnTk16   		0
#define EnTk17   		0
#define EnTk18   		0
#define EnTk19   		0
#define EnTk20   		0
#define EnTk21   		0
#define EnTk22   		0
#define EnTk23   		0
#define EnTk24   		0
#define EnTk25   		0
#define EnTk26   		0
#define EnTk27   		0
//===================================================================================================
// 触摸阈值： 取值需具体应用环境决定，最小50，最大500，值越小越灵敏
#define TKLib_TK0_F_THRESHOLD            80
#define TKLib_TK1_F_THRESHOLD            80
#define TKLib_TK2_F_THRESHOLD            80
#define TKLib_TK3_F_THRESHOLD            80
#define TKLib_TK4_F_THRESHOLD            80
#define TKLib_TK5_F_THRESHOLD            80
#define TKLib_TK6_F_THRESHOLD            80
#define TKLib_TK7_F_THRESHOLD            80
#define TKLib_TK8_F_THRESHOLD            80
#define TKLib_TK9_F_THRESHOLD            80
#define TKLib_TK10_F_THRESHOLD           80
#define TKLib_TK11_F_THRESHOLD           80
#define TKLib_TK12_F_THRESHOLD           80
#define TKLib_TK13_F_THRESHOLD           80
#define TKLib_TK14_F_THRESHOLD           80
#define TKLib_TK15_F_THRESHOLD           80
#define TKLib_TK16_F_THRESHOLD           80
#define TKLib_TK17_F_THRESHOLD           80
#define TKLib_TK18_F_THRESHOLD           80
#define TKLib_TK19_F_THRESHOLD           80
#define TKLib_TK20_F_THRESHOLD           80
#define TKLib_TK21_F_THRESHOLD           80
#define TKLib_TK22_F_THRESHOLD           80
#define TKLib_TK23_F_THRESHOLD           80
#define TKLib_TK24_F_THRESHOLD           80
#define TKLib_TK25_F_THRESHOLD           80
#define TKLib_TK26_F_THRESHOLD           80
#define TKLib_TK27_F_THRESHOLD           80   
//===================================================================================================
// 设置允许同时响应的最多按键数量：     (1 <= value <= 开启的按键总数) 请根据实际使用时，同时触摸最多按键个数配置
#define TKLib_TOUCH_NUM                  1  
 
// 设置按键最长有效时间： 0: 一直有效，即按键标志产生后，只要手指不离开，按键标志就会一直存在，不建议配置成0
//						非0: 当有任何触摸标志次数大于设定值时，所有的按键标志会被清除并复位所有通道的触摸基线,
//							 按键最长有效时间 ≈ TKLib_LONG_TOUCH_TIME * aSCAN_TIME，其中aSCAN_TIME 为 Touch_Key_Process 调用间隔时间
//                           在CPU = 16M/4T时 aSCAN_TIME 估算值 > 开启的通道数 * 1ms 
//                           (1<= value <=65535) 通常最长有效时间控制在8~30S左右，有特定时长需求的可根据实际需求调整，
//                                               但不建议时间设定过长，因为时间过长，意味着异常时自恢复需要的时间越长
#define TKLib_LONG_TOUCH_TIME            2500      

// 设置触摸按键基线更新速度：        	(1<= value <=14) 
#define TKLib_BASELINE_CALIBRATE_TIME    7    

//  上电按键有效延时时间,可根据实际需求修改				 
// 									    (0<= value<=254)  value*10ms
#define TKLib_PowerOn_Delay_Time         100

//普通库和精简库选择位					 0：选用精简库,库RAM和ROM均占用少一些		1：选用标准库,CS静态效果会提高
#define TKLib_NormTouchLibrary       	 1

// 设置RAM动静态分配					 0：RAM动态分配;  1：RAM静态分配
//											默认动态分配，当RAM提示不够时，打开静态分配，这时RAM会多出部分可以使用，但程序空间开销也会增大
#define TKLib_SaveRAM         			 0 

// 触摸基线复位函数调用选择位            0：BaseLineReset()基线复位函数不可调用		1：BaseLineReset()基线复位函数可调用	
#define	BaseLineRst					 	 0
//================================================================================
// 触摸省电模式设定，一般运用请关闭此模式
//================================================================================
// 设置触摸低功耗模式:	    			 0: 不使用触摸省电模式；1: 使用触摸省电模式。
#define TKLib_TouchLowerPower            0

// 设置触摸低功耗模式唤醒时间:  		(0 <= value <= 255) 值越大更功耗越小，但唤醒速度会更慢 
// 唤醒时间 = value*1ms 
#define TKLib_SlEEP_WAKEUP_TIMER         100       

// 设置低功耗滤波等级：                  0 -> 普通, 1 -> 中 ( 等级越高，功耗越大 )
#define TKLib_LP_FILTER_LEVEL            0 

// 设置低功耗模式是否校准低频时钟：      0: 不校准低频时钟；1: 开启校准低频时钟。
#define TKLib_SleepWaKeUpTimeCheck       0

// 设置校准间隔时间:  		             (0 <= value <= 255) 值越大间隔时间越久
// 校准时间 = value*设置触摸低功耗模式唤醒时间 
#define TKLib_LP_CHECK_TIMER             60   
//===================================================================================================
// 以下参数用户谨慎修改
//===================================================================================================

// 设置确认手指触摸次数：               (1 <= value <= 15) 值越小触摸越灵敏,值越大抗干扰能力越好
#define TKLib_EFFECTIVE_TOUCH_TIME       4

// 设置确认手指离开次数：               (1 <= value <= 15) 值越小触摸越灵敏,值越大抗干扰能力越好
#define TKLib_INVALID_TOUCH_TIME         3

// 触摸充放电频率               		(7<= value<=31) 值越小防水、抗干扰效果越好
#define TKLib_TKCKS                      7 

// 设置触摸放电电阻阻值					(1 <= value <= 63)  值越小触摸越灵敏
#define TKLib_TKRCTR_DATA      			 20

// 触摸数据采集次数						(1 <= value <= 30)  值越大抗干扰效果越好,值越小触摸速度越快，一般默认即可
#define TKLib_ScanCnt         		 	 8 

#endif 
/*__Touch_Lib_CFG_H__*/