/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
* File Name          : M9P6362_Touch_Lib_CFG.c
* Author             : MASSES CHIP
* Version            : V1.04
* Date               : 2025/12/15
*********************************************************************************


********************************************************************************/
//===================================================================================================
#include "zc.h"
#include "MASSESCHIP_DEFINE.H"
#include "M9P6362_Touch_Lib.h"
#include "M9P6362_Touch_Lib_CFG.h"
#include "M9P6362_Touch_UartDebug_Lib_CFG.h"
//===================================================================================================
#define TKLib_OPENED_TK_AMOUNT \
(EnTk0+EnTk1+EnTk2+EnTk3+EnTk4+EnTk5+EnTk6+EnTk7+EnTk8+EnTk9+EnTk10+EnTk11+EnTk12+EnTk13+EnTk14+EnTk15+\
EnTk16+EnTk17+EnTk18+EnTk19+EnTk20+EnTk21+EnTk22+EnTk23+EnTk24+EnTk25+EnTk26+EnTk27)

extern void Touch_Init_Few(void);      
extern void Touch_Init_Mid(void);     
extern void Touch_Init_Fast(void);
//===================================================================================================
extern void Touch_ISR_Process_Few_Norm(void);
extern void Touch_ISR_Process_Few_Zip(void);
extern void Touch_ISR_Process_Mid_Norm(void);
extern void Touch_ISR_Process_Mid_Zip(void);
extern void Touch_ISR_Process_Fast_Norm(void); 
extern void Touch_ISR_Process_Fast_Zip(void);
//===================================================================================================
extern void KeyFlagRenovate_Few_Norm(void);
extern void KeyFlagRenovate_Few_Zip(void);
extern void KeyFlagRenovate_Mid_Norm(void);
extern void KeyFlagRenovate_Mid_Zip(void);
extern void KeyFlagRenovate_Fast_Norm(void);
extern void KeyFlagRenovate_Fast_Zip(void);
//===================================================================================================
extern void KeyFlagDebounce_Few(void);
extern void KeyFlagDebounce_Mid(void);
extern void KeyFlagDebounce_Fast(void);
//===================================================================================================
extern void BaseLineCheck_Few(void);
extern void BaseLineCheck_Mid(void);
extern void BaseLineCheck_Fast(void);
//===================================================================================================
extern void BaseLineReset_Few(void);
extern void BaseLineReset_Mid(void);
extern void BaseLineReset_Fast(void);
//================================================================================
//触摸初始化程序
//================================================================================
void Touch_Init(void)
{
#if(TKLib_OPENED_TK_AMOUNT > 16)
	Touch_Init_Fast();  
#else	
#if(TKLib_OPENED_TK_AMOUNT > 8)	
	Touch_Init_Mid();
#else
	Touch_Init_Few();	
#endif	
#endif	
}

//================================================================================
//复位所有通道基线，需要BaseLineRst置1才可以调用
//================================================================================
#if(BaseLineRst == 1)
void BaseLineReset(void)
{
#if(TKLib_OPENED_TK_AMOUNT > 16)
	BaseLineReset_Fast();
#else	
#if(TKLib_OPENED_TK_AMOUNT > 8)	
	BaseLineReset_Mid();
#else
	BaseLineReset_Few();	
#endif	
#endif	
}
#endif	
//================================================================================
//按键处理程序
//================================================================================
void Touch_Key_Process(void)
{
#if(TKLib_OPENED_TK_AMOUNT > 16)
	#if(TKLib_NormTouchLibrary == 1)	
		KeyFlagRenovate_Fast_Norm(); 
	#else
		KeyFlagRenovate_Fast_Zip(); 
	#endif
	KeyFlagDebounce_Fast(); 
	BaseLineCheck_Fast(); 
#else
#if(TKLib_OPENED_TK_AMOUNT > 8)
	#if(TKLib_NormTouchLibrary == 1)	
		KeyFlagRenovate_Mid_Norm(); 
	#else
		KeyFlagRenovate_Mid_Zip(); 
	#endif
	KeyFlagDebounce_Mid();
	BaseLineCheck_Mid();
#else	
	#if(TKLib_NormTouchLibrary == 1)	
		KeyFlagRenovate_Few_Norm(); 
	#else
		KeyFlagRenovate_Few_Zip(); 
	#endif
	KeyFlagDebounce_Few(); 
	BaseLineCheck_Few(); 
#endif	
#endif	
}
//================================================================================
//触摸中断,低优先级
//================================================================================
void interrupt low_priority ISR_Low_Process(void)
{
#if(TKLib_OPENED_TK_AMOUNT > 16)
	#if(TKLib_NormTouchLibrary == 1)	
		Touch_ISR_Process_Fast_Norm(); 
	#else
		Touch_ISR_Process_Fast_Zip(); 
	#endif
#else
#if(TKLib_OPENED_TK_AMOUNT > 8)
	#if(TKLib_NormTouchLibrary == 1)	
		Touch_ISR_Process_Mid_Norm(); 
	#else
		Touch_ISR_Process_Mid_Zip(); 
	#endif
#else	
	#if(TKLib_NormTouchLibrary == 1)	
		Touch_ISR_Process_Few_Norm(); 
	#else
		Touch_ISR_Process_Few_Zip(); 
	#endif
#endif
#endif	
}
/*********************************END OF FILE************************************/
