/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
* File Name          : M9P6362_TouchUartDebug_Lib_CFG.c
* Author             : MASSES CHIP
* Version            : V1.04
* Date               : 2025/12/15
*********************************************************************************

********************************************************************************/
//================================================================================
#include "zc.h"
#include "MASSESCHIP_DEFINE.H"
#include "M9P6362_Touch_UartDebug_Lib_CFG.h"
#include "M9F_IO_INIT.h"
#include "M9F_AFIO_MP.h"
//================================================================================
//================================================================================
//以下不需要查看
//================================================================================

//mcu时钟源  不需要修改
#define SYS_FOSC                   32000000//16000000/(11.55/8.68)

//================================================================================
#if TouchUartDebugLib_SW

#info “触摸串口调试功能：已开启，请调试结束后关闭"

//================================================================================
#ifdef  TouchUartDebugLib_TXD_IOA0
#define	Touch_MPTX            MP(A,0)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(A,0,1)
#info “触摸调试串口：TXD -> IOA0"
#endif

#ifdef  TouchUartDebugLib_TXD_IOA1
#define	Touch_MPTX            MP(A,1)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(A,1,1)
#info “触摸调试串口：TXD -> IOA1"
#endif

#ifdef  TouchUartDebugLib_TXD_IOA2
#define	Touch_MPTX            MP(A,2)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(A,2,1)
#info “触摸调试串口：TXD -> IOA2"
#endif

#ifdef  TouchUartDebugLib_TXD_IOA3
#define	Touch_MPTX            MP(A,3)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(A,3,1)
#info “触摸调试串口：TXD -> IOA3"
#endif

#ifdef  TouchUartDebugLib_TXD_IOA4
#define	Touch_MPTX            MP(A,4)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(A,4,1)
#info “触摸调试串口：TXD -> IOA4"
#endif

#ifdef  TouchUartDebugLib_TXD_IOA5
#define	Touch_MPTX            MP(A,5)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(A,5,1)
#info “触摸调试串口：TXD -> IOA5"
#endif

#ifdef  TouchUartDebugLib_TXD_IOA6
#define	Touch_MPTX            MP(A,6)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(A,6,1)
#info “触摸调试串口：TXD -> IOA6"
#endif

#ifdef  TouchUartDebugLib_TXD_IOA7
#define	Touch_MPTX            MP(A,7)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(A,7,1)
#info “触摸调试串口：TXD -> IOA7"
#endif

#ifdef  TouchUartDebugLib_TXD_IOB0
#define	Touch_MPTX            MP(B,0)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(B,0,1)
#info “触摸调试串口：TXD -> IOB0"
#endif

#ifdef  TouchUartDebugLib_TXD_IOB1
#define	Touch_MPTX            MP(B,1)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(B,1,1)
#info “触摸调试串口：TXD -> IOB1"
#endif

#ifdef  TouchUartDebugLib_TXD_IOB2
#define	Touch_MPTX            MP(B,2)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(B,2,1)
#info “触摸调试串口：TXD -> IOB2"
#endif

#ifdef  TouchUartDebugLib_TXD_IOB3
#define	Touch_MPTX            MP(B,3)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(B,3,1)
#info “触摸调试串口：TXD -> IOB3"
#endif

#ifdef  TouchUartDebugLib_TXD_IOB4
#define	Touch_MPTX            MP(B,4)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(B,4,1)
#info “触摸调试串口：TXD -> IOB4"
#endif

#ifdef  TouchUartDebugLib_TXD_IOB5
#define	Touch_MPTX            MP(B,5)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(B,5,1)
#info “触摸调试串口：TXD -> IOB5"
#endif

#ifdef  TouchUartDebugLib_TXD_IOB6
#define	Touch_MPTX            MP(B,6)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(B,6,1)
#info “触摸调试串口：TXD -> IOB6"
#endif

#ifdef  TouchUartDebugLib_TXD_IOB7
#define	Touch_MPTX            MP(B,7)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(B,7,1)
#info “触摸调试串口：TXD -> IOB7"
#endif

#ifdef  TouchUartDebugLib_TXD_IOC0
#define	Touch_MPTX            MP(C,0)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(C,0,1)
#info “触摸调试串口：TXD -> IOC0"
#endif

#ifdef  TouchUartDebugLib_TXD_IOC1
#define	Touch_MPTX            MP(C,1)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(C,1,1)
#info “触摸调试串口：TXD -> IOC1"
#endif

#ifdef  TouchUartDebugLib_TXD_IOC2
#define	Touch_MPTX            MP(C,2)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(C,2,1)
#info “触摸调试串口：TXD -> IOC2"
#endif

#ifdef  TouchUartDebugLib_TXD_IOC3
#define	Touch_MPTX            MP(C,3)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(C,3,1)
#info “触摸调试串口：TXD -> IOC3"
#endif

#ifdef  TouchUartDebugLib_TXD_IOC4
#define	Touch_MPTX            MP(C,4)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(C,4,1)
#info “触摸调试串口：TXD -> IOC4"
#endif

#ifdef  TouchUartDebugLib_TXD_IOC5
#define	Touch_MPTX            MP(C,5)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(C,5,1)
#info “触摸调试串口：TXD -> IOC5"
#endif

#ifdef  TouchUartDebugLib_TXD_IOC6
#define	Touch_MPTX            MP(C,6)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(C,6,1)
#info “触摸调试串口：TXD -> IOC6"
#endif

#ifdef  TouchUartDebugLib_TXD_IOC7
#define	Touch_MPTX            MP(C,7)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(C,7,1)
#info “触摸调试串口：TXD -> IOC7"
#endif

#ifdef  TouchUartDebugLib_TXD_IOD0
#define	Touch_MPTX            MP(D,0)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(D,0,1)
#info “触摸调试串口：TXD -> IOD0"
#endif

#ifdef  TouchUartDebugLib_TXD_IOD1
#define	Touch_MPTX            MP(D,1)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(D,1,1)
#info “触摸调试串口：TXD -> IOD1"
#endif

#ifdef  TouchUartDebugLib_TXD_IOD2
#define	Touch_MPTX            MP(D,2)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(D,2,1)
#info “触摸调试串口：TXD -> IOD2"
#endif

#ifdef  TouchUartDebugLib_TXD_IOD3
#define	Touch_MPTX            MP(D,3)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(D,3,1)
#info “触摸调试串口：TXD -> IOD3"
#endif

#ifdef  TouchUartDebugLib_TXD_IOD4
#define	Touch_MPTX            MP(D,4)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(D,4,1)
#info “触摸调试串口：TXD -> IOD4"
#endif

#ifdef  TouchUartDebugLib_TXD_IOD5
#define	Touch_MPTX            MP(D,5)
#define SET_Touch_TXD_PORT    SET_aPORT_OUT(D,5,1)
#info “触摸调试串口：TXD -> IOD5"
#endif

#endif

//================================================================================
#if TouchUartDebugLib_SW

//================================================================================
void Touch_UartDebug_Init(void)
{
  SET_Touch_TXD_PORT;
  MPTX0 = Touch_MPTX;

  TX0CR|=0X80;
  BRGD0H =(u8)((u16)(((float)SYS_FOSC/4/TouchUartDebugLib_BAUDRATE+0.5)-1)>>8);
  BRGD0L =(u8)((u16)((float)SYS_FOSC/4/TouchUartDebugLib_BAUDRATE+0.5)-1);  
}

//================================================================================
void Touch_UartDebug_SendChar(u8 send_data)
{
  TX0REG = send_data;
  while((TX0CR&0x40)==0);
}

//================================================================================
void Touch_UartDebug_SendWord(u16 send_data)
{
  TX0REG = (u8)(send_data >> 8);
  TX0REG = (u8)send_data;
  //TX0REG = (u8)(send_data >> 8);
  while((TX0CR&0x40)==0);
}

#endif

/*********************************END OF FILE************************************/
