;/*******************(ASM) COPYRIGHT 2025 Masses-Chip ******************************
;* Project Name       : M8P516_IOA1_Interrupt.prj
;* File Name          : M8P516_IOA1_Interrupt.ASM
;* Author             : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/12
;* Web    			  : www.masses-chip.com
;* FAE                : Luo
;  				 	  : QQ：411680975
;********************************************************************************
;*
;*Option:16M/4T,WDT-Disable-288ms,BOR 2.4V 
;*注意：本范例仅供参考，实际应用需评估硬件兼容性
;*说明：本范例是IOA1为中断源，IOA1变化中断唤醒休眠，翻转IOA0
;******************************************************************************/
;//===============================================================================
;//***********************************头文件**************************************
;//用户不可更改
;//===============================================================================
#INCLUDE	 	ZC.INC

;//===============================================================================
;//******************************定义全局变量*************************************
;//用户可以自行看需求定义变量
;//===============================================================================
userdata				udata	H'00'
R_Flag					res		1						;//定义变量
#define B_IOA1_Interrupt_Flag       R_Flag,0            ;//定义标志位

;//===============================================================================
;//*********************************C O D E***************************************
;//===============================================================================	
		ORG			0000H
		GOTO		MainProgram
		ORG			0008H
		GOTO		Interrupt	

;//===============================================================================
;//********************************程序主函数*************************************
;//===============================================================================			
;//------------------------------程序初始化---------------------------------------
MainProgram:
		CALL       	SYSTEM_INIT				;//系统初始化
		CALL       	Clr_RAM_00H_3FH			;//清零RAM
		CALL       	IOA1_Interrupt_INIT		;//IOA1中断初始化
;//------------------------------主函数循环---------------------------------------		
MainLoop:
		BSET		OSCM,STOP
		NOP
		NOP
		NOP
		JBTS1		B_IOA1_Interrupt_Flag
		GOTO		MainLoop
		BCLR		B_IOA1_Interrupt_Flag
		JBTS1		IOA,0
		GOTO		SET_IOA0_1
		GOTO		SET_IOA0_0
SET_IOA0_1:
		BSET		IOA,0
		GOTO		MainLoop
SET_IOA0_0	
		BCLR		IOA,0
		GOTO		MainLoop

;//===============================================================================
;//******************************中断服务子程序***********************************
;//===============================================================================
;//中断进来	
Interrupt:
		PUSH
		JBTS1		INTF1,0					
		GOTO		Interrupt_END	
		BCLR		INTF1,0
		BSET		B_IOA1_Interrupt_Flag
Interrupt_END:	
;//中断结束
		POP
	    RETIE

;//===============================================================================
;//*********************************IOA1初始化********************************
;//端口设置：IOA1输入模式，数字口，上拉开启
;//IOA1中断设置：IOA1变化中断
;//系统时钟设置：休眠模式下关闭高频、低频时钟
;//===============================================================================	
IOA1_Interrupt_INIT:
;//1、端口设置
		BCLR		OEA,1
		BCLR		ANSA,1
		BSET		PUA,1
;//2、IOA5中断设置
		BSET       	IOAICR,1
		BCLR		INTF1,0							
		BSET		INTCR1,0			
		BSET       	OPTION,7
;//3、系统时钟设置
		MOVIA		0x05
		MOVAR		OSCM
		RETURN

;//===============================================================================
;//**********************************系统初始化***********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO状态为输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//===============================================================================		
SYSTEM_INIT:
;//-----------------------------------------------------------------------           
;//Init Clock		
		MOVIA       b'00000000'
		MOVAR		OSCM
;//Init IO 
        ;//IOA
		MOVIA		0x00
        MOVAR     	PUA			;//0:上拉关闭 1:上拉使能
		MOVAR      	IOA        	;//0:输出低   1:输出高
		MOVIA      	0x3F    	
        MOVAR      	OEA			;//0:输入     1:输出  
		CLRR		ANSA
;//------------------------------------------------------------------------      
;//Init Interrupt          
        BCLR       	OPTION,7  		;//1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
		RETURN
		
;//===============================================================================
;//*****************************RAM清零(00H~3FH)******************************
;//RAM清零：RAM区00H~3FH全部清零；
;//===============================================================================				
Clr_RAM_00H_3FH:		
		CLRR		FSR0
Clr_RAM_00H_3FH_Loop:
		MOVIA		0x00
		MOVAR		INDF0
		INCR		FSR0,1
		JBTS1		FSR0,6
		GOTO		Clr_RAM_00H_3FH_Loop
		RETURN
		END

;//******************************END OF FILE*************************************