;/*******************(ASM) COPYRIGHT 2025 Masses-Chip ******************************
;*Project Name        : M8P516_PWM0.prj
;* File Name          : M8P516_PWM0.ASM
;* Author             : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web    			  : www.masses-chip.com
;* FAE                : Luo
;  				 	  : QQ：411680975
;********************************************************************************
;*
;*Option:16M/4T,WDT-Disable-288ms,BOR 2.4V 
;*注意：本范例仅供参考，实际应用需评估硬件兼容性
;*说明：本范例以TC0为时基的PWM0(IOA0、IOA2)输出占空比为50%的1KHz波形，以100ms为周期开关PWM
;******************************************************************************/
;//===============================================================================
;//***********************************头文件**************************************
;//用户不可更改
;//===============================================================================
#INCLUDE	 	ZC.INC

;//===============================================================================
;//******************************定义全局变量*************************************
;//用户可以自行看需求定义变量
;//===============================================================================
userdata				udata	H'00'
R_Delay_Count			res		1						;//延时计数R_Delay_Count
R_Delay_Count_1			res		1						;//延时计数R_Delay_Count_1
R_Delay_Count_2			res		1						;//延时计数R_Delay_Count_2

;//===============================================================================
;//*********************************C O D E***************************************
;//===============================================================================	
		ORG			0000H
		GOTO		MainProgram
		ORG			0008H
		GOTO		Interrupt	

;//===============================================================================
;//********************************程序主函数*************************************
;//===============================================================================			
;//------------------------------程序初始化---------------------------------------
MainProgram:
		CALL       	SYSTEM_INIT				;//系统初始化
		CALL       	Clr_RAM_00H_3FH			;//清零RAM
		CALL       	PWM0_INIT				;//PWM0初始化
;//------------------------------主函数循环---------------------------------------		
MainLoop:
		CLRWDT								;//清除看门狗
		BSET		PWM0CR,5
		BSET		PWM0CR,6
		CALL		Delay_100ms
		BCLR		PWM0CR,5
		BCLR		PWM0CR,6
		CALL		Delay_100ms
		GOTO		MainLoop
;//===============================================================================
;//******************************中断服务子程序***********************************
;//===============================================================================
;//中断进来	
Interrupt:
		PUSH
		NOP
Interrupt_END:	
;//中断结束
		POP
	    RETIE

;//===============================================================================
;//*********************************PWM0初始化*************************************
;//TC0设置：8位模式，高频系统时钟，1:64分频
;//PWM0设置 占空比50%
;//===============================================================================	
PWM0_INIT:
;//1、TC0设置
		MOVIA      	0x0E
		MOVAR	    T0CR		               		
		CLRR	   	TC0CH                    			
		MOVIA      	249
		MOVAR	   	TC0CL
;//2、中断设置
		MOVIA		0x80
		MOVAR		PWM0CR
		MOVIA		(249+1)/2
		MOVAR		PWM0D
		BSET       	T0CR,7							   	   					
		RETURN

Delay_100ms:
		MOVIA		3
		MOVAR		R_Delay_Count
Delay_100ms_1:	
		MOVIA		200
		MOVAR		R_Delay_Count_1
Delay_100ms_2:		
		MOVIA		220
		MOVAR		R_Delay_Count_2
Delay_100ms_3:		
		DJZR		R_Delay_Count_2,1
		GOTO		Delay_100ms_3
Delay_100ms_4:
		DJZR		R_Delay_Count_1,1
		GOTO		Delay_100ms_2
		DJZR		R_Delay_Count,1
		GOTO		Delay_100ms_1
		RETURN

;//===============================================================================
;//**********************************系统初始化***********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置个IO状态为输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//===============================================================================		
SYSTEM_INIT:
;//-----------------------------------------------------------------------           
;//Init Clock		
		MOVIA       b'00000000'
		MOVAR		OSCM
;//Init IO 
        ;//IOA
		MOVIA		0x00
        MOVAR     	PUA			;//0:上拉关闭 1:上拉使能
		MOVAR      	IOA        	;//0:输出低   1:输出高
		MOVIA      	0x3F    	
        MOVAR      	OEA			;//0:输入     1:输出  
		CLRR		ANSA
;//------------------------------------------------------------------------      
;//Init Interrupt          
        BCLR       	OPTION,7  		;//1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
		RETURN
		
;//===============================================================================
;//*****************************RAM清零(00H~3FH)******************************
;//RAM清零：RAM区00H~3FH全部清零；
;//===============================================================================				
Clr_RAM_00H_3FH:		
		CLRR		FSR0
Clr_RAM_00H_3FH_Loop:
		MOVIA		0x00
		MOVAR		INDF0
		INCR		FSR0,1
		JBTS1		FSR0,6
		GOTO		Clr_RAM_00H_3FH_Loop
		RETURN
		END

;//******************************END OF FILE*************************************    