;/*******************(ASM) COPYRIGHT 2025 Masses-Chip ******************************
;*Project Name        : M8P613_ADC.prj
;* File Name          : ADC_WORK.ASM
;* Author             : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web    			  : www.masses-chip.com
;* FAE                : Luo
;  				 	  : QQ：411680975
;********************************************************************************
;*注意：本范例仅供参考，实际应用需评估硬件兼容性
;*说明：本范例是输入通道AN0(IOA0)的AD(时钟FCPU/4 参考电压VDD)采集
;*连续采十次AD数据去掉最大最小值求平均得出AD值
;********************************************************************************

ADC_DATA_Real:
		MOVIA		10
		MOVAR		R_Count				
		CLRR		R_ADC_MAX_DATAH 		
		CLRR		R_ADC_MAX_DATAL 
		MOVIA		0xFF
		MOVAR		R_ADC_MIN_DATAH 
		MOVAR		R_ADC_MIN_DATAL 
		CLRR		R_ADC_DATA_SUM_L 
		CLRR		R_ADC_DATA_SUM_H 
ADC_DATA_Collect_Lp:				
		BSET     	ADCON0,6								;//AD转换
		JBTS0		ADCON0,6
		GOTO		$-1
		MOVR		ADL,0								
		ADDAR		R_ADC_DATA_SUM_L,1
		MOVR		ADH,0
		ADCAR		R_ADC_DATA_SUM_H,1
		CALL		DATA_CMP	
		DJZR        R_Count,1
		GOTO        ADC_DATA_Collect_Lp	
		MOVR        R_ADC_MIN_DATAL,0							;//减去最小值	
		SUBRA		R_ADC_DATA_SUM_L,1
		MOVR        R_ADC_MIN_DATAH,0
		SBCRA 		R_ADC_DATA_SUM_H,1						;//减去最大值
		MOVR        R_ADC_MAX_DATAL,0
		SUBRA		R_ADC_DATA_SUM_L,1
		MOVR        R_ADC_MAX_DATAH,0
		SBCRA 		R_ADC_DATA_SUM_H,1
		MOVIA       0x03									;//剩下8组数据平均	
		MOVAR       R_Count
Average_loop:		
		BCLR		STATUS,C	
		RRR			R_ADC_DATA_SUM_H,1
		RRR         R_ADC_DATA_SUM_L,1
		DJZR		R_Count,1
		GOTO		Average_loop
		RETURN


;//*****************************************************************************
;//最大值和最小值比较       
;//***************************************************************************** 
DATA_CMP:													;//最大值比较
MAX_DATA_CMP:
		MOVR		ADH,0
		JGAR        R_ADC_MAX_DATAH	
		GOTO        MIN_DATA_CMP
		JBTS1       STATUS,Z
		GOTO        MAX_DATA_Change
		MOVR		ADL,0
		JGAR        R_ADC_MAX_DATAL
		GOTO        MIN_DATA_CMP
MAX_DATA_Change:   											;//把最大值更新为当前值
		MOVR		ADH,0				
		MOVAR		R_ADC_MAX_DATAH
		MOVR		ADL,0
		MOVAR		R_ADC_MAX_DATAL

MIN_DATA_CMP:												;//最小值比较
        MOVR		ADH,0
		JGAR        R_ADC_MIN_DATAH
		GOTO        MIN_DATA_Change
		JBTS1       STATUS,Z
		GOTO        DATA_CMP_End
		MOVR		ADL,0
		JLAR        R_ADC_MIN_DATAL
		GOTO        DATA_CMP_End
MIN_DATA_Change: 											;//把最小值更新为当前值
		MOVR		ADH,0				
		MOVAR		R_ADC_MIN_DATAH
		MOVR		ADL,0
		MOVAR		R_ADC_MIN_DATAL
		
DATA_CMP_End:
		RETURN

;//******************************END OF FILE*************************************   