;/*******************(ASM) COPYRIGHT 2025 Masses-Chip ******************************
;*Project Name        : M8P613_ADC.prj
;* File Name          : M8P613_ADC.ASM
;* Author             : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web    			  : www.masses-chip.com
;* FAE                : Luo
;  				 	  : QQ：411680975
;********************************************************************************
;*
;*Option:16M/4T,WDT-Enable-288ms,BOR 2.4V 
;*注意：本范例仅供参考，实际应用需评估硬件兼容性
;*说明：本范例是输入通道AN0(IOA0)的AD(时钟FCPU/4 参考电压VDD)采集
;*连续采十次AD数据去掉最大最小值求平均得出AD值
;******************************************************************************/
;//===============================================================================
;//***********************************头文件**************************************
;//用户不可更改
;//===============================================================================
#INCLUDE	 	ZC.INC

;//===============================================================================
;//******************************定义全局变量*************************************
;//用户可以自行看需求定义变量
;//===============================================================================
userdata				udata	H'00'
R_ADC_MAX_DATAH			res		1           ;//最大数据高位
R_ADC_MAX_DATAL			res		1          	;//最大数据低位
R_ADC_MIN_DATAH			res		1           ;//最小数据高位
R_ADC_MIN_DATAL			res		1           ;//最小数据低位
R_ADC_DATA_SUM_L		res		1         	;//数据求和低位
R_ADC_DATA_SUM_H		res		1         	;//数据求和高位
R_Count					res		1			;//取值次数

;//===============================================================================
;//*********************************C O D E***************************************
;//===============================================================================	
		ORG			0000H
		GOTO		MainProgram
		ORG			0008H
		GOTO		Interrupt	

;//===============================================================================
;//********************************程序主函数*************************************
;//===============================================================================			
;//------------------------------程序初始化---------------------------------------
MainProgram:
		CALL       	SYSTEM_INIT				;//系统初始化
		CALL       	Clr_RAM_00H_3FH			;//清零RAM
		CALL       	ADC_INIT				;//ADC初始化
;//------------------------------主函数循环---------------------------------------		
MainLoop:
		CLRWDT								;//清除看门狗
		CALL		ADC_DATA_Real
		GOTO		MainLoop

;//===============================================================================
;//******************************中断服务子程序***********************************
;//===============================================================================
;//中断进来	
Interrupt:
		PUSH
		NOP
Interrupt_END:	
;//中断结束
		POP
	    RETIE

;//===============================================================================
;//*********************************ADC初始化*************************************
;//1、端口设置AN0(IOA0)口 输入模式 模拟口
;//2、ADC设置 使能ADC 数据右对齐 输入通道AN0(IOA0) 
;//ADC时钟FCPU/4 参考电压VDD
;//ADC最大运行时钟为1MHz
;//===============================================================================	
ADC_INIT:
;//1、端口设置
		BCLR		OEA,0
		BSET		ANSA,0
;//2、ADC设置
		MOVIA		0x90
		MOVAR		ADCON0
		MOVIA		0x20
		MOVAR		ADCON1
		CLRR		ADCON2
		RETURN

;//===============================================================================
;//**********************************系统初始化***********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO状态为输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//===============================================================================		
SYSTEM_INIT:
;//-----------------------------------------------------------------------           
;//Init Clock		
		MOVIA       b'00000000'
		MOVAR		OSCM
;//Init IO 
        ;//IOA
		MOVIA		0x00
        MOVAR     	PUA			;//0:上拉关闭 1:上拉使能
		MOVAR      	IOA        	;//0:输出低   1:输出高
		MOVAR		PDAB		;//0:下拉关闭 1:下拉使能
		MOVIA      	0xFF    	
        MOVAR      	OEA			;//0:输入     1:输出   	
		;//IOB
        MOVIA      	0x00		    	
        MOVAR      	PUB 	 	
        MOVAR      	IOB
		MOVIA      	0xFF    	
        MOVAR      	OEB
;//------------------------------------------------------------------------      
;//Init Interrupt          
        BCLR       	OPTION,7  		;//1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
		RETURN
		
;//===============================================================================
;//*****************************RAM清零(00H~3FH)******************************
;//RAM清零：RAM区00H~3FH全部清零；
;//===============================================================================				
Clr_RAM_00H_3FH:		
		CLRR		FSR0
Clr_RAM_00H_3FH_Loop:
		MOVIA		0x00
		MOVAR		INDF0
		INCR		FSR0,1
		JBTS1		FSR0,6
		GOTO		Clr_RAM_00H_3FH_Loop
		RETURN
		
;================================ADC采集====================================
;***************************************************************************
#INCLUDE				ADC_WORK.INC

		END

;//******************************END OF FILE*************************************       