/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M8P613_ADC.prj
* File Name          : ADC_WORK.C
* Author             : MASSES CHIP
* Version            : V1.08
* Date               : 2025/08/11
;* Web    			 : www.masses-chip.com
;* FAE               : Luo
;  				 	 : QQ：411680975
********************************************************************************
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例是输入通道AN0(IOA0)的AD(时钟FCPU 参考电压VDD)采集
*连续采十次AD数据去掉最大最小值求平均得出AD值
******************************************************************************/

#include "ZC.h"
#include "MASSESCHIP_DEFINE.H"

unsigned int	R_ADC_Temp;
unsigned int	R_ADC_MAX_DATA;
unsigned int	R_ADC_MIN_DATA;
unsigned int	R_ADC_DATA_Sum;

//*****************************************************************
//取十次的值，去除最大值最小值，剩下的求平均值
//*****************************************************************
void  ADC_DATA_Real(void)
{
	uchar	i;
	R_ADC_MIN_DATA = 0xFFFF;				 		  //最小值赋值
	R_ADC_MAX_DATA = 0x0000;				 		  //最大值赋值
	R_ADC_DATA_Sum = 0x0000;	
	for(i = 0; i < 10; i++)
	{   
		ADS = 1;									  //AD转换
		while(ADS==1);				
		R_ADC_Temp = ADH;
		R_ADC_Temp = R_ADC_Temp << 8;
		R_ADC_Temp = R_ADC_Temp + ADL;
		R_ADC_DATA_Sum = R_ADC_DATA_Sum + R_ADC_Temp; //累加ADC测量数据		
		if(R_ADC_Temp > R_ADC_MAX_DATA)	     		  //判断最大值
		{
			R_ADC_MAX_DATA = R_ADC_Temp;		
		}		
		if(R_ADC_Temp < R_ADC_MIN_DATA)	     		  //判断最小值	
		{
			R_ADC_MIN_DATA = R_ADC_Temp;
		}	
	}
	R_ADC_DATA_Sum = R_ADC_DATA_Sum - R_ADC_MAX_DATA - R_ADC_MIN_DATA;
	R_ADC_DATA_Sum = R_ADC_DATA_Sum >> 3;			  //剩下8组数据平均
}

/*********************************END OF FILE************************************/