;/*******************(ASM) COPYRIGHT 2025 Masses-Chip ******************************
;*Project Name        : M8P613_WDT.prj
;* File Name          : M8P613_WDT.ASM
;* Author             : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web    			  : www.masses-chip.com
;* FAE                : Luo
;  				 	  : QQ：411680975
;********************************************************************************
;*
;*Option:16M/4T,WDT-Enable-288ms,BOR 2.4V 
;*注意：本范例仅供参考，实际应用需评估硬件兼容性
;*说明：本范例是以288ms看门狗唤醒休眠并翻转IOB0口
;******************************************************************************/
;//===============================================================================
;//***********************************头文件**************************************
;//用户不可更改
;//===============================================================================
#INCLUDE	 	ZC.INC

;//===============================================================================
;//******************************定义全局变量*************************************
;//用户可以自行看需求定义变量
;//===============================================================================
;userdata				udata	H'00'
;i						res		1
;j						res		1

;//===============================================================================
;//*********************************C O D E***************************************
;//===============================================================================	
		ORG			0000H
		GOTO		MainProgram
		ORG			0008H
		GOTO		Interrupt	

;//===============================================================================
;//********************************程序主函数*************************************
;//===============================================================================			
;//------------------------------程序初始化---------------------------------------
MainProgram:
		CALL       	SYSTEM_INIT				;//系统初始化
		CALL       	Clr_RAM_00H_3FH			;//清零RAM
		MOVIA		0x05
		MOVAR		OSCM					;//休眠状态下关闭高频低频时钟
;//------------------------------主函数循环---------------------------------------		
MainLoop:	
		CLRWDT								;//清除看门狗
		BSET		OSCM,STOP
		NOP
		NOP
		NOP
		JBTS1		IOB,0
		GOTO		SET_IOB0_1
		GOTO		SET_IOB0_0
SET_IOB0_1:
		BSET		IOB,0
		GOTO		MainLoop
SET_IOB0_0	
		BCLR		IOB,0
		GOTO		MainLoop

;//===============================================================================
;//******************************中断服务子程序***********************************
;//===============================================================================
;//中断进来	
Interrupt:
		PUSH
		NOP
Interrupt_END:	
;//中断结束
		POP
	    RETIE

;//===============================================================================
;//**********************************系统初始化***********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO状态为输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//===============================================================================		
SYSTEM_INIT:
;//-----------------------------------------------------------------------           
;//Init Clock		
		MOVIA       b'00000000'
		MOVAR		OSCM
;//Init IO 
        ;//IOA
		MOVIA		0x00
        MOVAR     	PUA			;//0:上拉关闭 1:上拉使能
		MOVAR      	IOA        	;//0:输出低   1:输出高
		MOVAR		PDAB		;//0:下拉关闭 1:下拉使能
		MOVIA      	0xFF    	
        MOVAR      	OEA			;//0:输入     1:输出   	
		;//IOB
        MOVIA      	0x00		    	
        MOVAR      	PUB 	 	
        MOVAR      	IOB
		MOVIA      	0xFF    	
        MOVAR      	OEB
;//------------------------------------------------------------------------      
;//Init Interrupt          
        BCLR       	OPTION,7  		;//1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
		RETURN

;//===============================================================================
;//*****************************RAM清零(00H~3FH)******************************
;//RAM清零：RAM区00H~3FH全部清零；
;//===============================================================================				
Clr_RAM_00H_3FH:		
		CLRR		FSR0
Clr_RAM_00H_3FH_Loop:
		MOVIA		0x00
		MOVAR		INDF0
		INCR		FSR0,1
		JBTS1		FSR0,6
		GOTO		Clr_RAM_00H_3FH_Loop
		RETURN
		END

;//******************************END OF FILE*************************************        