;/*******************(ASM) COPYRIGHT 2025 Masses-Chip ******************************
;*Project Name        : M8P615_IOA5_INTERRUPT.prj
;* File Name          : M8P615_IOA5_INTERRUPT.ASM
;* Author             : MASSES CHIP
;* Version            : V1.07
;* Date               : 2025/08/11
;* Web    			  : www.masses-chip.com
;* FAE                : Luo
;  				 	  : QQ：411680975
;********************************************************************************
;*
;*Option:16M/4T,WDT-Disable-288ms,BOR 2.4V
;*注意：本范例仅供参考，实际应用需评估硬件兼容性
;*说明：本范例是IOA5为中断源，IOA5变化中断唤醒休眠，翻转IOB0
;******************************************************************************/
;//===============================================================================
;//***********************************头文件**************************************
;//用户不可更改
;//===============================================================================
#INCLUDE	 	ZC.INC

;//===============================================================================
;//******************************定义全局变量*************************************
;//用户可以自行看需求定义变量
;//===============================================================================
userdata				udata	H'00'
R_Flag					res		1
#define B_IOA5_Interrupt_Flag      R_Flag,0              ;//定义标志位

;//===============================================================================
;//*********************************C O D E***************************************
;//===============================================================================	
		ORG			0000H
		GOTO		MainProgram
		ORG			0008H
		GOTO		Interrupt	

;//===============================================================================
;//********************************程序主函数*************************************
;//===============================================================================			
;//------------------------------程序初始化---------------------------------------
MainProgram:
		CALL       	SYSTEM_INIT				;//系统初始化
		CALL       	Clr_RAM_00H_3FH			;//清零RAM
		CALL       	IOA5_Interrupt_INIT		;//IOA5中断初始化
;//------------------------------主函数循环---------------------------------------		
MainLoop:
		BSET		OSCM,STOP
		NOP
		NOP
		NOP
		JBTS1		B_IOA5_Interrupt_Flag
		GOTO		MainLoop
		BCLR		B_IOA5_Interrupt_Flag
		JBTS1		IOB,0
		GOTO		SET_IOB0_1
		GOTO		SET_IOB0_0
SET_IOB0_1:
		BSET		IOB,0
		GOTO		MainLoop
SET_IOB0_0	
		BCLR		IOB,0
		GOTO		MainLoop

;//===============================================================================
;//******************************中断服务子程序***********************************
;//===============================================================================
;//中断进来	
Interrupt:
		PUSH
		NOP
		JBTS1		INTF1,0
		GOTO		Interrupt_END
		BCLR		INTF1,0
		BSET		B_IOA5_Interrupt_Flag
Interrupt_END:	
;//中断结束
		POP
	    RETIE

;//===============================================================================
;//*********************************IOA5初始化*************************************
;//端口设置：IOA5输入模式，数字口，上拉开启
;//IOA5中断设置：IOA5变化中断
;//系统时钟设置：休眠状态下低频、高频振荡器停止工作
;//===============================================================================	
IOA5_Interrupt_INIT:
;//1、端口设置
		BCLR		OEA,5
		BCLR		ANSA,5
		BSET		PUA,5
		
;//2、IOA5设置
		BSET		IOICR,6
		BCLR		INTF1,0
		BSET		INTCR1,0
		BSET       	OPTION,GIE	
		
;//系统时钟设置		
		MOVIA		0x05
		MOVAR		OSCM
		RETURN

;//===============================================================================
;//**********************************系统初始化***********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO状态为输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//===============================================================================		
SYSTEM_INIT:
;//-----------------------------------------------------------------------           
;//Init Clock		
		MOVIA       b'00000000'
		MOVAR		OSCM
;//Init IO 
        ;//IOA
		MOVIA		0x00
        MOVAR     	PUA			;//0:上拉关闭 1:上拉使能
		MOVAR      	IOA        	;//0:输出低   1:输出高
		MOVAR		PDAB		;//0:下拉关闭 1:下拉使能
		MOVIA      	0xFF    	
        MOVAR      	OEA			;//0:输入     1:输出   	
		;//IOB
        MOVIA      	0x00		    	
        MOVAR      	PUB 	 	
        MOVAR      	IOB
		MOVIA      	0xFF    	
        MOVAR      	OEB
;//------------------------------------------------------------------------      
;//Init Interrupt          
        BCLR       	OPTION,7  		;//1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
		RETURN

;//===============================================================================
;//*****************************RAM清零(00H~3FH)******************************
;//RAM清零：RAM区00H~3FH全部清零；
;//===============================================================================				
Clr_RAM_00H_3FH:		
		CLRR		FSR0
Clr_RAM_00H_3FH_Loop:
		MOVIA		0x00
		MOVAR		INDF0
		INCR		FSR0,1
		JBTS1		FSR0,6
		GOTO		Clr_RAM_00H_3FH_Loop
		RETURN
		END

;//******************************END OF FILE*************************************        