;/*******************(ASM) COPYRIGHT 2025 Masses-Chip ******************************
;*Project Name        : M8P615_TC1.prj
;* File Name          : M8P615_TC1.ASM
;* Author             : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web    			  : www.masses-chip.com
;* FAE                : Luo
;  				 	  : QQ：411680975
;********************************************************************************
;*
;*Option:16M/4T,WDT-Enable-288ms,BOR 2.4V 
;*注意：本范例仅供参考，实际应用需评估硬件兼容性
;*说明：本范例以TC1为定时器，每定时1ms(由于自动TC1计数器无法自动重装,定时会有一
;点点偏差)翻转一次IOB0口
;******************************************************************************/
;//===============================================================================
;//***********************************头文件**************************************
;//用户不可更改
;//===============================================================================
#INCLUDE	 	ZC.INC

;//===============================================================================
;//******************************定义全局变量*************************************
;//用户可以自行看需求定义变量
;//===============================================================================
userdata				udata	H'00'
R_Flag					res		1						;//定义变量
#define B_TC0_Interrupt_Flag      R_Flag,0              ;//定义标志位

;//===============================================================================
;//*********************************C O D E***************************************
;//===============================================================================	
		ORG			0000H
		GOTO		MainProgram
		ORG			0008H
		GOTO		Interrupt	

;//===============================================================================
;//********************************程序主函数*************************************
;//===============================================================================			
;//------------------------------程序初始化---------------------------------------
MainProgram:
		CALL       	SYSTEM_INIT				;//系统初始化
		CALL       	Clr_RAM_00H_3FH			;//清零RAM
		CALL       	TC1_INIT				;//TC1初始化
;//------------------------------主函数循环---------------------------------------		
MainLoop:
		CLRWDT								;//清除看门狗
		JBTS1		B_TC0_Interrupt_Flag
		GOTO		MainLoop
		BCLR		B_TC0_Interrupt_Flag
		JBTS1		IOB,0
		GOTO		SET_IOB0_1
		GOTO		SET_IOB0_0
SET_IOB0_1:
		BSET		IOB,0
		GOTO		MainLoop
SET_IOB0_0	
		BCLR		IOB,0
		GOTO		MainLoop

;//===============================================================================
;//******************************中断服务子程序***********************************
;//===============================================================================
;//中断进来	
Interrupt:
		PUSH
		JBTS1		INTF0,TC1IF					
		GOTO		Interrupt_END	
		BCLR		INTF0,TC1IF
		MOVIA		0xFF
		MOVAR		TC1CH
		MOVIA      	0x05
		MOVAR	   	TC1CL
		BSET		B_TC0_Interrupt_Flag
Interrupt_END:	
;//中断结束
		POP
	    RETIE

;//===============================================================================
;//*********************************TC1初始化*************************************
;//TC1设置：16位模式，高频系统时钟，1:64分频
;//t =计数/（时钟/分频）     1ms = （0xFFFF-FF05）/（16/64）
;//开启TC1溢出中断和总中断
;//===============================================================================	
TC1_INIT:
;//1、TC1设置
		MOVIA      	0x4E
		MOVAR	    T1CR		               		
		MOVIA		0xFF
		MOVAR		TC1CH
		MOVIA      	0x05
		MOVAR	   	TC1CL
;//2、中断设置
		BCLR		INTF0,TC1IF							
		BSET		INTCR0,TC1IE
		BSET       	T1CR,7			
		BSET       	OPTION,7				   	   					
		RETURN

;//===============================================================================
;//**********************************系统初始化***********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO状态为输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//===============================================================================		
SYSTEM_INIT:
;//-----------------------------------------------------------------------           
;//Init Clock		
		MOVIA       b'00000000'
		MOVAR		OSCM
;//Init IO 
        ;//IOA
		MOVIA		0x00
        MOVAR     	PUA			;//0:上拉关闭 1:上拉使能
		MOVAR      	IOA        	;//0:输出低   1:输出高
		MOVAR		PDAB		;//0:下拉关闭 1:下拉使能
		MOVIA      	0xFF    	
        MOVAR      	OEA			;//0:输入     1:输出   	
		;//IOB
        MOVIA      	0x00		    	
        MOVAR      	PUB 	 	
        MOVAR      	IOB
		MOVIA      	0xFF    	
        MOVAR      	OEB
;//------------------------------------------------------------------------      
;//Init Interrupt          
        BCLR       	OPTION,7  		;//1:全局中断高优先级中断使能,0:屏蔽全局中断高优先级中断
		RETURN

;//===============================================================================
;//*****************************RAM清零(00H~3FH)******************************
;//RAM清零：RAM区00H~3FH全部清零；
;//===============================================================================				
Clr_RAM_00H_3FH:		
		CLRR		FSR0
Clr_RAM_00H_3FH_Loop:
		MOVIA		0x00
		MOVAR		INDF0
		INCR		FSR0,1
		JBTS1		FSR0,6
		GOTO		Clr_RAM_00H_3FH_Loop
		RETURN
		END

;//******************************END OF FILE*************************************       