/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M8P625_EEPROM.Prj
* File Name          : EEPROM_WRITE_READ.C
* Author             : MASSES CHIP
* Version            : V1.08
* Date               : 2025/08/11
* Web    			 : www.masses-chip.com
* FAE                : Luo
;  				 	 : QQ：411680975
********************************************************************************
*
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例对EEPROM的字节写和读校验
*所有EEPROM都可以进行字节写，EEPROM空间0x800写0x55
*读所写EEROM的内容并校验，若EE读写出错，IOA0置高
*注:EEPROM在进行读写时不允许任何中断的出现
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
#include "ZC.h"
#include "MASSESCHIP_DEFINE.H"

unsigned char R_W_EEP_Data;
extern unsigned char R_EEPROM_Read_Data;
//===============================================================================
//********************************EEPROM字节写***********************************
//EEPROM字节写0x55
//===============================================================================
void EEPROM_Write_Byte(unsigned char W_Data)
{ 
	unsigned char R_Save_Option; 			  	//中断保护
	unsigned char R_Save_Intcr0; 
	unsigned char R_Save_Intcr1; 
	R_Save_Option = OPTION;
	R_Save_Intcr0 = INTCR0;
	R_Save_Intcr1 = INTCR1;
	OPTION = 0x00;						  	  	//关闭所有中断
	INTCR0 = 0x00;
	INTCR1 = 0x00;
	
	FSR1 = 0x08;
	FSR0 = 0x00;	
	R_W_EEP_Data = W_Data;
	__asm;                                		//给累加器ACC赋值调用汇编
	movr		_R_W_EEP_Data,a
    __endasm;
    EEMOD = 1;                            		//读写EE/MTP时需置位
    EEWEN = 1;                            		//使能EE/MTP写入
    EELOCK3 = 1;                          		//EE/MTP写入解锁流程1
    EELOCK2 = 1;                          		//EE/MTP写入解锁流程2
    EELOCK1 = 1;                          		//EE/MTP写入解锁流程3
    EEWE = 1;       	                  		//写入
    __NOP();                              		//CPU暂停，等待EE写入结束
    EEMOD = 0;      	                  		//写完EE，清除该位
	if(WERR == 1)
	{
		IOA0 = 1;
	}	
	OPTION = R_Save_Option;				  //恢复中断
	INTCR0 = R_Save_Intcr0;
	INTCR1 = R_Save_Intcr1;
} 

//===============================================================================
//********************************EEPROM读操作***********************************
//读EEPROM写入的值并将所读的值返回
//===============================================================================
unsigned char EEPROM_Read_Check(void)
{
	FSR1 = 0x08;
	FSR0 = 0x00;
	IOA0 = 0;
	EEMOD = 1;                            //读EE，需置位
	__RDT();
	EEMOD = 0;      	                  //写完EE，清除该位
	__asm;                            
	movar	_R_EEPROM_Read_Data
	__endasm;	
	return(R_EEPROM_Read_Data);
}

/*********************************END OF FILE************************************/  