;*******************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P625_TC0.Prj
;* File Name		  : M8P625_TC0.ASM
;* Author			  : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;
;Option:16M/4T,WDT-Enable-288ms,RST-IO,BOR 2.4V
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;说明：本范例用TC0做定时器，每1ms翻转一次IOA0口
;//******************************************************************************
;//===============================================================================
;//***********************************头文件**************************************
;//用户不可更改
;//===============================================================================
#INCLUDE	 	 ZC.INC

;//===============================================================================
;//******************************定义全局变量*************************************
;//用户可以自行看需求定义变量
;//===============================================================================
userdata 	udata		H'00'
R_Flag		res			1
#define	b_TC0_Flag		R_Flag,0

;//===============================================================================
;//**********************************CODE*****************************************
;//===============================================================================
		ORG			 0000H
		GOTO		 MainProgram
		ORG			 0008H
		GOTO		 Interrupt
	
;//===============================================================================
;//*********************************主函数****************************************
;//主循环每1ms翻转一次IOA0
;//===============================================================================
MainProgram:
		CALL         System_Init           ;//系统初始化
        CALL		 Clr_RAM_00H_7FH       ;//清零RAM		
		CALL         TC0_Init              ;//TC0初始化	 
;//----------------------主函数循环--------------------------------------------	
MainLoop:
		CLRWDT								;//清除看门狗
		JBTS1		b_TC0_Flag
		GOTO		MainLoop
		BCLR		b_TC0_Flag
		JBTS1		IOA,0
		GOTO		Set_IO_H
		BCLR		IOA,0
		GOTO		MainLoop
Set_IO_H:		
		BSET		IOA,0
		GOTO		MainLoop

;//===============================================================================
;//******************************中断处理程序*************************************
;//TC0中断，标志位置高
;//===============================================================================
Interrupt:
		PUSH                               ;//压栈,保存A,STATUS
;//中断处理程序
		JBTS1		INTF0,0
		GOTO		Interrupt_END
		BCLR		INTF0,0
		bset		b_TC0_Flag
Interrupt_END:		          
		POP                                ;//出栈,恢复A,STATUS
		RETIE			      		

;//===============================================================================
;//*********************************TC0初始化*************************************
;//TC0设置：8位模式、高频16M 64分频，定时为1ms
;//t =计数/（时钟/分频）     1ms = （249+1）/（16/64）
;//开启TC0溢出中断和总中断
;//===============================================================================	
TC0_Init:
;//1、TC0设置
		MOVIA		0x0E
		MOVAR		T0CR
		MOVIA		249
		MOVAR		TC0CL
		CLRR		TC0CH
		BSET		T0CR,7
;//2、中断设置
		BCLR		INTF0,0
		BSET		INTCR0,0
		BSET		OPTION,7
		RETURN

;//===============================================================================
;//**********************************系统初始化***********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO状态为输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//===============================================================================		
SYSTEM_INIT:
;//-----------------------------------------------------------------------           
;//SystemInit Clock		      
		MOVIA      	0x00
        MOVAR      	OSCM
;//----------------------------------------------------------------------      
;//Init IO 
		;//IOA
		MOVIA      	0x00    	;//0:上拉关闭 1:上拉使能
        MOVAR      	PUA
        MOVIA      	0xFF    	;//0:输入 1:输出
        MOVAR      	OEA
        MOVIA      	0x00    	;//IO口数据
        MOVAR      	IOA     
        ;//IOB
		MOVIA      	0x00    
        MOVAR      	PUB
        MOVIA      	0xFF	   
        MOVAR      	OEB
        MOVIA      	0x00    	
        MOVAR      	IOB
		;//IOC
		MOVIA      	0x00    	
        MOVAR      	PUC
		MOVIA      	0xFF    
        MOVAR      	OEC
		MOVIA      	0x00    	
        MOVAR      	IOC 
;//----------------------------------------------------------------------      
;//中断设置  				
		BCLR     	OPTION,GIE  ;//1:总中断使能,0:屏蔽所有中断	
		RETURN

;//===============================================================================
;//*******************************RAM清零(00H~7FH)********************************
;//RAM清零：RAM区0000H~007FH全部清零
;//===============================================================================         	
Clr_RAM_00H_7FH:
		CLRR		FSR0   		;//从00地址开始写入
Clr_RAM_00H_7FH_LOOP:	
		MOVIA       0x00
		MOVAR		INDF0
		INCR		FSR0,1
		JBTS1		FSR0,7
		GOTO		Clr_RAM_00H_7FH_LOOP
		RETURN
		END

;//*************************END OF FILE******************************************        