;*******************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P626_ADC.Prj
;* File Name		  : M8P626_ADC.ASM
;* Author			  : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;
;Option:16M/4T,WDT-Enable-288ms,RST-IO,BOR 2.4V 
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;说明：本范例AD采集通道为AIN0(IOA0),时钟源选择为Fcpu/16T，内部参考2V
;采集10次AD值，去掉最大值和最小值，对剩下的AD值求平均,结果存放在R_ADC_DATA_SUM_H、
;R_ADC_DATA_SUM_L中，作为一次AD值
;//******************************************************************************
;//===============================================================================
;//***********************************头文件**************************************
;//用户不可更改
;//===============================================================================
#INCLUDE ZC.INC

;//===============================================================================
;//******************************定义全局变量*************************************
;//用户可以自行看需求定义变量
;//===============================================================================
userdata udata	H'00'
R_ADC_MAX_DATAH		RES		1	
R_ADC_MAX_DATAL		RES		1
R_ADC_MIN_DATAH		RES		1
R_ADC_MIN_DATAL		RES		1
R_ADC_DATA_SUM_L	RES		1
R_ADC_DATA_SUM_H	RES		1
R_Count				RES		1

;//===============================================================================
;//**********************************CODE*****************************************
;//===============================================================================
       ORG       0000H
       GOTO      MainProgram
       ORG       0008H                                                        
	   GOTO      Interrupt

;//===============================================================================
;//*********************************主程序****************************************
;//===============================================================================	
;//-------------------------------程序初始化--------------------------------------	
MainProgram:
       CALL      SYSTEM_INIT	 		;//系统初始化
	   CALL      Clr_RAM_00H_7FH	    ;//清零RAM
	   CALL      ADC_Init				;//ADC初始化
;//--------------------------------主函数循环-------------------------------------
Main_Loop:
	   CLRWDT							;//清除看门狗
	   CALL      ADC_Work				;//数据处理函数 
	   GOTO      Main_Loop

;//===============================================================================
;//******************************中断处理程序*************************************
;//注：没有使能的中断不要判断中断标志位
;//===============================================================================		
Interrupt:
       PUSH        						;//进栈、保存A、STATUS
			
;//中断处理程序	
	   NOP		
			
Interrupt_End:	
       POP                        		;//出栈、恢复A、STATUS			
	   RETIE	   
	   
;//===============================================================================
;//*********************************ADC初始化*************************************
;//ADC设置：选择通道为AIN0，数据格式为高位在前，
;//时钟源选择为Fcpu/16T，内部参考2V
;//ADC最大运行时钟为1MHz
;//===============================================================================	
ADC_INIT:
;//1、IO设置
		BSET		ANSA,0
		BCLR		OEA,0
;//2、ADC设置
		MOVIA		0x90
		MOVAR		ADCON0
		MOVIA		0x45
		MOVAR		ADCON1
		MOVIA		0x00
		MOVAR		ADCON2				   	   					
		RETURN

;//===============================================================================
;//**********************************系统初始化***********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO状态为输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//===============================================================================		
SYSTEM_INIT:
;//-----------------------------------------------------------------------           
;//SystemInit Clock		      
		MOVIA      	0x00
        MOVAR      	OSCM
;//----------------------------------------------------------------------      
;//Init IO 
		;//IOA
		MOVIA      	0x00    	;//0:上拉关闭 1:上拉使能
        MOVAR      	PUA
        MOVIA      	0xFF    	;//0:输入 1:输出
        MOVAR      	OEA
        MOVIA      	0x00    	;//IO口数据
        MOVAR      	IOA     
        ;//IOB
		MOVIA      	0x00    	
        MOVAR      	PUB
        MOVIA      	0xFF	   
        MOVAR      	OEB
        MOVIA      	0x00    
        MOVAR      	IOB
		;//IOC
		MOVIA      	0x00    	
        MOVAR      	PUC
		MOVIA      	0xFF    	
        MOVAR      	OEC
		MOVIA      	0x00    	
        MOVAR      	IOC 
;//----------------------------------------------------------------------      
;//中断设置  				
		BCLR     	OPTION,GIE  ;//1:总中断使能,0:屏蔽所有中断	
		RETURN

;//===============================================================================
;//****************************RAM清零(00H~7FH)***********************************
;//RAM清零：RAM区0000H~007FH全部清零
;//===============================================================================     	
Clr_RAM_00H_7FH:
		CLRR		FSR0   		;//从00地址开始写入
Clr_RAM_00H_7FH_LOOP:	
		MOVIA       0x00
		MOVAR		INDF0
		INCR		FSR0,1
		JBTS1		FSR0,7
		GOTO		Clr_RAM_00H_7FH_LOOP
		RETURN

;//===============================================================================
;//******************************数据处理函数*************************************
;//===============================================================================
#INCLUDE	ADC_work.INC
		END

;*********************************END OF FILE**********************************