;*******************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P626_EEPROM.Prj
;* File Name		  : EEPROM_Write_Read.INC
;* Author			  : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;说明：本范例对EEPROM的字节写和读校验
;所有EEPROM都可以进行字节写，EEPROM空间0x800写0x55
;读所写EEROM的内容并校验，若EE读写出错，IOA0置高
;注：EEPROM在进行读写时不允许任何中断的出现
;//******************************************************************************

;//===============================================================================
;//*********************************EEPROM_Write_Byte*****************************
;//EEPROM字节写，写0x55
;//===============================================================================	
EEPROM_Write_Byte:
		MOVR		OPTION,A			  ;//中断保护
		MOVAR		R_Save_Option
		MOVR		INTCR0,A
		MOVAR		R_Save_Intcr0
		MOVR		INTCR1,A
		MOVAR		R_Save_Intcr1
		CLRR		OPTION				  ;//关闭所有中断
		CLRR		INTCR0
		CLRR      	INTCR1
		
		MOVIA		0x08
		MOVAR		FSR1
		MOVIA		0x00
		MOVAR		FSR0				  ;//EEPROM首地址
		MOVIA		0x55
		BSET		bEEMOD                ;//读写EE/MTP时需置位
		BSET		bEEWEN                ;//使能EE/MTP写入
		BSET		bEELOCK3              ;//EE/MTP写入解锁流程1
		BSET		bEELOCK2              ;//EE/MTP写入解锁流程2
		BSET		bEELOCK1              ;//EE/MTP写入解锁流程3
		BSET		bEEWR                 ;//写入
		NOP                               ;//CPU暂停，等待EE写入结束
		BCLR		bEEMOD                ;//写完EE，清除该位	
		jbts0		bEEWR
		bset		IOA,0
		MOVR		R_Save_Option,A		  ;//恢复中断
		MOVAR		OPTION
		MOVR		R_Save_Intcr0,A
		MOVAR		INTCR0
		MOVR		R_Save_Intcr1,A
		MOVAR		INTCR1
		RETURN	

;//===============================================================================
;//*********************************EEPROM_Read_Check*****************************
;//读EEPROM写入的数据，并校验
;//若读、校验出错，IOA0口置高
;//===============================================================================
EEPROM_Read_Check:
		MOVIA		0x08
		MOVAR		FSR1
		MOVIA		0x00
		MOVAR		FSR0				  ;//EEPROM首地址		
		BCLR		IOA,0
		BSET		bEEMOD                ;//读EE，需置位
		RDT                               ;//读取EE
		BCLR		bEEMOD                ;//清除该位			
		JCMPAI      0x55                  ;//校验是否读写入数据成功
		BSET		IOA,0
		RETURN

;//***********************************END OF FILE********************************* 	