;*******************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P626_EEPROM.Prj
;* File Name		  : M8P626_EEPROM.ASM
;* Author			  : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;
;Option:16M/4T,WDT-Enable-288ms,RST-IO,BOR 2.4V，允许EEPROM写入 
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;说明：本范例对EEPROM的写,读和校验
;所有EEPROM都可以进行字节写，EEPROM空间0x800写0x55
;读所写EEROM的内容并校验，若EE读写出错，IOA0置高
;注：EEPROM在进行读写时不允许任何中断的出现
;//******************************************************************************
;//===============================================================================
;//***********************************头文件**************************************
;//用户不可更改
;//===============================================================================
#INCLUDE	 	ZC.INC

;//===============================================================================
;//******************************定义全局变量*************************************
;//用户可以自行看需求定义变量
;//===============================================================================
userdata	udata		H'00'
R_Save_Option			res			1
R_Save_Intcr0		 	res			1
R_Save_Intcr1		 	res			1

;//===============================================================================
;//*********************************C O D E***************************************
;//===============================================================================
			ORG			0000H
			GOTO		MAIN_PROGRAM
			ORG			0008H
			GOTO		Interrupt

;//===============================================================================
;//*********************************主函数****************************************
;//===============================================================================
;//-------------------------------程序初始化--------------------------------------
MAIN_PROGRAM:
            CALL        SYSTEM_INIT               ;//系统初始化
	        CALL        Clr_RAM_00H_7FH           ;//清零RAM	
Main_Loop:
			CLRWDT								  ;//清除看门狗
            CALL        EEPROM_Write_Byte         ;//EEPROM写
			CALL		EEPROM_Read_Check		  ;//EEPROM读和校验
	        GOTO        Main_Loop

;//===============================================================================
;//******************************中断处理程序*************************************
;//注：没有使能的中断不要判断中断标志位
;//===============================================================================
Interrupt:
            PUSH        ;//进栈、保存A、STATUS
;//中断处理程序
		    NOP	
Interrupt_End:		
            POP         ;//出栈、恢复A、STATUS
		    RETIE

;//===============================================================================
;//**********************************系统初始化***********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO状态为输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//===============================================================================		
SYSTEM_INIT:
;//-----------------------------------------------------------------------           
;//SystemInit Clock		      
		MOVIA      	0x00
        MOVAR      	OSCM
;//----------------------------------------------------------------------      
;//Init IO 
		;//IOA
		MOVIA      	0x00    	;//0:上拉关闭 1:上拉使能
        MOVAR      	PUA
        MOVIA      	0xFF    	;//0:输入 1:输出
        MOVAR      	OEA
        MOVIA      	0x00    	;//IO口数据
        MOVAR      	IOA     
        ;//IOB
		MOVIA      	0x00    	
        MOVAR      	PUB
        MOVIA      	0xFF	 
        MOVAR      	OEB
        MOVIA      	0x00    
        MOVAR      	IOB
		;//IOC
		MOVIA      	0x00    	
        MOVAR      	PUC
		MOVIA      	0xFF    	
        MOVAR      	OEC
		MOVIA      	0x00    	
        MOVAR      	IOC 
;//----------------------------------------------------------------------      
;//中断设置  				
		BCLR     	OPTION,GIE  ;//1:总中断使能,0:屏蔽所有中断	
		RETURN

;//===============================================================================
;//*******************************RAM清零(00H~7FH)********************************
;//RAM清零：RAM区0000H~007FH全部清零
;//===============================================================================       	
Clr_RAM_00H_7FH:
		CLRR		FSR0   		;//从00地址开始写入
Clr_RAM_00H_7FH_LOOP:	
		MOVIA       0x00
		MOVAR		INDF0
		INCR		FSR0,1
		JBTS1		FSR0,7
		GOTO		Clr_RAM_00H_7FH_LOOP
		RETURN			

#include	EEPROM_Write_Read.INC
			END

;//*******************************END OF FILE****************************** 