;*******************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P626_I2C.Prj
;* File Name		  : I2C_SLAVE.INC
;* Author			  : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;说明：本范例为IIC从机接收模式,	从机器件地址为0xA0
;SDA为IOB1，SCL为IOB0
;包括主设备对从设备的写操作和主设备读取从设备的数据
;主设备写入数据存在主设备指定的Ram地址中
;主设备可以读取从设备指定Ram地址中的数据
;//******************************************************************************


;//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;//	判断主机是读还是写
I2C_SLAVE_SSPINT: 
		JBTS1       I2CCON,R_W
        GOTO        I2CMasterWrite		  
        GOTO        I2CMasterRead

;//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;//	判断主机是发送地址还是数据        
I2CMasterWrite:
		JBTS0       I2CCON,D_A
		GOTO        I2C_D_A_Send_data		  	
;//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;//	主机向从机写器件地址，读取I2CBUF	  
		MOVR		I2CBUF,A
		BSET		R_I2Cflag,B_FirstByte_Flag		
		GOTO		Interrupt_End  
;//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;//	主机向从机写地址
I2C_D_A_Send_data:		
		JBTS1		R_I2Cflag,B_FirstByte_Flag ;//软件设标志判断
	    GOTO		I2C_GetData
		MOVR		I2CBUF,A
		MOVAR       R_SlaveBuffAddr
        BCLR		R_I2Cflag,B_FirstByte_Flag
		GOTO		Interrupt_End
		  
;//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;//	主机向从机写数据，读取I2CBUF，写入缓冲区，缓冲区地址+1	  
I2C_GetData:
		MOVR		R_SlaveBuffAddr,A
		MOVAR 		FSR0
		MOVR 		I2CBUF,A
		MOVAR		INDF0
		INCR 		R_SlaveBuffAddr,R		
		GOTO		Interrupt_End  

;//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;//	主机向从机读数据
I2CMasterRead:
		JBTS0       I2CCON,NACK
		GOTO        I2C_NACK_1		  
		GOTO        I2C_NACK_0    
;//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;//	读取缓冲区数据，写入I2CBUF，缓冲区地址+1	  		  
I2C_NACK_0:	
		MOVR		R_SlaveBuffAddr,A
		MOVAR		FSR0
		MOVR		INDF0,A
		MOVAR		I2CBUF
		INCR 		R_SlaveBuffAddr,R
		GOTO		Interrupt_End  
			  
;//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;//	写入I2CBUF，缓冲区地址 -1（上次写入缓冲区的数据未发送）  		  
I2C_NACK_1:		
		DECR 		R_SlaveBuffAddr,R
		MOVAR		I2CBUF
		GOTO		Interrupt_End 

;//*********************************END OF FILE*******************************