;*******************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P626_I2C.Prj
;* File Name		  : M8P626_I2C.ASM
;* Author			  : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;
;Option:16M/4T,WDT-Disable-288ms,RST-IO,BOR 2.4V 
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;说明：本范例为IIC从机接收模式,从机器件地址为0xA0
;SDA为IOB1，SCL为IOB0
;包括主设备对从设备的写操作和主设备读取从设备的数据
;主设备写入数据存在主设备指定的Ram地址中
;主设备可以读取从设备指定Ram地址中的数据
;//******************************************************************************
;//===============================================================================
;//***********************************头文件**************************************
;//用户不可更改
;//===============================================================================
#INCLUDE	 	 ZC.INC

;//===============================================================================
;//******************************定义全局变量*************************************
;//用户可以自行看需求定义变量
;//===============================================================================
userdata 	udata		H'00'
R_SlaveBuffAddr			RES		1	;//数据地址
R_I2Cflag				RES		1	;//软件标志
SFSR0					RES		1	
#DEFINE	B_FirstByte_Flag		2

;//===============================================================================
;//*********************************C O D E***************************************
;//===============================================================================
		ORG			0000H
		GOTO		Main_Program
		ORG			0008H
		GOTO		Interrupt

;//===============================================================================
;//*********************************主程序****************************************
;//===============================================================================		
;//-------------------------------程序初始化--------------------------------------	
Main_Program:
		CALL        System_Init         ;//系统初始化
		CALL		Clr_RAM_00H_7FH     ;//清零RAM
		CALL		I2C_Init            ;//I2C初始化
		 
;//-------------------------------主函数循环--------------------------------------
Main_Loop:
		CLRWDT							;//清除看门狗
		GOTO		Main_Loop		

;//===============================================================================
;//******************************中断处理程序*************************************
;//注：没有使能的中断不要判断中断标志位
;//===============================================================================	
;//中断进来
Interrupt:
		PUSH 		                    ;//进栈、保存A、STATUS
;//中断处理程序
		MOVR 		FSR0,A				;//保存FSR0
		MOVAR 		SFSR0               ;//中断中用到 FSR0，保护
		JBTS0		INTF0,I2CIF
        GOTO		I2C_SLAVE_SSPINT		
		NOP
Interrupt_End:		
;//中断结束
		MOVR		SFSR0,A				;//恢复FSR0
		MOVAR		FSR0			    ;//中断中用到 FSR0，保护
		POP                             ;//出栈、恢复A、STATUS
		RETIE	 

;//===============================================================================
;//*********************************IIC初始化*************************************
;//SDA为IOB1，SCL为IOB0选择A组总线
;//开启IIC接收中断
;//===============================================================================	
I2C_Init:
;//1、IO端口设置  		
		BSET		PUB,0
		BSET		PUB,1
		BCLR		OEB,0
		BCLR		OEB,1
;//2、设置串行通讯功能
		MOVIA		0x80
		MOVAR		I2CCON	
;//3、设置从机模式
		MOVIA		0xA0
		MOVAR		I2CADR
;//4、中断使能设置			
		BCLR		INTF0,I2CIF			;//清中断标志
        BSET		INTCR0,I2CIE
		CLRR		INTF0	
		BSET 		OPTION,GIE
		RETURN	

;//===============================================================================
;//**********************************系统初始化***********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO状态为输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//===============================================================================		
SYSTEM_INIT:
;//-----------------------------------------------------------------------           
;//SystemInit Clock		      
		MOVIA      	0x00
        MOVAR      	OSCM
;//----------------------------------------------------------------------      
;//Init IO 
		;//IOA
		MOVIA      	0x00    	;//0:上拉关闭 1:上拉使能
        MOVAR      	PUA
        MOVIA      	0xFF    	;//0:输入 1:输出
        MOVAR      	OEA
        MOVIA      	0x00    	;//IO口数据
        MOVAR      	IOA     
        ;//IOB
		MOVIA      	0x00    	
        MOVAR      	PUB
        MOVIA      	0xFF	   
        MOVAR      	OEB
        MOVIA      	0x00    	
        MOVAR      	IOB
		;//IOC
		MOVIA      	0x00    	
        MOVAR      	PUC
		MOVIA      	0xFF    	
        MOVAR      	OEC
		MOVIA      	0x00    	
        MOVAR      	IOC 
;//----------------------------------------------------------------------      
;//中断设置  				
		BCLR     	OPTION,GIE  ;//1:总中断使能,0:屏蔽所有中断	
		RETURN

;//===============================================================================
;//****************************RAM清零(00H~7FH)***********************************
;//RAM清零：RAM区0000H~007FH全部清零
;//===============================================================================      	
Clr_RAM_00H_7FH:
		CLRR		FSR0   		;//从00地址开始写入
Clr_RAM_00H_7FH_LOOP:	
		MOVIA       0x00
		MOVAR		INDF0
		INCR		FSR0,1
		JBTS1		FSR0,7
		GOTO		Clr_RAM_00H_7FH_LOOP
		RETURN	

;//===============================================================================
;//********************************I2C_SLAVE**************************************
;//===============================================================================
#INCLUDE	I2C_SLAVE.INC
		END

;**********************************END OF FILE*********************************