/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : I2C_SALVE.Prj
* File Name          : I2C_SALVE.C
* Author             : MASSES CHIP
* Version            : V1.08
* Date               : 2025/08/11
* Web    			 : www.masses-chip.com
* FAE                : Luo
;  				 	 : QQ：411680975
********************************************************************************
*
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例为IIC从机接收模式,从机器件地址为0xA0
*SDA为IOB1，SCL为IOB0
*包括主设备对从设备的写操作和主设备读取从设备的数据
*主设备写入数据存在主设备指定的Ram地址中
*主设备可以读取从设备指定Ram地址中的数据
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
//用户不可更改
#include "ZC.h"
#include "MASSESCHIP_DEFINE.h"

//===============================================================================
//用户可以自行更改
volatile unsigned  char   R_I2CData;             
volatile unsigned  char   R_SlaveBuffAddr;//数据地址
volatile ob8 R_I2CFlag;
#define B_FirstByte_Flag  R_I2CFlag.b0 

//===============================================================================
//******************************** 主机读数据 ***********************************
//===============================================================================
void  I2CMasterRead(void)
{  
	if(NACK == 1)					
    {
		R_SlaveBuffAddr --;				//写入I2CBUF，缓冲区地址 -1（上次写入缓冲区的数 据未发送）
		I2CBUF = INDF0;
	}
	else
	{	
		FSR0 = R_SlaveBuffAddr;
		I2CBUF = INDF0;			
		R_SlaveBuffAddr ++;				//读取缓冲区数据，写入 I2CBUF，缓冲区地址+1
	}		
}

//===============================================================================
//*********************************主机写数据************************************
//===============================================================================
void  I2CMasterWrite(void)
{  	

	if(D_A == 0)
    {	
		R_I2CData = I2CBUF;				//读取I2CBUF
		B_FirstByte_Flag = 1;
	}
	else
	{	
		if(B_FirstByte_Flag == 1)		//软件设标志判断FirstData
		{
			R_SlaveBuffAddr = I2CBUF;	//读取I2CBUF，写入缓冲区地址寄存器
			B_FirstByte_Flag = 0;
		}
		else
		{
			FSR0 = R_SlaveBuffAddr;	
			INDF0 = I2CBUF;				//读取I2CBUF，写入缓冲区，缓冲区地址+1
			R_SlaveBuffAddr ++;
		}
    }	
}

/*********************************END OF FILE************************************/ 