;*******************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P626_PWM1.Prj
;* File Name		  : M8P626_PWM1.ASM
;* Author			  : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;
;Option:16M/4T,WDT-Enable-288ms,RST-IO,BOR 2.4V 
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;说明：本范例以TC1为时基，产生1KHz占空比为50%的方波
;开启前后死区，前后死区宽度为2us =1*(64/16M/2)
;PWM1开启100ms，关闭100ms
;PWM1输出端口为IOA0,IOA1
;//******************************************************************************
;//===============================================================================
;//***********************************头文件**************************************
;//用户不可更改
;//===============================================================================
#INCLUDE	 	ZC.INC

;//===============================================================================
;//******************************定义全局变量*************************************
;//用户可以自行看需求定义变量
;//===============================================================================
userdata	udata		H'00'
R_Delay_Count		res			1
R_Delay_Count_1		res			1
R_Delay_Count_2		res			1

;//===============================================================================
;//************************************CODE***************************************
;//===============================================================================
		ORG			0000H
		GOTO		MainProgram
		ORG			0008H
		GOTO		Interrupt

;//===============================================================================
;//***********************************主程序**************************************
;//===============================================================================
;//---------------------------------程序初始化------------------------------------	
MainProgram:
		CALL		System_Init           	;//系统初始化
		CALL		Clr_RAM_00H_7FH       	;//清零RAM
		CALL		PWM1_Init		      	;//PWM1初始化
;//---------------------------------主函数循环------------------------------------		
MainLoop:
		CLRWDT								;//清除看门狗
		BSET		PWM1CR,6				;//PWM1P
		BSET		PWM1CR,5				;//PWM1N
		CALL		Delay_100ms
		BCLR		PWM1CR,6
		BCLR        PWM1CR,5
		CALL		Delay_100ms		
		GOTO		MainLoop

;//===============================================================================
;//********************************中断处理程序***********************************
;//注:没有使能的中断不要判断中断标志位
;//===============================================================================				
Interrupt:
		PUSH								;//压栈,保存A,STATUS
;//中断处理程序
		NOP
Interrupt_End:
		POP									;//出栈，恢复A,STATUS
		RETIE					      		

;//===============================================================================
;//******************************延时处理程序*************************************
;//===============================================================================
Delay_100ms:
		MOVIA		3
		MOVAR		R_Delay_Count
Delay_100ms_1:	
		MOVIA		200
		MOVAR		R_Delay_Count_1
Delay_100ms_2:		
		MOVIA		220
		MOVAR		R_Delay_Count_2
Delay_100ms_3:		
		DJZR		R_Delay_Count_2,1
		GOTO		Delay_100ms_3
Delay_100ms_4:
		DJZR		R_Delay_Count_1,1
		GOTO		Delay_100ms_2
		DJZR		R_Delay_Count,1
		GOTO		Delay_100ms_1
		RETURN
;//===============================================================================
;//**********************************PWM1初始化***********************************
;//PWM1输出口为IOA0,IOA1
;//以TC1作为时基产生1KHz占空比为50%的方波
;//开启前后死区，前后死区宽度为2us =1*(64/16M/2)
;//===============================================================================	
PWM1_Init:
;//1、IO端口设置		
		BSET		OEA,0
		BSET		OEA,1
;//2、时钟源设置(以TC0为例,使其产生1KHz的波形)
		MOVIA		0x0E
		MOVAR		T1CR
		CLRR		TC1CH
		MOVIA		249
		MOVAR		TC1CL
;//3、PWM1设置		
		MOVIA		0x00
		MOVAR		PWM1CR
		MOVIA		0x01
		MOVAR		PWM1S
		CLRR		PWM1DL
		MOVIA		125
		MOVAR		PWM1DH
;//4、开启死区		
		MOVIA		0x11
		MOVAR		PWMDEADT
;//5、使能PWM1	
		BSET		T1CR,7
		BSET		PWM1CR,7
		RETURN

;//===============================================================================
;//**********************************系统初始化***********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO状态为输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//===============================================================================		
SYSTEM_INIT:
;//-----------------------------------------------------------------------           
;//SystemInit Clock		      
		MOVIA      	0x00
        MOVAR      	OSCM
;//----------------------------------------------------------------------      
;//Init IO 
		;//IOA
		MOVIA      	0x00    	;//0:上拉关闭 1:上拉使能
        MOVAR      	PUA
        MOVIA      	0xFF    	;//0:输入 1:输出
        MOVAR      	OEA
        MOVIA      	0x00    	;//IO口数据
        MOVAR      	IOA
        ;//IOB
		MOVIA      	0x00    
        MOVAR      	PUB
        MOVIA      	0xFF	   
        MOVAR      	OEB
        MOVIA      	0x00    
        MOVAR      	IOB
		;//IOC
		MOVIA      	0x00    
        MOVAR      	PUC
		MOVIA      	0xFF    	
        MOVAR      	OEC
		MOVIA      	0x00    	
        MOVAR      	IOC 
;//----------------------------------------------------------------------      
;//中断设置  				
		BCLR     	OPTION,GIE  ;//1:总中断使能,0:屏蔽所有中断	
		RETURN

;//===============================================================================
;//******************************RAM清零(00H~7FH)*********************************
;//RAM清零：RAM区0000H~007FH全部清零
;//===============================================================================      	
Clr_RAM_00H_7FH:
		CLRR		FSR0   		;//从00地址开始写入
Clr_RAM_00H_7FH_LOOP:	
		MOVIA       0x00
		MOVAR		INDF0
		INCR		FSR0,1
		JBTS1		FSR0,7
		GOTO		Clr_RAM_00H_7FH_LOOP
		RETURN
		END

;//*********************************END OF FILE********************************** 