/*******************(C) COPYRIGHT 2025 Masses-Chip ******************************
*Project Name        : M8P626_PWM1.Prj
* File Name          : M8P626_PWM1.C
* Author             : MASSES CHIP
* Version            : V1.08
* Date               : 2025/08/11
* Web    			 : www.masses-chip.com
* FAE                : Luo
;  				 	 : QQ：411680975
********************************************************************************
*
*Option:16M/4T,WDT-Enable-288ms,RST-IO,BOR 2.4V 
*注意：本范例仅供参考，实际应用需评估硬件兼容性
*说明：本范例以TC1为时基，产生1KHz占空比为50%的方波
*开启前后死区，前后死区宽度为2us =1*(64/16M/2)
*PWM开启100ms，关闭100ms
*PWM1输出端口为IOA0,IOA1
******************************************************************************/
//===============================================================================
//*******************************头文件和调用申明********************************
//===============================================================================
#include "ZC.h"
#include "MASSESCHIP_DEFINE.h"

//-------------------------------------------------------------------------------
//用户可以自行更改
void System_Init(void);
void Clr_RAM_00H_7FH(void);
void PWM1_Init(void);
void Delay_100ms(void);

//===============================================================================
//******************************中断特殊函数保护*********************************
/* 如果主程序和中断都用到特殊函数时（例：有变量的乘除法、传参和数组等需要读取或
写入通用指针指向的字节操作），那么在进中断前需要对编译器的临时性寄存器保存。 */
//===============================================================================
#define			Save_Special_Function		1		//中断使用特殊函数时必须置“1”

//如果主程序和中断都用到数组、指针、查表时，需对所用寄存器保存
#define			Save_Fsr					1		//中断使用寻址时必须置“1”

//===============================================================================
//**********************************定义变量*************************************
//用户可以自行看需求定义变量
//===============================================================================
#ifdef	Save_Special_Function
u8 R_Save_Stk00,R_Save_Stk01,R_Save_Stk02,R_Save_Stk03,R_Save_Stk04,R_Save_Stk05;
u8 R_Save_Stk06,R_Save_Stk07,R_Save_Stk08,R_Save_Stk09,R_Save_Stk10,R_Save_Stk11;
#endif
 
#ifdef	Save_Fsr
u8 R_Save_Fsr0;
u8 R_Save_Fsr1;
u8 R_Save_Hbuf;
#endif

volatile unsigned char 	R_Delay_Count;
volatile unsigned char 	R_Delay_Count_1;
volatile unsigned char 	R_Delay_Count_2;

//===============================================================================
//********************************程序主函数*************************************
//===============================================================================
void main(void)				   		//程序主函数
{
	System_Init();               		//系统初始化
	Clr_RAM_00H_7FH();           		//清零RAM
	PWM1_Init();				   		//PWM1初始化
	while(1) 
	{ 
		__CLRWDT();		     			//清除看门狗
		PWM1POE = 1;
		PWM1NOE = 1;
		Delay_100ms();
		PWM1POE = 0;
		PWM1NOE = 0;
		Delay_100ms();
	}
}

//===============================================================================
//******************************中断服务子程序***********************************
//******************注:没有使能的中断不要判断中断标志位**************************
//===============================================================================
void int_isr(void) __interrupt	 	//中断处理函数
{
    __PUSH();                		//进栈（保存A, STATUS）

//---------------------------------------
// 备份关键寄存器，若中断中确保没用到，可删除对应代码，这样可节约寄存器
#ifdef	Save_Special_Function	 							//保存中断中使用库中特殊函数产生的临时寄存器
__asm;
	MOVR		STK00,0
	MOVAR		_R_Save_Stk00
	MOVR		STK01,0
	MOVAR		_R_Save_Stk01
	MOVR		STK02,0
	MOVAR		_R_Save_Stk02
	MOVR		STK03,0
	MOVAR		_R_Save_Stk03
	MOVR		STK04,0
	MOVAR		_R_Save_Stk04
	MOVR		STK05,0
	MOVAR		_R_Save_Stk05
	MOVR		STK06,0
	MOVAR		_R_Save_Stk06
	MOVR		STK07,0
	MOVAR		_R_Save_Stk07
	MOVR		STK08,0
	MOVAR		_R_Save_Stk08
	MOVR		STK09,0
	MOVAR		_R_Save_Stk09
	MOVR		STK10,0
	MOVAR		_R_Save_Stk10
	MOVR		STK11,0
	MOVAR		_R_Save_Stk11
__endasm;
#endif

#ifdef	Save_Fsr	 										//保存中断寻址指针FSR0、FSR1、HBUF
	R_Save_Fsr0 = FSR0;
	R_Save_Fsr1 = FSR1;
	R_Save_Hbuf = HBUF;
#endif
//---------------------------------------
	
//中断处理函数
    __NOP();

//---------------------------------------
// 备份关键寄存器，若中断中确保没用到，可删除对应代码，这样可节约寄存器
#ifdef	Save_Special_Function	 							//恢复中断中使用库中特殊函数产生的临时寄存器
__asm;
	MOVR		_R_Save_Stk00,0
	MOVAR		STK00
	MOVR		_R_Save_Stk01,0
	MOVAR		STK01
	MOVR		_R_Save_Stk02,0
	MOVAR		STK02
	MOVR		_R_Save_Stk03,0
	MOVAR		STK03
	MOVR		_R_Save_Stk04,0
	MOVAR		STK04
	MOVR		_R_Save_Stk05,0
	MOVAR		STK05
	MOVR		_R_Save_Stk06,0
	MOVAR		STK06
	MOVR		_R_Save_Stk07,0
	MOVAR		STK07
	MOVR		_R_Save_Stk08,0
	MOVAR		STK08
	MOVR		_R_Save_Stk09,0
	MOVAR		STK09
	MOVR		_R_Save_Stk10,0
	MOVAR		STK10
	MOVR		_R_Save_Stk11,0
	MOVAR		STK11
__endasm;
#endif

#ifdef	Save_Fsr	 										//恢复中断寻址指针FSR0、FSR1、HBUF
	FSR0 = R_Save_Fsr0;
	FSR1 = R_Save_Fsr1;
	HBUF = R_Save_Hbuf;	
#endif
//---------------------------------------

	__POP();                 		//出栈（恢复A, STATUS）
}

//===============================================================================
//*********************************PWM1初始化***********************************
//PWM1输出口为IOA1,IOA0
//以TC1作为时基产生1KHz占空比为50%的方波
//开启前后死区，前后死区宽度为2us =1*(64/16M/2)
//===============================================================================
void PWM1_Init(void)
{
//1、IO端口设置
	OEA0 = 1;
	OEA1 = 1;
//2、时钟源设置(以TC1为例,使其产生1KHz的波形)
	T1CR = 0x0E;
	TC1CH = 0;
	TC1CL = 249;
//3、PWM1设置
	PWM1CR = 0x00;
	PWM1S = 0x01;
	PWM1DL = 0;
	PWM1DH = 125;
//4、开启死区
	PWM1DEAD = 0x11;
//5、使能PWM1			
	TC1EN = 1;
	PWM1EN = 1;

}

//===============================================================================
//**************************延时处理函数*****************************************
//延时100ms
//===============================================================================
void Delay_100ms(void)
{
	for(R_Delay_Count=2;R_Delay_Count>0;R_Delay_Count--)
	{
		for(R_Delay_Count_1=172;R_Delay_Count_1>0;R_Delay_Count_1--)
		{
			for(R_Delay_Count_2=190;R_Delay_Count_2>0;R_Delay_Count_2--);
		}
	}
}

//===============================================================================
//**********************************系统初始化***********************************
//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
//IO初始化:设置IO状态为输出低，且关闭上下拉
//中断总开关：关闭总开关
//===============================================================================	
void System_Init(void)
{
//----------------------------------------------------
//Init 系统时钟
	OSCM = 0x00;
//----------------------------------------------------	    
//Init IO             
	//IOA
	PUA = 0x00;					//0:上拉关闭 1:上拉使能
	OEA = 0xFF;					//0:输入 1:输出 
    IOA = 0x00;					//IO口数据   
	//IOB
	PUB = 0x00;					
    OEB = 0xFF;					 
    IOB = 0x00;					
	//IOC
	PUC = 0x00;					
	OEC = 0xFF;					  
    IOC = 0x00;					
//----------------------------------------------------
//中断设置
	GIE = 0;					//1:总中断使能,0:屏蔽所有中断
}

//===============================================================================
//*******************************RAM清零(00H~7FH)********************************
//RAM清零：RAM区0000H~007FH全部清零
//===============================================================================
void Clr_RAM_00H_7FH()
{
    __asm;
	Clr_RAM_00H_7FH:
		CLRR		FSR0		//从00地址开始写入
	Clr_RAM_00H_7FH_LOOP:	
		MOVIA       0x00
		MOVAR		INDF0
		INCR		FSR0,1
		JBTS1		FSR0,7
		GOTO		Clr_RAM_00H_7FH_LOOP
    __endasm; 
}

/*********************************END OF FILE************************************/