;*******************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P626_USART.Prj
;* File Name		  : M8P626_USART.ASM
;* Author			  : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;
;Option:16M/4T,WDT-Enable-288ms,RST-IO,BOR 2.4V 
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;说明：本范例以异步串口通讯，数据长度为8位，串口波特率为38400
;TX端口为IOB3，RX端口为IOB4
;每隔100ms串口发送一字节数据，串口接收数据放在寄存器R_Receive_Data中
;接收到有错误的数据放在寄存器R_Receive_Data_Err中
;//******************************************************************************
;//===============================================================================
;//***********************************头文件**************************************
;//用户不可更改
;//===============================================================================
#INCLUDE ZC.INC

;//===============================================================================
;//******************************定义全局变量*************************************
;//用户可以自行看需求定义变量
;//===============================================================================
userdata	udata       H'00'		
R_Receive_Data		res		1
R_Receive_Data_Err	res		1
R_Delay_Count		res		1
R_Delay_Count_1		res		1
R_Delay_Count_2		res		1

;//===============================================================================
;//**********************************C O D E**************************************
;//===============================================================================
		ORG			0000H
		GOTO		Main_Program
		ORG			0008H
		GOTO		Interrupt

;//===============================================================================
;//***********************************主程序**************************************
;//===============================================================================		
;//---------------------------------程序初始化------------------------------------	
Main_Program:		
	    CALL		system_Init				;//系统初始化
		CALL		Clr_RAM_00H_7FH		    ;//RAM清零
		CALL		USART_Init				;//USART初始化
;//---------------------------------主函数循环------------------------------------
Main_Loop:
		CLRWDT								;//清除看门狗
		CALL		Delay_100ms
		CALL		Usaart_Send_Byte
	    GOTO		Main_Loop

;//===============================================================================
;//********************************中断处理程序***********************************
;//注：没有使能的中断不要判断中断标志位
;//===============================================================================				
;//中断进来		
Interrupt:
        PUSH        						;//进栈、保存A、STATUS
        ;//中断处理程序
		JBTS1  		INTF0,RXIF      		;//判断中断标志RXIF
		GOTO        Interrupt_End         		
		JBTS0		RXCR,1
		GOTO		Receive_Err
		MOVR		RXREG,A
		MOVAR		R_Receive_Data
		GOTO		Interrupt_End
Receive_Err:
		MOVR		RXREG,A
		MOVAR		R_Receive_Data_Err
Interrupt_End:		
;//中断结束
		POP         						;//出栈、恢复A、STATUS
		RETIE	 

;//===============================================================================
;//******************************延时处理程序*************************************
;//===============================================================================
Delay_100ms:
		MOVIA		3
		MOVAR		R_Delay_Count
Delay_100ms_1:	
		MOVIA		200
		MOVAR		R_Delay_Count_1
Delay_100ms_2:		
		MOVIA		220
		MOVAR		R_Delay_Count_2
Delay_100ms_3:		
		DJZR		R_Delay_Count_2,1
		GOTO		Delay_100ms_3
Delay_100ms_4:
		DJZR		R_Delay_Count_1,1
		GOTO		Delay_100ms_2
		DJZR		R_Delay_Count,1
		GOTO		Delay_100ms_1
		RETURN

;//===============================================================================
;//******************************Usart发送子程序**********************************
;//Usart发送数据
;//发送一个字节数据
;//===============================================================================
Usaart_Send_Byte:
		MOVIA		0x12
		MOVAR		TXREG
		JBTS1		TXCR,6
		GOTO		$-1
		RETURN

;//===============================================================================
;//********************************Usart初始化************************************
;//Usart设置:异步模式，数据长度为8，串口波特率为38400
;//RX口设置为输入，上拉,开启串口接收中断
;//===============================================================================	
Usart_Init:
;//1.端口设置
;//IOB3   TX
;//IOB4   RX
		BSET		OEB,3	
		BCLR		OEB,4
		BSET		PUB,4
;//2.TXCR 设置	
		MOVIA		0x80	
		MOVAR		TXCR
;//3.RXCR 设置	
		MOVIA		0x80		
		MOVAR		RXCR
;//4.波特率设置
		MOVIA		0x00
	    MOVAR		BRGDH
	    MOVIA		0x67		
	    MOVAR		BRGDL		 
; ;//串口中断 
        BCLR		INTF0,RXIF   
		BCLR		INTF0,TXIF   
		BSET		INTCR0,RXIE   
        BCLR		INTCR0,TXIE	 
		BSET		OPTION,GIE    
		RETURN

;//===============================================================================
;//**********************************系统初始化***********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO状态为输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//===============================================================================		
SYSTEM_INIT:
;//-----------------------------------------------------------------------           
;//SystemInit Clock		      
		MOVIA      	0x00
        MOVAR      	OSCM
;//----------------------------------------------------------------------      
;//Init IO 
		;//IOA
		MOVIA      	0x00    	;//0:上拉关闭 1:上拉使能
        MOVAR      	PUA
        MOVIA      	0xFF    	;//0:输入 1:输出
        MOVAR      	OEA
        MOVIA      	0x00    	;//IO口数据
        MOVAR      	IOA     
        ;//IOB
		MOVIA      	0x00    
        MOVAR      	PUB
        MOVIA      	0xFF	  
        MOVAR      	OEB
        MOVIA      	0x00    
        MOVAR      	IOB
		;//IOC
		MOVIA      	0x00  
        MOVAR      	PUC
		MOVIA      	0xFF    
        MOVAR      	OEC
		MOVIA      	0x00    
        MOVAR      	IOC
;//----------------------------------------------------------------------      
;//中断设置  				
		BCLR     	OPTION,GIE  ;//1:总中断使能,0:屏蔽所有中断	
		RETURN

;//===============================================================================
;//******************************RAM清零(00H~7FH)*********************************
;//RAM清零：RAM区0000H~007FH全部清零
;//===============================================================================        	
Clr_RAM_00H_7FH:
		CLRR		FSR0   		;//从00地址开始写入
Clr_RAM_00H_7FH_LOOP:	
		MOVIA       0x00
		MOVAR		INDF0
		INCR		FSR0,1
		JBTS1		FSR0,7
		GOTO		Clr_RAM_00H_7FH_LOOP
		RETURN
		END

;//*********************************END OF FILE**********************************