;*******************(ASM) COPYRIGHT 2025 Masses-Chip ****************************
;* Project Name		  : M8P626_WDT.Prj
;* File Name		  : M8P626_WDT.ASM
;* Author			  : MASSES CHIP
;* Version            : V1.08
;* Date               : 2025/08/11
;* Web				  : www.masses-chip.com
;* FAE				  : Luo
;					  : QQ：411680975
;//******************************************************************************
;
;Option:16M/4T,WDT-Enable-288ms,RST-IO,BOR 2.4V 
;注意：本范例仅供参考，实际应用需评估硬件兼容性
;说明：本范例为WDT溢出时间到，唤醒休眠，翻转IOA0
;//******************************************************************************
;//===============================================================================
;//***********************************头文件**************************************
;//用户不可更改
;//===============================================================================
#INCLUDE		ZC.INC

;//===============================================================================
;//******************************定义全局变量*************************************
;//用户可以自行看需求定义变量
;//===============================================================================
; USERDATA  udata 	H'00'
; i		res    1	
; j		res    1

;//===============================================================================
;//*********************************C O D E***************************************
;//===============================================================================	
		ORG			0000H
		GOTO		MainProgram
		ORG			0008H
		GOTO		Interrupt	

;//===============================================================================
;//********************************程序主函数*************************************
;//===============================================================================			
;//------------------------------程序初始化---------------------------------------
MainProgram:
		CALL       	System_Init				;//系统初始化
		CALL       	Clr_RAM_00H_7FH			;//清零RAM
		MOVIA		0x05
		MOVAR		OSCM
;//------------------------------主函数循环---------------------------------------		
MainLoop:
		CLRWDT								;//清除看门狗
		BSET		OSCM,STOP
		NOP
		NOP
		NOP
		JBTS1		IOA,0
		GOTO		Set_IO_H
		BCLR		IOA,0
		GOTO		MainLoop
Set_IO_H:		
		BSET		IOA,0
		GOTO		MainLoop

;//===============================================================================
;//******************************中断服务子程序***********************************
;//===============================================================================
;//中断进来	
Interrupt:
		PUSH
		;//
		;//中断处理程序
		;//
Interrupt_END:	
;//中断结束
		POP
	    RETIE								;//返回A、STATUS的值

;//===============================================================================
;//**********************************系统初始化***********************************
;//系统时钟初始化：快钟、慢钟都正常工作，不进休眠
;//IO初始化:设置IO状态为输出低，且关闭上下拉
;//中断总开关：关闭总开关
;//===============================================================================		
SYSTEM_INIT:
;//-----------------------------------------------------------------------           
;//SystemInit Clock		      
		MOVIA      	0x00
        MOVAR      	OSCM
;//----------------------------------------------------------------------      
;//Init IO 
		;//IOA
		MOVIA      	0x00    	;//0:上拉关闭 1:上拉使能
        MOVAR      	PUA
        MOVIA      	0xFF    	;//0:输入 1:输出
        MOVAR      	OEA
        MOVIA      	0x00    	;//IO口数据
        MOVAR      	IOA     
        ;//IOB
		MOVIA      	0x00    
        MOVAR      	PUB
        MOVIA      	0xFF	
        MOVAR      	OEB
        MOVIA      	0x00  
        MOVAR      	IOB
		;//IOC
		MOVIA      	0x00    	
        MOVAR      	PUC
		MOVIA      	0xFF    
        MOVAR      	OEC
		MOVIA      	0x00    	
        MOVAR      	IOC 
;//----------------------------------------------------------------------      
;//中断设置  				
		BCLR     	OPTION,GIE  ;//1:总中断使能,0:屏蔽所有中断	
		RETURN

;//===============================================================================
;//*******************************RAM清零(00H~7FH)********************************
;//RAM清零：RAM区0000H~007FH全部清零
;//===============================================================================
Clr_RAM_00H_7FH:
		CLRR		FSR0   		;//从00地址开始写入
Clr_RAM_00H_7FH_LOOP:	
		MOVIA       0x00
		MOVAR		INDF0
		INCR		FSR0,1
		JBTS1		FSR0,7
		GOTO		Clr_RAM_00H_7FH_LOOP
		RETURN
		END

;//******************************END OF FILE*************************************